/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.common.ddl;

import com.jn.langx.annotation.Singleton;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.function.Supplier;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

@Singleton
public class SQLSyntaxCompatTable {
    public static final String MYSQL = "mysql";
    public static final String ORACLE = "oracle";
    public static final String SQLSERVER = "sqlserver";
    public static final String POSTGRESQL = "postgresql";
    private static final SQLSyntaxCompatTable INSTANCE = new SQLSyntaxCompatTable();
    private final Map<String, Set<String>> mapping = Collects.emptyNonAbsentHashMap((Supplier)new Supplier<String, Set<String>>(){

        public Set<String> get(String s) {
            LinkedHashSet<String> set = new LinkedHashSet<String>();
            set.add(s);
            return set;
        }
    });

    private SQLSyntaxCompatTable() {
    }

    public static SQLSyntaxCompatTable getInstance() {
        return INSTANCE;
    }

    public void register(String databaseId, String[] compatDatabaseIds) {
        this.mapping.get(databaseId).addAll(Collects.asList((Object[])compatDatabaseIds));
    }

    public void register(String databaseId, String compatDatabaseId) {
        this.mapping.get(databaseId).add(compatDatabaseId);
    }

    public Set<String> getCompatDatabases(String databaseId) {
        return this.mapping.get(databaseId);
    }

    public boolean isCompatible(String databaseId, String compatDatabaseId) {
        return this.getCompatDatabases(databaseId).contains(compatDatabaseId);
    }
}

