/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.common.er;

import com.jn.langx.annotation.Singleton;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.collection.ConcurrentReferenceHashMap;
import com.jn.langx.util.reflect.reference.ReferenceType;
import com.jn.sqlhelper.common.er.DefaultEntityTableMappingParser;
import com.jn.sqlhelper.common.er.EntityTableMapping;
import com.jn.sqlhelper.common.er.EntityTableParser;

@Singleton
public class EntityTableRegistry {
    private EntityTableParser entityTableParser = new DefaultEntityTableMappingParser();
    private ConcurrentReferenceHashMap<Class<?>, EntityTableMapping> map = new ConcurrentReferenceHashMap(1000, 0.95f, Runtime.getRuntime().availableProcessors(), ReferenceType.SOFT, ReferenceType.STRONG);

    public EntityTableMapping getEntityTableMapping(Class entityClass) {
        EntityTableMapping mapping0;
        Preconditions.checkNotNull((Object)entityClass);
        EntityTableMapping mapping = (EntityTableMapping)this.map.get((Object)entityClass);
        if (mapping == null) {
            mapping = this.entityTableParser.parse(entityClass);
            this.map.putIfAbsent((Object)entityClass, (Object)mapping);
        }
        if ((mapping0 = (EntityTableMapping)this.map.get((Object)entityClass)) != null) {
            mapping = mapping0;
        }
        return mapping;
    }
}

