/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.common.jdbc;

import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.io.IOs;
import com.jn.sqlhelper.common.jdbc.JdbcTemplate;
import com.jn.sqlhelper.common.resultset.ResultSetExtractor;
import com.jn.sqlhelper.common.resultset.RowMapper;
import com.jn.sqlhelper.common.resultset.RowMapperResultSetExtractor;
import com.jn.sqlhelper.common.resultset.SingleRecordRowMapperResultSetExtractor;
import com.jn.sqlhelper.common.statement.CallableStatementSetter;
import com.jn.sqlhelper.common.statement.ListPreparedStatementSetter;
import com.jn.sqlhelper.common.statement.PreparedStatementSetter;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import javax.sql.DataSource;

public class SqlHelperJdbcTemplate
implements JdbcTemplate {
    private DataSource dataSource;

    public SqlHelperJdbcTemplate(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public DataSource getDataSource() {
        return this.dataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(String sql) throws SQLException {
        boolean bl;
        Statement statement = null;
        Connection conn = null;
        try {
            conn = this.dataSource.getConnection();
            statement = conn.createStatement();
            bl = statement.execute(sql);
        }
        catch (Throwable throwable) {
            IOs.close(statement);
            IOs.close((Object)conn);
            throw throwable;
        }
        IOs.close((Object)statement);
        IOs.close((Object)conn);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T executeQuery(String sql, PreparedStatementSetter preparedStatementSetter, ResultSetExtractor<T> extractor, Object ... params) throws SQLException {
        T result;
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        Connection conn = null;
        try {
            conn = this.dataSource.getConnection();
            statement = conn.prepareStatement(sql);
            preparedStatementSetter.setParameters(statement, 1, params);
            resultSet = statement.executeQuery();
            result = extractor.extract(resultSet);
        }
        catch (Throwable throwable) {
            IOs.close(resultSet);
            IOs.close(statement);
            IOs.close((Object)conn);
            throw throwable;
        }
        IOs.close((Object)resultSet);
        IOs.close((Object)statement);
        IOs.close((Object)conn);
        return result;
    }

    @Override
    public <T> T executeQuery(String sql, ResultSetExtractor<T> extractor, Object ... params) throws SQLException {
        return this.executeQuery(sql, new ListPreparedStatementSetter(), extractor, Collects.asList((Object[])params));
    }

    @Override
    public <T> List<T> queryList(String sql, RowMapper<T> rowMapper, Object ... params) throws SQLException {
        RowMapperResultSetExtractor<T> extractor = new RowMapperResultSetExtractor<T>(rowMapper);
        List result = (List)this.executeQuery(sql, extractor, params);
        return result;
    }

    @Override
    public <T> T queryOne(String sql, RowMapper<T> rowMapper, Object ... params) throws SQLException {
        SingleRecordRowMapperResultSetExtractor<T> extractor = new SingleRecordRowMapperResultSetExtractor<T>(rowMapper);
        T result = this.executeQuery(sql, extractor, params);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(String sql, PreparedStatementSetter preparedStatementSetter, Object ... params) throws SQLException {
        int n;
        PreparedStatement statement = null;
        Connection conn = null;
        try {
            conn = this.dataSource.getConnection();
            statement = conn.prepareStatement(sql);
            preparedStatementSetter.setParameters(statement, 1, params);
            n = statement.executeUpdate();
        }
        catch (Throwable throwable) {
            IOs.close(statement);
            IOs.close((Object)conn);
            throw throwable;
        }
        IOs.close((Object)statement);
        IOs.close((Object)conn);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T call(String sql, List<?> params, ResultSetExtractor<T> extractor) throws SQLException {
        T result;
        CallableStatement statement = null;
        Connection conn = null;
        ResultSet resultSet = null;
        try {
            conn = this.dataSource.getConnection();
            statement = conn.prepareCall(sql);
            CallableStatementSetter callableStatementSetter = new CallableStatementSetter();
            callableStatementSetter.setParameters((PreparedStatement)statement, 1, params);
            resultSet = statement.executeQuery();
            result = extractor.extract(resultSet);
        }
        catch (Throwable throwable) {
            IOs.close(resultSet);
            IOs.close(statement);
            IOs.close((Object)conn);
            throw throwable;
        }
        IOs.close((Object)resultSet);
        IOs.close((Object)statement);
        IOs.close((Object)conn);
        return result;
    }

    private void batchUpdate() {
    }
}

