/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.common.resultset;

import com.jn.langx.annotation.Nullable;
import com.jn.langx.util.Throwables;
import com.jn.langx.util.collection.LinkedCaseInsensitiveMap;
import com.jn.sqlhelper.common.resultset.ResultSetDescription;
import com.jn.sqlhelper.common.resultset.ResultSets;
import com.jn.sqlhelper.common.resultset.RowMapper;
import java.sql.ResultSet;
import java.util.Map;

public class MapRowMapper
implements RowMapper<Map<String, Object>> {
    @Override
    public Map<String, Object> mapping(ResultSet row, int currentRowIndex, ResultSetDescription resultSetDescription) {
        int columnCount = resultSetDescription.getColumnCount();
        Map<String, Object> mapOfColumnValues = this.createColumnMap(columnCount);
        for (int i = 1; i <= columnCount; ++i) {
            String column = resultSetDescription.getColumnName(i);
            mapOfColumnValues.put(this.getColumnKey(column), this.getColumnValue(row, i));
        }
        return mapOfColumnValues;
    }

    protected String getColumnKey(String columnName) {
        return columnName;
    }

    @Nullable
    protected Object getColumnValue(ResultSet rs, int index) throws RuntimeException {
        try {
            return ResultSets.getResultSetValue(rs, index);
        }
        catch (Throwable ex) {
            throw Throwables.wrapAsRuntimeException((Throwable)ex);
        }
    }

    protected Map<String, Object> createColumnMap(int columnCount) {
        return new LinkedCaseInsensitiveMap(columnCount);
    }
}

