/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.common.sql.sqlscript;

import com.jn.langx.io.resource.AbstractLocatableResource;
import com.jn.langx.io.resource.Resource;
import com.jn.sqlhelper.common.sql.sqlscript.PlainSqlStatement;
import java.sql.SQLException;

public class PlainSqlScriptException
extends RuntimeException {
    private final Resource resource;
    private final PlainSqlStatement statement;

    public PlainSqlScriptException(Resource resource, PlainSqlStatement statement, SQLException sqlException) {
        super(sqlException);
        this.resource = resource;
        this.statement = statement;
    }

    public int getLineNumber() {
        return this.statement.getLineNumber();
    }

    public String getStatement() {
        return this.statement.getSql();
    }

    @Override
    public String getMessage() {
        SQLException cause = (SQLException)this.getCause();
        while (cause.getNextException() != null) {
            cause = cause.getNextException();
        }
        String message = "";
        message = message + "SQL State  : " + cause.getSQLState() + "\n";
        message = message + "Error Code : " + cause.getErrorCode() + "\n";
        if (cause.getMessage() != null) {
            message = message + "Message    : " + cause.getMessage().trim() + "\n";
        }
        if (this.resource != null && this.resource instanceof AbstractLocatableResource) {
            message = message + "Location   : " + ((AbstractLocatableResource)this.resource).getLocation() + "\n";
        }
        message = message + "Line       : " + this.getLineNumber() + "\n";
        message = message + "Statement  : " + this.getStatement() + "\n";
        return message;
    }
}

