/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.common.sql.sqlscript;

import com.jn.langx.Parser;
import com.jn.langx.io.resource.Resource;
import com.jn.langx.io.resource.Resources;
import com.jn.langx.util.Strings;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.function.Consumer;
import com.jn.langx.util.io.Charsets;
import com.jn.sqlhelper.common.sql.sqlscript.PlainSqlDelimiter;
import com.jn.sqlhelper.common.sql.sqlscript.PlainSqlScript;
import com.jn.sqlhelper.common.sql.sqlscript.PlainSqlStatement;
import com.jn.sqlhelper.common.sql.sqlscript.PlainSqlStatementBuilder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlainSqlScriptParser
implements Parser<PlainSqlScript, List<PlainSqlStatement>> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final PlainSqlScriptParser INSTANCE = new PlainSqlScriptParser();

    public List<PlainSqlStatement> parse(PlainSqlScript sqlScript) {
        Resource sqlScriptResource = sqlScript.getResource();
        final List lines = Collects.emptyArrayList();
        Resources.readUsingDelimiter((Resource)sqlScriptResource, (String)"\n", (Charset)Charsets.getCharset((String)sqlScript.getEncoding()), (Consumer)new Consumer<String>(){

            public void accept(String line) {
                lines.add(line);
            }
        });
        List<PlainSqlStatement> sqls = this.linesToStatements(lines);
        return sqls;
    }

    protected PlainSqlStatementBuilder newSqlStatementBuilder() {
        return new PlainSqlStatementBuilder();
    }

    protected List<PlainSqlStatement> linesToStatements(List<String> lines) {
        ArrayList<PlainSqlStatement> statements = new ArrayList<PlainSqlStatement>();
        PlainSqlDelimiter nonStandardDelimiter = null;
        PlainSqlStatementBuilder sqlStatementExtractor = this.newSqlStatementBuilder();
        for (int lineNumber = 1; lineNumber <= lines.size(); ++lineNumber) {
            String line = lines.get(lineNumber - 1);
            if (sqlStatementExtractor.isEmpty()) {
                if (Strings.isBlank((String)line)) continue;
                PlainSqlDelimiter newDelimiter = sqlStatementExtractor.extractNewDelimiterFromLine(line);
                if (newDelimiter != null) {
                    nonStandardDelimiter = newDelimiter;
                    continue;
                }
                sqlStatementExtractor.setLineNumber(lineNumber);
                if (nonStandardDelimiter != null) {
                    sqlStatementExtractor.setDelimiter(nonStandardDelimiter);
                }
            }
            sqlStatementExtractor.addLine(line);
            if (sqlStatementExtractor.isTerminated()) {
                PlainSqlStatement sqlStatement = sqlStatementExtractor.getSqlStatement();
                statements.add(sqlStatement);
                this.logger.debug("Found statement at line " + sqlStatement.getLineNumber() + ": " + sqlStatement.getSql());
                sqlStatementExtractor = this.newSqlStatementBuilder();
                continue;
            }
            if (!sqlStatementExtractor.canDiscard()) continue;
            sqlStatementExtractor = this.newSqlStatementBuilder();
        }
        if (!sqlStatementExtractor.isEmpty()) {
            statements.add(sqlStatementExtractor.getSqlStatement());
        }
        return statements;
    }
}

