/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.common.sql.sqlscript;

import com.jn.langx.util.Strings;
import com.jn.sqlhelper.common.sql.sqlscript.PlainSqlDelimiter;
import com.jn.sqlhelper.common.sql.sqlscript.PlainSqlStatement;
import java.util.ArrayList;
import java.util.List;

public class PlainSqlStatementBuilder {
    private StringBuilder statement = new StringBuilder();
    private int lineNumber;
    private boolean empty = true;
    private boolean terminated;
    private boolean insideQuoteStringLiteral = false;
    private boolean insideAlternateQuoteStringLiteral = false;
    private String alternateQuote;
    private boolean lineEndsWithSingleLineComment = false;
    private boolean insideMultiLineComment = false;
    private boolean nonCommentStatementPartSeen = false;
    private PlainSqlDelimiter delimiter = this.getDefaultDelimiter();

    protected PlainSqlDelimiter getDefaultDelimiter() {
        return new PlainSqlDelimiter(";", false);
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    public void setDelimiter(PlainSqlDelimiter delimiter) {
        this.delimiter = delimiter;
    }

    public PlainSqlDelimiter getDelimiter() {
        return this.delimiter;
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public boolean isTerminated() {
        return this.terminated;
    }

    public PlainSqlStatement getSqlStatement() {
        String sql = this.statement.toString();
        return new PlainSqlStatement(this.lineNumber, sql, this.isPgCopy());
    }

    public PlainSqlDelimiter extractNewDelimiterFromLine(String line) {
        return null;
    }

    public boolean isPgCopy() {
        return false;
    }

    public boolean isCommentDirective(String line) {
        return false;
    }

    protected boolean isSingleLineComment(String line) {
        return line.startsWith("--");
    }

    public void addLine(String line) {
        if (this.isEmpty()) {
            this.empty = false;
        } else {
            this.statement.append("\n");
        }
        String lineSimplified = this.simplifyLine(line);
        this.applyStateChanges(lineSimplified);
        if (this.endWithOpenMultilineStringLiteral() || this.insideMultiLineComment) {
            this.statement.append(line);
            return;
        }
        this.delimiter = this.changeDelimiterIfNecessary(lineSimplified, this.delimiter);
        this.statement.append(line);
        if (this.isCommentDirective(lineSimplified)) {
            this.nonCommentStatementPartSeen = true;
        }
        if (!this.lineEndsWithSingleLineComment && this.lineTerminatesStatement(lineSimplified, this.delimiter)) {
            PlainSqlStatementBuilder.stripDelimiter(this.statement, this.delimiter);
            this.terminated = true;
        }
    }

    boolean endWithOpenMultilineStringLiteral() {
        return this.insideQuoteStringLiteral || this.insideAlternateQuoteStringLiteral;
    }

    public boolean canDiscard() {
        return !this.insideAlternateQuoteStringLiteral && !this.insideQuoteStringLiteral && !this.insideMultiLineComment && !this.nonCommentStatementPartSeen;
    }

    protected String simplifyLine(String line) {
        return this.removeEscapedQuotes(line).replace("--", " -- ").replaceAll("\\s+", " ").trim().toUpperCase();
    }

    protected PlainSqlDelimiter changeDelimiterIfNecessary(String line, PlainSqlDelimiter delimiter) {
        return delimiter;
    }

    private boolean lineTerminatesStatement(String line, PlainSqlDelimiter delimiter) {
        if (delimiter == null) {
            return false;
        }
        String upperCaseDelimiter = delimiter.getDelimiter().toUpperCase();
        if (delimiter.isAloneOnLine()) {
            return line.equals(upperCaseDelimiter);
        }
        return line.endsWith(upperCaseDelimiter);
    }

    static void stripDelimiter(StringBuilder sql, PlainSqlDelimiter delimiter) {
        int last;
        for (last = sql.length(); last > 0 && Character.isWhitespace(sql.charAt(last - 1)); --last) {
        }
        sql.delete(last - delimiter.getDelimiter().length(), sql.length());
    }

    protected String extractAlternateOpenQuote(String token) {
        return null;
    }

    protected String computeAlternateCloseQuote(String openQuote) {
        return openQuote;
    }

    public static String[] tokenizeToStringArray(String str, String delimiters) {
        if (str == null) {
            return null;
        }
        String[] tokens = str.split("[" + delimiters + "]");
        for (int i = 0; i < tokens.length; ++i) {
            tokens[i] = tokens[i].trim();
        }
        return tokens;
    }

    protected void applyStateChanges(String line) {
        String[] tokens = PlainSqlStatementBuilder.tokenizeToStringArray(line, " @<>;:=|(),+{}");
        List<TokenType> delimitingTokens = this.extractStringLiteralDelimitingTokens(tokens);
        this.lineEndsWithSingleLineComment = false;
        for (TokenType delimitingToken : delimitingTokens) {
            if (!this.insideQuoteStringLiteral && !this.insideAlternateQuoteStringLiteral && TokenType.MULTI_LINE_COMMENT.equals((Object)delimitingToken)) {
                boolean bl = this.insideMultiLineComment = !this.insideMultiLineComment;
            }
            if (!this.insideQuoteStringLiteral && !this.insideAlternateQuoteStringLiteral && !this.insideMultiLineComment && TokenType.SINGLE_LINE_COMMENT.equals((Object)delimitingToken)) {
                this.lineEndsWithSingleLineComment = true;
                return;
            }
            if (!this.insideMultiLineComment && !this.insideQuoteStringLiteral && TokenType.ALTERNATE_QUOTE.equals((Object)delimitingToken)) {
                boolean bl = this.insideAlternateQuoteStringLiteral = !this.insideAlternateQuoteStringLiteral;
            }
            if (!this.insideMultiLineComment && !this.insideAlternateQuoteStringLiteral && TokenType.QUOTE.equals((Object)delimitingToken)) {
                boolean bl = this.insideQuoteStringLiteral = !this.insideQuoteStringLiteral;
            }
            if (this.insideMultiLineComment || this.insideQuoteStringLiteral || this.insideAlternateQuoteStringLiteral || !TokenType.OTHER.equals((Object)delimitingToken)) continue;
            this.nonCommentStatementPartSeen = true;
        }
    }

    private List<TokenType> extractStringLiteralDelimitingTokens(String[] tokens) {
        ArrayList<TokenType> delimitingTokens = new ArrayList<TokenType>();
        for (String token : tokens) {
            String alternateQuoteFromToken;
            String cleanToken = this.cleanToken(token);
            boolean handled = false;
            if (this.alternateQuote == null && (alternateQuoteFromToken = this.extractAlternateOpenQuote(cleanToken)) != null) {
                String closeQuote = this.computeAlternateCloseQuote(alternateQuoteFromToken);
                if (cleanToken.length() >= alternateQuoteFromToken.length() + closeQuote.length() && cleanToken.startsWith(alternateQuoteFromToken) && cleanToken.endsWith(closeQuote)) continue;
                this.alternateQuote = closeQuote;
                delimitingTokens.add(TokenType.ALTERNATE_QUOTE);
                continue;
            }
            if (this.alternateQuote != null && cleanToken.endsWith(this.alternateQuote)) {
                this.alternateQuote = null;
                delimitingTokens.add(TokenType.ALTERNATE_QUOTE);
                continue;
            }
            if (cleanToken.length() >= 2 && cleanToken.startsWith("'") && cleanToken.endsWith("'") || cleanToken.length() >= 4 && cleanToken.startsWith("/*") && cleanToken.endsWith("*/")) continue;
            if (this.isSingleLineComment(cleanToken)) {
                delimitingTokens.add(TokenType.SINGLE_LINE_COMMENT);
                handled = true;
            }
            if (cleanToken.startsWith("/*")) {
                delimitingTokens.add(TokenType.MULTI_LINE_COMMENT);
                handled = true;
            } else if (cleanToken.startsWith("'")) {
                delimitingTokens.add(TokenType.QUOTE);
                handled = true;
            }
            if (!cleanToken.startsWith("/*") && cleanToken.endsWith("*/")) {
                delimitingTokens.add(TokenType.MULTI_LINE_COMMENT);
                handled = true;
            } else if (!cleanToken.startsWith("'") && cleanToken.endsWith("'")) {
                delimitingTokens.add(TokenType.QUOTE);
                handled = true;
            }
            if (handled) continue;
            delimitingTokens.add(TokenType.OTHER);
        }
        return delimitingTokens;
    }

    protected String removeEscapedQuotes(String token) {
        return Strings.replace((String)token, (String)"''", (String)"");
    }

    protected String cleanToken(String token) {
        return token;
    }

    private static enum TokenType {
        OTHER,
        QUOTE,
        ALTERNATE_QUOTE,
        SINGLE_LINE_COMMENT,
        MULTI_LINE_COMMENT;

    }
}

