/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.common.transaction;

import com.jn.langx.annotation.NonNull;
import com.jn.langx.registry.Registry;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.function.Consumer2;
import com.jn.langx.util.function.Predicate2;
import com.jn.langx.util.struct.Holder;
import com.jn.sqlhelper.common.transaction.TransactionDefinition;
import com.jn.sqlhelper.common.transaction.definition.parser.NamedTransactionDefinitionParser;
import com.jn.sqlhelper.common.transaction.definition.parser.TransactionDefinitionAnnotationParser;
import com.jn.sqlhelper.common.transaction.definition.parser.TransactionDefinitionParser;
import com.jn.sqlhelper.common.transaction.definition.parser.TransactionalAnnotationParser;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class TransactionDefinitionRegistry
implements Registry<Method, TransactionDefinition> {
    private final ConcurrentHashMap<Method, Holder<TransactionDefinition>> methodDataSourceKeyCache = new ConcurrentHashMap();
    private Map<Class<? extends Annotation>, TransactionDefinitionAnnotationParser> annotationParserMap = new LinkedHashMap<Class<? extends Annotation>, TransactionDefinitionAnnotationParser>();
    private Map<String, NamedTransactionDefinitionParser> namedTransactionDefinitionParserMap = new LinkedHashMap<String, NamedTransactionDefinitionParser>();

    public TransactionDefinitionRegistry() {
        this.registerTransactionAnnotationParser(new TransactionalAnnotationParser());
    }

    public void register(TransactionDefinition dataSourceKeyHolder) {
        throw new UnsupportedOperationException();
    }

    public void register(Method method, TransactionDefinition dataSourceKey) {
        Preconditions.checkNotNull((Object)dataSourceKey);
        this.methodDataSourceKeyCache.putIfAbsent(method, (Holder<TransactionDefinition>)new Holder((Object)dataSourceKey));
    }

    public void register(TransactionDefinitionParser parser) {
        if (parser instanceof TransactionDefinitionAnnotationParser) {
            this.registerTransactionAnnotationParser((TransactionDefinitionAnnotationParser)parser);
        } else if (parser instanceof NamedTransactionDefinitionParser) {
            this.registerNamedTransactionParser((NamedTransactionDefinitionParser)parser);
        }
    }

    private void registerTransactionAnnotationParser(TransactionDefinitionAnnotationParser transactionDefinitionAnnotationParser) {
        if (transactionDefinitionAnnotationParser != null && transactionDefinitionAnnotationParser.getAnnotation() != null) {
            this.annotationParserMap.put(transactionDefinitionAnnotationParser.getAnnotation(), transactionDefinitionAnnotationParser);
        }
    }

    private void registerNamedTransactionParser(NamedTransactionDefinitionParser transactionDefinitionParser) {
        this.namedTransactionDefinitionParserMap.put(transactionDefinitionParser.getName(), transactionDefinitionParser);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public TransactionDefinition get(final Method method) {
        Holder<TransactionDefinition> holder = this.methodDataSourceKeyCache.get(method);
        if (holder == null) {
            TransactionDefinitionRegistry transactionDefinitionRegistry = this;
            synchronized (transactionDefinitionRegistry) {
                final Holder holder0 = new Holder();
                Collects.forEach(this.annotationParserMap, (Consumer2)new Consumer2<Class<? extends Annotation>, TransactionDefinitionAnnotationParser>(){

                    public void accept(Class<? extends Annotation> annotationClass, TransactionDefinitionAnnotationParser parser) {
                        TransactionDefinition key = parser.parse(method);
                        if (key != null) {
                            holder0.set((Object)key);
                        }
                    }
                }, (Predicate2)new Predicate2<Class<? extends Annotation>, TransactionDefinitionAnnotationParser>(){

                    public boolean test(Class<? extends Annotation> key, TransactionDefinitionAnnotationParser value) {
                        return !holder0.isNull();
                    }
                });
                Collects.forEach(this.namedTransactionDefinitionParserMap, (Consumer2)new Consumer2<String, NamedTransactionDefinitionParser>(){

                    public void accept(String parserName, NamedTransactionDefinitionParser parser) {
                        TransactionDefinition key = parser.parse(method);
                        if (key != null) {
                            holder0.set((Object)key);
                        }
                    }
                }, (Predicate2)new Predicate2<String, NamedTransactionDefinitionParser>(){

                    public boolean test(String parserName, NamedTransactionDefinitionParser value) {
                        return !holder0.isNull();
                    }
                });
                this.methodDataSourceKeyCache.putIfAbsent(method, (Holder<TransactionDefinition>)holder0);
                holder = this.methodDataSourceKeyCache.get(method);
            }
        }
        return (TransactionDefinition)holder.get();
    }
}

