/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.common.transaction.definition;

import com.jn.langx.util.Preconditions;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.function.Consumer;
import com.jn.sqlhelper.common.transaction.definition.DefaultTransactionDefinition;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleBasedTransactionDefinition
extends DefaultTransactionDefinition
implements Serializable {
    public static final String PREFIX_ROLLBACK_RULE = "-";
    public static final String PREFIX_COMMIT_RULE = "+";
    private static final Logger logger = LoggerFactory.getLogger(RuleBasedTransactionDefinition.class);
    private List<RollbackRuleAttribute> rollbackRules;

    public RuleBasedTransactionDefinition() {
    }

    public RuleBasedTransactionDefinition(List<RollbackRuleAttribute> rollbackRules) {
        this.rollbackRules = rollbackRules;
    }

    public void setRollbackRules(List<RollbackRuleAttribute> rollbackRules) {
        this.rollbackRules = rollbackRules;
    }

    public List<RollbackRuleAttribute> getRollbackRules() {
        if (this.rollbackRules == null) {
            this.rollbackRules = new LinkedList<RollbackRuleAttribute>();
        }
        return this.rollbackRules;
    }

    @Override
    public boolean rollbackOn(Throwable ex) {
        if (logger.isTraceEnabled()) {
            logger.trace("Applying rules to determine whether transaction should rollback on " + ex);
        }
        RollbackRuleAttribute winner = null;
        int deepest = Integer.MAX_VALUE;
        if (this.rollbackRules != null) {
            for (RollbackRuleAttribute rule : this.rollbackRules) {
                int depth = rule.getDepth(ex);
                if (depth < 0 || depth >= deepest) continue;
                deepest = depth;
                winner = rule;
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace("Winning rollback rule is: " + winner);
        }
        if (winner == null) {
            logger.trace("No relevant rollback rule found: applying default rules");
            return super.rollbackOn(ex);
        }
        return !(winner instanceof NoRollbackRuleAttribute);
    }

    public String toString() {
        StringBuilder result = new StringBuilder(256);
        if (this.rollbackRules != null) {
            for (RollbackRuleAttribute rule : this.rollbackRules) {
                String sign = rule instanceof NoRollbackRuleAttribute ? PREFIX_COMMIT_RULE : PREFIX_ROLLBACK_RULE;
                result.append(',').append(sign).append(rule.getExceptionName());
            }
        }
        return result.toString();
    }

    public static final List<RollbackRuleAttribute> buildRules(Class[] rollbackFor, Class[] noRollbackFor) {
        final List rules = Collects.emptyArrayList();
        Collects.forEach((Object[])noRollbackFor, (Consumer)new Consumer<Class>(){

            public void accept(Class aClass) {
                rules.add(new NoRollbackRuleAttribute(aClass));
            }
        });
        Collects.forEach((Object[])rollbackFor, (Consumer)new Consumer<Class>(){

            public void accept(Class aClass) {
                rules.add(new RollbackRuleAttribute(aClass));
            }
        });
        return rules;
    }

    public static class NoRollbackRuleAttribute
    extends RollbackRuleAttribute {
        public NoRollbackRuleAttribute(Class<?> clazz) {
            super(clazz);
        }

        public NoRollbackRuleAttribute(String exceptionName) {
            super(exceptionName);
        }

        @Override
        public String toString() {
            return "No" + super.toString();
        }
    }

    public static class RollbackRuleAttribute
    implements Serializable {
        public static final RollbackRuleAttribute ROLLBACK_ON_RUNTIME_EXCEPTIONS = new RollbackRuleAttribute(RuntimeException.class);
        private final String exceptionName;

        public RollbackRuleAttribute(Class<?> clazz) {
            Preconditions.checkNotNull(clazz, (String)"'clazz' cannot be null");
            if (!Throwable.class.isAssignableFrom(clazz)) {
                throw new IllegalArgumentException("Cannot construct rollback rule from [" + clazz.getName() + "]: it's not a Throwable");
            }
            this.exceptionName = clazz.getName();
        }

        public RollbackRuleAttribute(String exceptionName) {
            Preconditions.checkNotEmpty((Object)exceptionName, (String)"'exceptionName' cannot be null or empty");
            this.exceptionName = exceptionName;
        }

        public String getExceptionName() {
            return this.exceptionName;
        }

        public int getDepth(Throwable ex) {
            return this.getDepth(ex.getClass(), 0);
        }

        private int getDepth(Class<?> exceptionClass, int depth) {
            if (exceptionClass.getName().contains(this.exceptionName)) {
                return depth;
            }
            if (exceptionClass == Throwable.class) {
                return -1;
            }
            return this.getDepth(exceptionClass.getSuperclass(), depth + 1);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RollbackRuleAttribute)) {
                return false;
            }
            RollbackRuleAttribute rhs = (RollbackRuleAttribute)other;
            return this.exceptionName.equals(rhs.exceptionName);
        }

        public int hashCode() {
            return this.exceptionName.hashCode();
        }

        public String toString() {
            return "RollbackRuleAttribute with pattern [" + this.exceptionName + "]";
        }
    }
}

