/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.common.transaction.utils;

import com.jn.langx.annotation.NonNull;
import com.jn.langx.invocation.MethodInvocation;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.reflect.Reflects;
import com.jn.sqlhelper.common.transaction.Transaction;
import com.jn.sqlhelper.common.transaction.TransactionDefinition;
import com.jn.sqlhelper.common.transaction.TransactionManager;
import com.jn.sqlhelper.common.transaction.utils.TransactionThreadContext;
import java.lang.reflect.Method;
import org.slf4j.Logger;

public class TransactionAops {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object invoke(Logger logger, @NonNull TransactionManager transactionManager, @NonNull TransactionDefinition definition, @NonNull MethodInvocation invocation) throws Throwable {
        boolean nested;
        Preconditions.checkNotNull((Object)transactionManager, (String)"the transaction manager is null");
        Preconditions.checkNotNull((Object)definition, (String)"the transaction definition is null");
        Transaction transaction = TransactionThreadContext.get();
        boolean bl = nested = transaction != null;
        if (!nested) {
            transaction = transactionManager.createTransaction(definition);
        }
        TransactionThreadContext.bind(transaction);
        try {
            Object ret = invocation.proceed();
            if (!nested) {
                if (transaction.isRollbackOnly()) {
                    logger.warn("will rollback a invocation with the transaction is marked as rollback-only: {} ", (Object)Reflects.getMethodString((Method)invocation.getJoinPoint()));
                    transactionManager.rollback(transaction);
                } else {
                    transactionManager.commit(transaction);
                }
            }
            Object object = ret;
            return object;
        }
        catch (Throwable ex) {
            logger.error(ex.getMessage(), ex);
            boolean rollback = transaction.isRollbackOnly();
            if (!rollback) {
                rollback = definition.rollbackOn(ex);
            }
            if (!rollback) {
                if (!nested) {
                    transactionManager.commit(transaction);
                }
            } else {
                if (nested) {
                    transaction.setRollbackOnly();
                }
                transactionManager.rollback(transaction);
            }
            Throwable throwable = ex;
            return throwable;
        }
        finally {
            if (!nested) {
                TransactionThreadContext.unbind();
                transaction.clearResources();
            }
        }
    }
}

