/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.common.transaction.utils;

import com.jn.langx.util.struct.ThreadLocalHolder;
import com.jn.sqlhelper.common.transaction.Transaction;
import com.jn.sqlhelper.common.transaction.TransactionalResource;

public class TransactionThreadContext {
    private static final ThreadLocalHolder<Transaction> TRANSACTION_HOLDER = new ThreadLocalHolder();

    private TransactionThreadContext() {
    }

    public static void bind(Transaction transaction) {
        TRANSACTION_HOLDER.set((Object)transaction);
    }

    public static Transaction get() {
        return (Transaction)TRANSACTION_HOLDER.get();
    }

    public static Transaction unbind() {
        Transaction transaction = TransactionThreadContext.get();
        TRANSACTION_HOLDER.reset();
        return transaction;
    }

    public static boolean bindTransactionResource(Object key, TransactionalResource resource) {
        Transaction transaction = TransactionThreadContext.get();
        if (transaction == null) {
            return false;
        }
        transaction.bindResource(key, resource);
        return true;
    }

    public static boolean unbindTransactionResource(Object key) {
        Transaction transaction = TransactionThreadContext.get();
        if (transaction == null) {
            return false;
        }
        transaction.unbindResource(key);
        return true;
    }
}

