/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.common.utils;

import com.jn.langx.util.Strings;
import com.jn.sqlhelper.common.ddl.model.DatabaseDescription;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

public class SQLs {
    public static final String WHITESPACE = " \n\r\f\t";
    public static final String SQL_FILE_SUFFIX = ".sql";
    private static final Pattern SELECT_COUNT_PATTERN = Pattern.compile("select\\s+count.*");
    private static final Pattern COUNT_FUNCTION_PATTERN = Pattern.compile("count(\\s*\\(.*(\\s*\\))?)?");

    public static String getTableFQN(String catalog, String schema, String tableName) {
        return SQLs.getTableFQN(catalog, schema, tableName, true);
    }

    public static String getTableFQN(String catalog, String schema, String tableName, boolean catalogAtStart) {
        return SQLs.getTableFQN(catalog, schema, tableName, null, catalogAtStart);
    }

    public static String getTableFQN(String catalog, String schema, String tableName, String separator, boolean catalogAtStart) {
        if (Strings.isEmpty((String)separator)) {
            separator = ".";
        }
        String fqn = tableName;
        if (catalogAtStart) {
            if (Strings.isNotEmpty((String)schema)) {
                fqn = schema + separator + fqn;
            }
            if (Strings.isNotEmpty((String)catalog)) {
                fqn = catalog + separator + fqn;
            }
        } else {
            if (Strings.isNotEmpty((String)schema)) {
                fqn = fqn + separator + schema;
            }
            if (Strings.isNotEmpty((String)catalog)) {
                fqn = fqn + separator + catalog;
            }
        }
        return fqn;
    }

    public static String getTableFQN(DatabaseMetaData metaData, String catalog, String schema, String tableName) {
        return SQLs.getTableFQN(new DatabaseDescription(metaData), catalog, schema, tableName);
    }

    public static String getTableFQN(DatabaseDescription databaseDesc, String catalog, String schema, String tableName) {
        String catalogSeparator = databaseDesc.getCatalogSeparator();
        return SQLs.getTableFQN(catalog, schema, tableName, catalogSeparator, databaseDesc.isCatalogAtStart());
    }

    public static int findPlaceholderParameterCount(String sqlsegment) {
        if (Strings.isNotEmpty((String)sqlsegment)) {
            sqlsegment = sqlsegment.replaceAll("([\\\\][?])", "");
            sqlsegment = sqlsegment.replaceAll("[^?]", "");
            sqlsegment = sqlsegment.replaceAll("'\\?'", "");
            return sqlsegment.length();
        }
        return 0;
    }

    public static boolean isSelectStatement(String sql) {
        String sql0 = sql.trim();
        if (Strings.startsWithIgnoreCase((CharSequence)sql0, (CharSequence)"with")) {
            StringTokenizer stringTokenizer = new StringTokenizer(sql0);
            for (int i = 0; i < 5 && stringTokenizer.hasMoreTokens(); ++i) {
                String token = stringTokenizer.nextToken();
                if (!"select".equals(token.toLowerCase())) continue;
                return true;
            }
            return false;
        }
        return Strings.startsWithIgnoreCase((CharSequence)sql0, (CharSequence)"select");
    }

    public static boolean isSelectCountStatement(String sql) {
        String sql0 = sql.trim();
        if (Strings.startsWithIgnoreCase((CharSequence)sql0, (CharSequence)"with")) {
            StringTokenizer stringTokenizer = new StringTokenizer(sql0);
            int i = 0;
            boolean hasSelectKeyword = false;
            boolean hasCountKeyword = false;
            while (i < 7 && stringTokenizer.hasMoreTokens()) {
                String token = stringTokenizer.nextToken();
                if ("select".equals(token.toLowerCase())) {
                    hasSelectKeyword = true;
                    continue;
                }
                if (COUNT_FUNCTION_PATTERN.matcher(token.toLowerCase()).matches()) {
                    hasCountKeyword = true;
                }
                ++i;
            }
            return hasSelectKeyword && hasCountKeyword;
        }
        String lowerSql = sql0.toLowerCase();
        return SELECT_COUNT_PATTERN.matcher(lowerSql).matches();
    }

    public static boolean isUpdateStatement(String sql) {
        sql = sql.trim();
        return sql.toLowerCase(Locale.ROOT).replaceAll("\\s", " ").matches("update \\w+(\\.\\w)* set");
    }

    public static boolean isDeleteStatement(String sql) {
        sql = sql.trim();
        return sql.toLowerCase(Locale.ROOT).replaceAll("\\s", " ").startsWith("delete from");
    }

    public static boolean isInsertStatement(String sql) {
        sql = sql.trim();
        return sql.toLowerCase(Locale.ROOT).replaceAll("\\s", " ").startsWith("insert into");
    }

    public static boolean isCreateStatement(String sql) {
        sql = sql.trim();
        return sql.toLowerCase(Locale.ROOT).replaceAll("\\s", " ").startsWith("create table");
    }

    public static boolean isDropTableStatement(String sql) {
        sql = sql.trim();
        return sql.toLowerCase(Locale.ROOT).replaceAll("\\s", " ").startsWith("drop table");
    }

    public static boolean isQuote(String tok) {
        return "\"".equals(tok) || "`".equals(tok) || "]".equals(tok) || "[".equals(tok) || "'".equals(tok);
    }

    public static boolean isSupportsBatchUpdates(Connection conn) {
        try {
            return new DatabaseDescription(conn.getMetaData()).supportsBatchUpdates();
        }
        catch (SQLException ex) {
            return false;
        }
    }
}

