/*
 * Decompiled with CFR 0.152.
 */
package com.vip.saturn.job.console.aop.aspect;

import com.vip.saturn.job.console.aop.annotation.Audit;
import com.vip.saturn.job.console.aop.annotation.AuditParam;
import com.vip.saturn.job.console.aop.annotation.AuditType;
import com.vip.saturn.job.console.utils.AuditInfoContext;
import java.lang.annotation.Annotation;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Component
public class AuditLogAspect {
    private static final Logger log = LoggerFactory.getLogger((String)"AUDITLOG");
    private static final String UNKNOWN = "Unkown";
    private static final String GUI_AUDIT_LOG_TEMPLATE = "GUI API:[%s] path:[%s] is called by User:[%s] with IP:[%s], result is %s.";
    private static final String REST_AUDIT_LOG_TEMPLATE = "REST API:[%s] path:[%s] is called by IP:[%s], result is %s.";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="@annotation(audit)")
    public Object logAuditInfo(ProceedingJoinPoint joinPoint, Audit audit) throws Throwable {
        this.addAuditParamsIfPossible(joinPoint);
        String methodName = this.getMethodName(joinPoint, audit);
        Boolean isSuccess = Boolean.FALSE;
        try {
            Object result = joinPoint.proceed();
            isSuccess = Boolean.TRUE;
            Object object = result;
            return object;
        }
        finally {
            this.logAudit(isSuccess, audit.type(), methodName);
            AuditInfoContext.reset();
        }
    }

    private String getMethodName(ProceedingJoinPoint joinPoint, Audit audit) {
        if (StringUtils.isNotBlank((CharSequence)audit.name())) {
            return audit.name();
        }
        return joinPoint.getSignature().getName();
    }

    private void addAuditParamsIfPossible(ProceedingJoinPoint joinPoint) {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Annotation[][] annotations = signature.getMethod().getParameterAnnotations();
        int i = 0;
        for (Object arg : joinPoint.getArgs()) {
            for (Annotation annotation : annotations[i]) {
                AuditParam auditParamAnno;
                String value;
                if (annotation.annotationType() != AuditParam.class || (value = (auditParamAnno = (AuditParam)annotation).value()) == null) continue;
                AuditInfoContext.put(value, arg == null ? null : arg.toString());
            }
            ++i;
        }
    }

    private void logAudit(Boolean isSuccess, AuditType auditType, String methodName) {
        String content = null;
        switch (auditType) {
            case REST: {
                content = this.getRESTRequstContent(methodName, isSuccess);
                break;
            }
            default: {
                content = this.getWebRequestContent(methodName, isSuccess);
            }
        }
        log.info(content);
    }

    protected String getWebRequestContent(String name, Boolean isSuccess) {
        String apiName = StringUtils.isNotBlank((CharSequence)name) ? name : "";
        return this.buildLogContent(String.format(GUI_AUDIT_LOG_TEMPLATE, apiName, this.getUri(), this.getUserName(), this.getIpAddress(), this.getResultValue(isSuccess)));
    }

    protected String getRESTRequstContent(String name, Boolean isSuccess) {
        String apiName = StringUtils.isNotBlank((CharSequence)name) ? name : "";
        return this.buildLogContent(String.format(REST_AUDIT_LOG_TEMPLATE, apiName, this.getUri(), this.getIpAddress(), this.getResultValue(isSuccess)));
    }

    private String buildLogContent(String initValue) {
        StringBuilder stringBuilder = new StringBuilder(initValue);
        Map<String, String> auditInfoMap = AuditInfoContext.currentAuditInfo();
        if (auditInfoMap != null && auditInfoMap.size() > 0) {
            stringBuilder.append(" Context info:").append(auditInfoMap).append(".");
        }
        return stringBuilder.toString();
    }

    private String getUri() {
        HttpServletRequest request = this.getRequestFromContext();
        if (request == null) {
            return "";
        }
        return request.getRequestURI();
    }

    private String getIpAddress() {
        HttpServletRequest request = this.getRequestFromContext();
        if (request == null) {
            return "";
        }
        String ip = request.getHeader("X-FORWARDED-FOR");
        return StringUtils.isBlank((CharSequence)ip) ? request.getRemoteAddr() : ip;
    }

    private String getUserName() {
        HttpServletRequest request = this.getRequestFromContext();
        if (request == null) {
            return UNKNOWN;
        }
        String loginUser = (String)request.getSession().getAttribute("login_user_name");
        return StringUtils.isBlank((CharSequence)loginUser) ? UNKNOWN : loginUser;
    }

    private String getResultValue(boolean isSuccess) {
        return isSuccess ? "success" : "failed";
    }

    private HttpServletRequest getRequestFromContext() {
        return ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
    }
}

