/*
 * Decompiled with CFR 0.152.
 */
package com.vip.saturn.job.console.controller;

import com.vip.saturn.job.console.domain.RegistryCenterClient;
import com.vip.saturn.job.console.domain.RegistryCenterConfiguration;
import com.vip.saturn.job.console.domain.ZkCluster;
import com.vip.saturn.job.console.exception.SaturnJobConsoleException;
import com.vip.saturn.job.console.exception.SaturnJobConsoleHttpException;
import com.vip.saturn.job.console.service.RegistryCenterService;
import com.vip.saturn.job.console.utils.ThreadLocalCuratorClient;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class AbstractController {
    public static final String REQUEST_NAMESPACE_PARAM = "nns";
    public static final String BAD_REQ_MSG_PREFIX = "Invalid request.";
    public static final String INVALID_REQUEST_MSG = "Invalid request. Parameter: {%s} %s";
    public static final String MISSING_REQUEST_MSG = "Invalid request. Missing parameter: {%s}";
    @Resource
    protected RegistryCenterService registryCenterService;
    @Value(value="${console.version}")
    protected String version;

    public static String getStackTrace(Throwable aThrowable) {
        StringBuilder result = new StringBuilder("Trace: ");
        result.append(aThrowable.toString());
        String NEW_LINE = "<br>";
        result.append("<br>");
        for (StackTraceElement element : aThrowable.getStackTrace()) {
            result.append(element);
            result.append("<br>");
        }
        return result.toString();
    }

    public static String getClientIp(HttpServletRequest request) {
        String remoteAddr = "";
        if (request != null && ((remoteAddr = request.getHeader("X-FORWARDED-FOR")) == null || "".equals(remoteAddr))) {
            remoteAddr = request.getRemoteAddr();
        }
        return remoteAddr;
    }

    public static String checkAndGetParametersValueAsString(Map<String, Object> map, String key, boolean isMandatory) throws SaturnJobConsoleException {
        if (map.containsKey(key)) {
            String value = (String)map.get(key);
            return StringUtils.isBlank((CharSequence)value) ? null : value;
        }
        if (isMandatory) {
            throw new SaturnJobConsoleHttpException(HttpStatus.BAD_REQUEST.value(), String.format(MISSING_REQUEST_MSG, key));
        }
        return null;
    }

    public static Integer checkAndGetParametersValueAsInteger(Map<String, Object> map, String key, boolean isMandatory) throws SaturnJobConsoleException {
        if (map.containsKey(key)) {
            return (Integer)map.get(key);
        }
        if (isMandatory) {
            throw new SaturnJobConsoleHttpException(HttpStatus.BAD_REQUEST.value(), String.format(MISSING_REQUEST_MSG, key));
        }
        return null;
    }

    public static Boolean checkAndGetParametersValueAsBoolean(Map<String, Object> map, String key, boolean isMandatory) throws SaturnJobConsoleException {
        if (map.containsKey(key)) {
            return (Boolean)map.get(key);
        }
        if (isMandatory) {
            throw new SaturnJobConsoleHttpException(HttpStatus.BAD_REQUEST.value(), String.format(MISSING_REQUEST_MSG, key));
        }
        return null;
    }

    public static void checkMissingParameter(String name, String value) throws SaturnJobConsoleException {
        if (StringUtils.isBlank((CharSequence)value)) {
            throw new SaturnJobConsoleHttpException(HttpStatus.BAD_REQUEST.value(), String.format(MISSING_REQUEST_MSG, name));
        }
    }

    public void setSession(RegistryCenterClient client, HttpSession session) {
        ThreadLocalCuratorClient.setCuratorClient(client.getCuratorClient());
        RegistryCenterConfiguration conf = this.registryCenterService.findConfig(client.getNameAndNamespace());
        if (conf == null) {
            return;
        }
        session.setAttribute("activated_config", (Object)conf);
        this.setCurrentZkClusterKey(conf.getZkClusterKey(), session);
    }

    public void setCurrentZkClusterKey(String zkClusterKey, HttpSession session) {
        session.setAttribute("current_zk_cluster_key", (Object)zkClusterKey);
    }

    public String getCurrentZkClusterKey(HttpSession session) {
        String zkClusterKey = (String)session.getAttribute("current_zk_cluster_key");
        if (zkClusterKey == null) {
            Collection<ZkCluster> zks = this.registryCenterService.getZkClusterList();
            for (ZkCluster tmp : zks) {
                ZkCluster zkCluster = tmp;
                if (zkCluster.isOffline()) continue;
                this.setCurrentZkClusterKey(zkCluster.getZkClusterKey(), session);
                return zkCluster.getZkClusterKey();
            }
        }
        return zkClusterKey;
    }

    public String getCurrentZkAddr(HttpSession session) {
        ZkCluster zkCluster;
        String zkClusterKey = (String)session.getAttribute("current_zk_cluster_key");
        if (zkClusterKey != null && (zkCluster = this.registryCenterService.getZkCluster(zkClusterKey)) != null) {
            return zkCluster.getZkAddr();
        }
        Collection<ZkCluster> zks = this.registryCenterService.getZkClusterList();
        for (ZkCluster tmp : zks) {
            ZkCluster zkCluster2 = tmp;
            if (zkCluster2.isOffline()) continue;
            this.setCurrentZkClusterKey(zkCluster2.getZkClusterKey(), session);
            return zkCluster2.getZkClusterKey();
        }
        return null;
    }

    public RegistryCenterConfiguration getActivatedConfigInSession(HttpSession session) {
        return (RegistryCenterConfiguration)session.getAttribute("activated_config");
    }

    public RegistryCenterClient getClientInSession(HttpSession session) {
        RegistryCenterConfiguration reg = (RegistryCenterConfiguration)session.getAttribute("activated_config");
        if (reg == null) {
            return null;
        }
        return this.registryCenterService.getCuratorByNameAndNamespace(reg.getNameAndNamespace());
    }

    public String getNamespace() {
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        RegistryCenterConfiguration configuration = (RegistryCenterConfiguration)request.getSession().getAttribute("activated_config");
        if (configuration != null) {
            return configuration.getNamespace();
        }
        return null;
    }
}

