/*
 * Decompiled with CFR 0.152.
 */
package com.vip.saturn.job.console.controller.gui;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.vip.saturn.job.console.aop.annotation.Audit;
import com.vip.saturn.job.console.aop.annotation.AuditParam;
import com.vip.saturn.job.console.controller.SuccessResponseEntity;
import com.vip.saturn.job.console.controller.gui.AbstractGUIController;
import com.vip.saturn.job.console.domain.JobConfigMeta;
import com.vip.saturn.job.console.domain.RequestResult;
import com.vip.saturn.job.console.domain.SystemConfigVo;
import com.vip.saturn.job.console.exception.SaturnJobConsoleException;
import com.vip.saturn.job.console.mybatis.entity.SystemConfig;
import com.vip.saturn.job.console.service.SystemConfigService;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@RequestMapping(value={"/console/configs/console"})
public class ConsoleConfigController
extends AbstractGUIController {
    protected static final ObjectMapper YAML_OBJ_MAPPER = new ObjectMapper((JsonFactory)new YAMLFactory());
    @Resource
    private SystemConfigService systemConfigService;
    @Value(value="classpath:system-config-meta.yaml")
    private org.springframework.core.io.Resource configYaml;

    @ApiResponses(value={@ApiResponse(code=200, message="Success/Fail", response=RequestResult.class)})
    @Audit
    @PostMapping(value={"/create"})
    public SuccessResponseEntity createConfig(@AuditParam(value="key") @RequestParam String key, @AuditParam(value="value") @RequestParam String value) throws SaturnJobConsoleException {
        this.assertIsPermitted("systemConfig");
        if ("EXECUTOR_CONFIGS".equals(key)) {
            throw new SaturnJobConsoleException(String.format("\u914d\u7f6e\u9879\u4e0d\u80fd\u4e3a%s", key));
        }
        SystemConfig systemConfig = new SystemConfig();
        systemConfig.setProperty(key);
        systemConfig.setValue(value);
        this.systemConfigService.createConfig(systemConfig);
        return new SuccessResponseEntity();
    }

    @ApiResponses(value={@ApiResponse(code=200, message="Success/Fail", response=RequestResult.class)})
    @Audit
    @PostMapping(value={"/update"})
    public SuccessResponseEntity updateConfig(@AuditParam(value="key") @RequestParam String key, @AuditParam(value="value") @RequestParam String value) throws SaturnJobConsoleException {
        this.assertIsPermitted("systemConfig");
        if ("EXECUTOR_CONFIGS".equals(key)) {
            throw new SaturnJobConsoleException(String.format("\u914d\u7f6e\u9879\u4e0d\u80fd\u4e3a%s", key));
        }
        SystemConfig systemConfig = new SystemConfig();
        systemConfig.setProperty(key);
        systemConfig.setValue(value);
        this.systemConfigService.updateConfig(systemConfig);
        return new SuccessResponseEntity();
    }

    @ApiResponses(value={@ApiResponse(code=200, message="Success/Fail", response=RequestResult.class)})
    @GetMapping
    public SuccessResponseEntity getConfigs() throws IOException, SaturnJobConsoleException {
        this.assertIsPermitted("systemConfig");
        Map<String, List<JobConfigMeta>> jobConfigGroups = this.getSystemConfigMeta();
        List<SystemConfig> systemConfigs = this.systemConfigService.getSystemConfigsDirectly(null);
        this.removeExecutorConfigs(systemConfigs);
        return new SuccessResponseEntity(this.genSystemConfigInfo(jobConfigGroups, systemConfigs));
    }

    @ApiResponses(value={@ApiResponse(code=200, message="Success/Fail", response=RequestResult.class)})
    @GetMapping(value={"/env"})
    public SuccessResponseEntity getEnvConfig() {
        return new SuccessResponseEntity(this.systemConfigService.getValueDirectly("ENV"));
    }

    private void removeExecutorConfigs(List<SystemConfig> systemConfigs) {
        if (systemConfigs == null) {
            return;
        }
        Iterator<SystemConfig> iterator = systemConfigs.iterator();
        while (iterator.hasNext()) {
            SystemConfig systemConfig = iterator.next();
            if (!"EXECUTOR_CONFIGS".equals(systemConfig.getProperty())) continue;
            iterator.remove();
        }
    }

    private Map<String, List<SystemConfigVo>> genSystemConfigInfo(Map<String, List<JobConfigMeta>> jobConfigGroups, List<SystemConfig> systemConfigs) {
        Map<String, SystemConfig> systemConfigMap = this.convertList2Map(systemConfigs);
        HashMap jobConfigDisplayInfoMap = Maps.newHashMap();
        HashSet categorizedConfigKeySet = Sets.newHashSet();
        for (Map.Entry<String, List<JobConfigMeta>> group : jobConfigGroups.entrySet()) {
            List<JobConfigMeta> jobConfigMetas = group.getValue();
            ArrayList jobConfigVos = Lists.newArrayListWithCapacity((int)jobConfigMetas.size());
            for (JobConfigMeta configMeta : jobConfigMetas) {
                String configName = configMeta.getName();
                SystemConfig systemConfig = systemConfigMap.get(configName);
                String value = systemConfig != null ? systemConfig.getValue() : null;
                jobConfigVos.add(new SystemConfigVo(configName, value, configMeta.getDesc_zh()));
                categorizedConfigKeySet.add(configName);
            }
            jobConfigDisplayInfoMap.put(group.getKey(), jobConfigVos);
        }
        if (categorizedConfigKeySet.size() != systemConfigs.size()) {
            List<SystemConfigVo> unCategorizedJobConfigVos = this.getUncategorizedSystemConfigs(systemConfigs, categorizedConfigKeySet);
            jobConfigDisplayInfoMap.put("other_configs", unCategorizedJobConfigVos);
        }
        return jobConfigDisplayInfoMap;
    }

    private List<SystemConfigVo> getUncategorizedSystemConfigs(List<SystemConfig> systemConfigList, Set<String> configKeySet) {
        ArrayList unCategorizedJobConfigVos = Lists.newArrayList();
        for (SystemConfig systemConfig : systemConfigList) {
            String property = systemConfig.getProperty();
            if (configKeySet.contains(property)) continue;
            unCategorizedJobConfigVos.add(new SystemConfigVo(property, systemConfig.getValue(), ""));
        }
        return unCategorizedJobConfigVos;
    }

    private Map<String, List<JobConfigMeta>> getSystemConfigMeta() throws IOException {
        TypeReference<HashMap<String, List<JobConfigMeta>>> typeRef = new TypeReference<HashMap<String, List<JobConfigMeta>>>(){};
        return (Map)YAML_OBJ_MAPPER.readValue(this.configYaml.getInputStream(), (TypeReference)typeRef);
    }

    private Map<String, SystemConfig> convertList2Map(List<SystemConfig> configList) {
        HashMap configMap = Maps.newHashMap();
        for (SystemConfig config : configList) {
            if (configMap.containsKey(config.getProperty())) continue;
            configMap.put(config.getProperty(), config);
        }
        return configMap;
    }

    public SystemConfigService getSystemConfigService() {
        return this.systemConfigService;
    }
}

