/*
 * Decompiled with CFR 0.152.
 */
package com.vip.saturn.job.console.controller.gui;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.vip.saturn.job.console.aop.annotation.Audit;
import com.vip.saturn.job.console.aop.annotation.AuditParam;
import com.vip.saturn.job.console.controller.SuccessResponseEntity;
import com.vip.saturn.job.console.controller.gui.AbstractGUIController;
import com.vip.saturn.job.console.domain.RequestResult;
import com.vip.saturn.job.console.domain.ZkCluster;
import com.vip.saturn.job.console.exception.SaturnJobConsoleException;
import com.vip.saturn.job.console.mybatis.entity.SaturnStatistics;
import com.vip.saturn.job.console.service.DashboardService;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@RequestMapping(value={"/console/dashboard"})
public class DashboardController
extends AbstractGUIController {
    @Autowired
    private DashboardService dashboardService;

    @ApiResponses(value={@ApiResponse(code=200, message="Success/Fail", response=RequestResult.class)})
    @GetMapping(value={"/count"})
    public SuccessResponseEntity getStatistics(@RequestParam(required=false) String zkClusterKey) throws SaturnJobConsoleException {
        HashMap countMap = Maps.newHashMap();
        int executorInDockerCount = 0;
        int executorNotInDockerCount = 0;
        int jobCount = 0;
        int domainCount = 0;
        ArrayList zkClusters = null;
        if (StringUtils.isNotBlank((CharSequence)zkClusterKey)) {
            ZkCluster zkCluster = this.registryCenterService.getZkCluster(zkClusterKey);
            zkClusters = Lists.newArrayList();
            zkClusters.add(zkCluster);
        } else {
            zkClusters = this.registryCenterService.getZkClusterList();
        }
        for (ZkCluster zkCluster : zkClusters) {
            if (zkCluster.isOffline()) continue;
            String zkAddr = zkCluster.getZkAddr();
            if (zkAddr != null) {
                executorInDockerCount += this.dashboardService.executorInDockerCount(zkAddr);
                executorNotInDockerCount += this.dashboardService.executorNotInDockerCount(zkAddr);
                jobCount += this.dashboardService.jobCount(zkAddr);
            }
            domainCount += this.registryCenterService.domainCount(zkCluster.getZkClusterKey());
        }
        countMap.put("executorInDockerCount", executorInDockerCount);
        countMap.put("executorNotInDockerCount", executorNotInDockerCount);
        countMap.put("jobCount", jobCount);
        countMap.put("domainCount", domainCount);
        return new SuccessResponseEntity(countMap);
    }

    @ApiResponses(value={@ApiResponse(code=200, message="Success/Fail", response=RequestResult.class)})
    @GetMapping(value={"/top10FailJob"})
    public SuccessResponseEntity top10FailJob(@RequestParam(required=false) String zkClusterKey) throws SaturnJobConsoleException {
        if (StringUtils.isNotBlank((CharSequence)zkClusterKey)) {
            ZkCluster zkCluster = this.checkAndGetZkCluster(zkClusterKey);
            SaturnStatistics ss = this.dashboardService.top10FailureJob(zkCluster.getZkAddr());
            return ss == null ? new SuccessResponseEntity() : new SuccessResponseEntity(ss.getResult());
        }
        return new SuccessResponseEntity(this.dashboardService.top10FailureJobByAllZkCluster());
    }

    private ZkCluster checkAndGetZkCluster(String zkClusterKey) throws SaturnJobConsoleException {
        ZkCluster zkCluster = this.registryCenterService.getZkCluster(zkClusterKey);
        if (zkCluster == null) {
            throw new SaturnJobConsoleException(1, "zk clsuter " + zkClusterKey + "\u4e0d\u5b58\u5728");
        }
        return zkCluster;
    }

    @ApiResponses(value={@ApiResponse(code=200, message="Success/Fail", response=RequestResult.class)})
    @GetMapping(value={"/top10FailExecutor"})
    public SuccessResponseEntity top10FailExecutor(@RequestParam(required=false) String zkClusterKey) throws SaturnJobConsoleException {
        if (StringUtils.isNotBlank((CharSequence)zkClusterKey)) {
            ZkCluster zkCluster = this.checkAndGetZkCluster(zkClusterKey);
            SaturnStatistics ss = this.dashboardService.top10FailureExecutor(zkCluster.getZkAddr());
            return ss == null ? new SuccessResponseEntity() : new SuccessResponseEntity(ss.getResult());
        }
        return new SuccessResponseEntity(this.dashboardService.top10FailureExecutorByAllZkCluster());
    }

    @ApiResponses(value={@ApiResponse(code=200, message="Success/Fail", response=RequestResult.class)})
    @GetMapping(value={"/top10ActiveJob"})
    public SuccessResponseEntity top10ActiveJob(@RequestParam(required=false) String zkClusterKey) throws SaturnJobConsoleException {
        if (StringUtils.isNotBlank((CharSequence)zkClusterKey)) {
            ZkCluster zkCluster = this.checkAndGetZkCluster(zkClusterKey);
            SaturnStatistics ss = this.dashboardService.top10AactiveJob(zkCluster.getZkAddr());
            return ss == null ? new SuccessResponseEntity() : new SuccessResponseEntity(ss.getResult());
        }
        return new SuccessResponseEntity(this.dashboardService.top10AactiveJobByAllZkCluster());
    }

    @ApiResponses(value={@ApiResponse(code=200, message="Success/Fail", response=RequestResult.class)})
    @GetMapping(value={"/top10LoadJob"})
    public SuccessResponseEntity top10LoadJob(@RequestParam(required=false) String zkClusterKey) throws SaturnJobConsoleException {
        if (StringUtils.isNotBlank((CharSequence)zkClusterKey)) {
            ZkCluster zkCluster = this.checkAndGetZkCluster(zkClusterKey);
            SaturnStatistics ss = this.dashboardService.top10LoadJob(zkCluster.getZkAddr());
            return ss == null ? new SuccessResponseEntity() : new SuccessResponseEntity(ss.getResult());
        }
        return new SuccessResponseEntity(this.dashboardService.top10LoadJobByAllZkCluster());
    }

    @ApiResponses(value={@ApiResponse(code=200, message="Success/Fail", response=RequestResult.class)})
    @GetMapping(value={"/top10FailDomain"})
    public SuccessResponseEntity top10FailDomain(@RequestParam(required=false) String zkClusterKey) throws SaturnJobConsoleException {
        if (StringUtils.isNotBlank((CharSequence)zkClusterKey)) {
            ZkCluster zkCluster = this.checkAndGetZkCluster(zkClusterKey);
            SaturnStatistics ss = this.dashboardService.top10FailureDomain(zkCluster.getZkAddr());
            return ss == null ? new SuccessResponseEntity() : new SuccessResponseEntity(ss.getResult());
        }
        return new SuccessResponseEntity(this.dashboardService.top10FailureDomainByAllZkCluster());
    }

    @ApiResponses(value={@ApiResponse(code=200, message="Success/Fail", response=RequestResult.class)})
    @GetMapping(value={"/top10UnstableDomain"})
    public SuccessResponseEntity top10UnstableDomain(@RequestParam(required=false) String zkClusterKey) throws SaturnJobConsoleException {
        if (StringUtils.isNotBlank((CharSequence)zkClusterKey)) {
            ZkCluster zkCluster = this.checkAndGetZkCluster(zkClusterKey);
            SaturnStatistics ss = this.dashboardService.top10UnstableDomain(zkCluster.getZkAddr());
            return ss == null ? new SuccessResponseEntity() : new SuccessResponseEntity(ss.getResult());
        }
        return new SuccessResponseEntity(this.dashboardService.top10UnstableDomainByAllZkCluster());
    }

    @ApiResponses(value={@ApiResponse(code=200, message="Success/Fail", response=RequestResult.class)})
    @GetMapping(value={"/top10LoadExecutor"})
    public SuccessResponseEntity top10LoadExecutor(@RequestParam(required=false) String zkClusterKey) throws SaturnJobConsoleException {
        if (StringUtils.isNotBlank((CharSequence)zkClusterKey)) {
            ZkCluster zkCluster = this.checkAndGetZkCluster(zkClusterKey);
            SaturnStatistics ss = this.dashboardService.top10LoadExecutor(zkCluster.getZkAddr());
            return ss == null ? new SuccessResponseEntity() : new SuccessResponseEntity(ss.getResult());
        }
        return new SuccessResponseEntity(this.dashboardService.top10LoadExecutorByAllZkCluster());
    }

    @ApiResponses(value={@ApiResponse(code=200, message="Success/Fail", response=RequestResult.class)})
    @GetMapping(value={"/domainProcessCount"})
    public SuccessResponseEntity domainProcessCount(@RequestParam(required=false) String zkClusterKey) throws SaturnJobConsoleException {
        if (StringUtils.isNotBlank((CharSequence)zkClusterKey)) {
            ZkCluster zkCluster = this.checkAndGetZkCluster(zkClusterKey);
            SaturnStatistics ss = this.dashboardService.allProcessAndErrorCountOfTheDay(zkCluster.getZkAddr());
            return ss == null ? new SuccessResponseEntity() : new SuccessResponseEntity(ss.getResult());
        }
        return new SuccessResponseEntity(this.dashboardService.allProcessAndErrorCountOfTheDayByAllZkCluster());
    }

    @ApiResponses(value={@ApiResponse(code=200, message="Success/Fail", response=RequestResult.class)})
    @GetMapping(value={"/domainRank"})
    public SuccessResponseEntity loadDomainRank(@RequestParam(required=false) String zkClusterKey) throws SaturnJobConsoleException {
        if (StringUtils.isNotBlank((CharSequence)zkClusterKey)) {
            return new SuccessResponseEntity(this.dashboardService.loadDomainRankDistribution(zkClusterKey));
        }
        return new SuccessResponseEntity(this.dashboardService.loadDomainRankDistributionByAllZkCluster());
    }

    @ApiResponses(value={@ApiResponse(code=200, message="Success/Fail", response=RequestResult.class)})
    @GetMapping(value={"/jobRank"})
    public SuccessResponseEntity loadJobRank(@RequestParam(required=false) String zkClusterKey) throws SaturnJobConsoleException {
        if (StringUtils.isNotBlank((CharSequence)zkClusterKey)) {
            ZkCluster zkCluster = this.checkAndGetZkCluster(zkClusterKey);
            return new SuccessResponseEntity(this.dashboardService.loadJobRankDistribution(zkCluster.getZkAddr()));
        }
        return new SuccessResponseEntity(this.dashboardService.loadJobRankDistributionByAllZkCluster());
    }

    @ApiResponses(value={@ApiResponse(code=200, message="Success/Fail", response=RequestResult.class)})
    @GetMapping(value={"/domainExecutorVersionNumber"})
    public SuccessResponseEntity versionDomainNumber(@RequestParam(required=false) String zkClusterKey) throws SaturnJobConsoleException {
        if (StringUtils.isNotBlank((CharSequence)zkClusterKey)) {
            ZkCluster zkCluster = this.checkAndGetZkCluster(zkClusterKey);
            return new SuccessResponseEntity(this.dashboardService.versionDomainNumber(zkCluster.getZkAddr()));
        }
        return new SuccessResponseEntity(this.dashboardService.versionDomainNumberByAllZkCluster());
    }

    @ApiResponses(value={@ApiResponse(code=200, message="Success/Fail", response=RequestResult.class)})
    @GetMapping(value={"/executorVersionNumber"})
    public SuccessResponseEntity versionExecutorNumber(@RequestParam(required=false) String zkClusterKey) throws SaturnJobConsoleException {
        if (StringUtils.isNotBlank((CharSequence)zkClusterKey)) {
            ZkCluster zkCluster = this.checkAndGetZkCluster(zkClusterKey);
            return new SuccessResponseEntity(this.dashboardService.versionExecutorNumber(zkCluster.getZkAddr()));
        }
        return new SuccessResponseEntity(this.dashboardService.versionExecutorNumberByAllZkCluster());
    }

    @ApiResponses(value={@ApiResponse(code=200, message="Success/Fail", response=RequestResult.class)})
    @Audit
    @PostMapping(value={"/namespaces/{namespace:.+}/shardingCount/clean"})
    public SuccessResponseEntity cleanShardingCount(@PathVariable String namespace) throws SaturnJobConsoleException {
        this.assertIsSystemAdmin();
        this.dashboardService.cleanShardingCount(namespace);
        return new SuccessResponseEntity();
    }

    @ApiResponses(value={@ApiResponse(code=200, message="Success/Fail", response=RequestResult.class)})
    @Audit
    @PostMapping(value={"/namespaces/{namespace:.+}/jobs/{jobName}/jobAnalyse/clean"})
    public SuccessResponseEntity cleanJobAnalyse(@AuditParam(value="namespace") @PathVariable String namespace, @AuditParam(value="jobName") @PathVariable String jobName) throws SaturnJobConsoleException {
        this.assertIsSystemAdmin();
        this.dashboardService.cleanOneJobAnalyse(namespace, jobName);
        return new SuccessResponseEntity();
    }

    @ApiResponses(value={@ApiResponse(code=200, message="Success/Fail", response=RequestResult.class)})
    @Audit
    @PostMapping(value={"/namespaces/{namespace:.+}/jobAnalyse/clean"})
    public SuccessResponseEntity cleanJobsAnalyse(@AuditParam(value="namespace") @PathVariable String namespace) throws SaturnJobConsoleException {
        this.assertIsSystemAdmin();
        this.dashboardService.cleanAllJobAnalyse(namespace);
        return new SuccessResponseEntity();
    }

    @ApiResponses(value={@ApiResponse(code=200, message="Success/Fail", response=RequestResult.class)})
    @Audit
    @PostMapping(value={"/namespaces/{namespace:.+}/jobs/{jobName}/jobExecutorCount/clean"})
    public SuccessResponseEntity cleanJobExecutorCount(@AuditParam(value="namespace") @PathVariable String namespace, @AuditParam(value="jobName") @PathVariable String jobName) throws SaturnJobConsoleException {
        this.assertIsSystemAdmin();
        this.dashboardService.cleanOneJobExecutorCount(namespace, jobName);
        return new SuccessResponseEntity();
    }
}

