/*
 * Decompiled with CFR 0.152.
 */
package com.vip.saturn.job.console.controller.gui;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.vip.saturn.job.console.aop.annotation.Audit;
import com.vip.saturn.job.console.aop.annotation.AuditParam;
import com.vip.saturn.job.console.controller.SuccessResponseEntity;
import com.vip.saturn.job.console.controller.gui.AbstractGUIController;
import com.vip.saturn.job.console.domain.RequestResult;
import com.vip.saturn.job.console.domain.ZkCluster;
import com.vip.saturn.job.console.exception.SaturnJobConsoleException;
import com.vip.saturn.job.console.mybatis.entity.SystemConfig;
import com.vip.saturn.job.console.repository.zookeeper.CuratorRepository;
import com.vip.saturn.job.console.service.SystemConfigService;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@RequestMapping(value={"/console/configs/executor"})
public class ExecutorConfigController
extends AbstractGUIController {
    private static final Logger log = LoggerFactory.getLogger(ExecutorConfigController.class);
    @Resource
    private SystemConfigService systemConfigService;

    @ApiResponses(value={@ApiResponse(code=200, message="Success/Fail", response=RequestResult.class)})
    @Audit
    @PostMapping
    public SuccessResponseEntity createOrUpdateConfig(@AuditParam(value="key") @RequestParam String key, @AuditParam(value="value") @RequestParam String value) throws SaturnJobConsoleException {
        this.assertIsPermitted("systemConfig");
        String executorConfigsJsonInDB = this.systemConfigService.getValueDirectly("EXECUTOR_CONFIGS");
        JSONObject jsonObject = this.parseExecutorConfigJson(executorConfigsJsonInDB);
        if (jsonObject == null) {
            jsonObject = new JSONObject();
        }
        jsonObject.put(key.trim(), (Object)value.trim());
        String configStr = jsonObject.toJSONString();
        log.info("Start to update executor config data {}", (Object)configStr);
        List<ZkCluster> onlineZkClusterList = this.registryCenterService.getOnlineZkClusterList();
        for (ZkCluster zkCluster : onlineZkClusterList) {
            this.updateConfigInZk(configStr, zkCluster);
        }
        SystemConfig systemConfig = new SystemConfig();
        systemConfig.setProperty("EXECUTOR_CONFIGS");
        systemConfig.setValue(configStr);
        this.systemConfigService.insertOrUpdate(systemConfig);
        log.info("Update executor config to db successfully");
        return new SuccessResponseEntity();
    }

    @ApiResponses(value={@ApiResponse(code=200, message="Success/Fail", response=RequestResult.class)})
    @GetMapping
    public SuccessResponseEntity getConfigs() throws SaturnJobConsoleException {
        this.assertIsPermitted("systemConfig");
        String executorConfigsJsonInDB = this.systemConfigService.getValueDirectly("EXECUTOR_CONFIGS");
        JSONObject jsonObject = this.parseExecutorConfigJson(executorConfigsJsonInDB);
        if (jsonObject == null) {
            return new SuccessResponseEntity(Lists.newArrayList());
        }
        ArrayList result = new ArrayList();
        Set keys = jsonObject.keySet();
        for (String key : keys) {
            HashMap<String, String> element = new HashMap<String, String>();
            element.put("key", key);
            element.put("value", jsonObject.getString(key));
            result.add(element);
        }
        return new SuccessResponseEntity(result);
    }

    private JSONObject parseExecutorConfigJson(String jsonStr) {
        if (StringUtils.isBlank((CharSequence)jsonStr)) {
            return null;
        }
        try {
            return JSON.parseObject((String)jsonStr.trim());
        }
        catch (Throwable t) {
            log.error("Fail to parse data from json string" + jsonStr, t);
            return null;
        }
    }

    private void updateConfigInZk(String configStr, ZkCluster zkCluster) {
        CuratorRepository.CuratorFrameworkOp curatorFrameworkOp = zkCluster.getCuratorFrameworkOp();
        if (curatorFrameworkOp == null) {
            return;
        }
        String dataInZk = curatorFrameworkOp.getData("/$SaturnSelf/saturn-executor/config");
        if (configStr.equals(dataInZk)) {
            return;
        }
        curatorFrameworkOp.update("/$SaturnSelf/saturn-executor/config", configStr);
        log.info("Update executor config to zkcluster {} successfully", (Object)zkCluster.getZkClusterKey());
    }
}

