/*
 * Decompiled with CFR 0.152.
 */
package com.vip.saturn.job.console.controller.gui;

import com.google.common.collect.Lists;
import com.vip.saturn.job.console.aop.annotation.Audit;
import com.vip.saturn.job.console.aop.annotation.AuditParam;
import com.vip.saturn.job.console.controller.SuccessResponseEntity;
import com.vip.saturn.job.console.controller.gui.AbstractGUIController;
import com.vip.saturn.job.console.domain.RequestResult;
import com.vip.saturn.job.console.domain.ServerBriefInfo;
import com.vip.saturn.job.console.domain.ServerStatus;
import com.vip.saturn.job.console.exception.SaturnJobConsoleException;
import com.vip.saturn.job.console.service.ExecutorService;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@RequestMapping(value={"/console/namespaces/{namespace:.+}/executors"})
public class ExecutorOverviewController
extends AbstractGUIController {
    private static final Logger log = LoggerFactory.getLogger(ExecutorOverviewController.class);
    private static final String TRAFFIC_OPERATION_EXTRACT = "extract";
    private static final String TRAFFIC_OPERATION_RECOVER = "recover";
    @Resource
    private ExecutorService executorService;

    @ApiResponses(value={@ApiResponse(code=200, message="Success/Fail", response=RequestResult.class)})
    @GetMapping
    public SuccessResponseEntity getExecutors(HttpServletRequest request, @PathVariable String namespace, @RequestParam(required=false) String status) throws SaturnJobConsoleException {
        if ("online".equalsIgnoreCase(status)) {
            return new SuccessResponseEntity(this.executorService.getExecutors(namespace, ServerStatus.ONLINE));
        }
        return new SuccessResponseEntity(this.executorService.getExecutors(namespace));
    }

    @ApiResponses(value={@ApiResponse(code=200, message="Success/Fail", response=RequestResult.class)})
    @GetMapping(value={"/{executorName}/allocationWithStatus"})
    public SuccessResponseEntity getExecutorAllocationWithStatus(HttpServletRequest request, @PathVariable String namespace, @PathVariable String executorName) throws SaturnJobConsoleException {
        return new SuccessResponseEntity(this.executorService.getExecutorAllocation(namespace, executorName));
    }

    @ApiResponses(value={@ApiResponse(code=200, message="Success/Fail", response=RequestResult.class)})
    @GetMapping(value={"/{executorName}/runningInfo"})
    public SuccessResponseEntity getExecutorRunningInfo(HttpServletRequest request, @PathVariable String namespace, @PathVariable String executorName) throws SaturnJobConsoleException {
        return new SuccessResponseEntity(this.executorService.getExecutorRunningInfo(namespace, executorName));
    }

    @ApiResponses(value={@ApiResponse(code=200, message="Success/Fail", response=RequestResult.class)})
    @Audit
    @PostMapping(value={"/shardAll"})
    public SuccessResponseEntity shardAll(HttpServletRequest request, @AuditParam(value="namespace") @PathVariable String namespace) throws SaturnJobConsoleException {
        this.assertIsPermitted("executor:shardAllAtOnce", namespace);
        this.executorService.shardAll(namespace);
        return new SuccessResponseEntity();
    }

    @ApiResponses(value={@ApiResponse(code=200, message="Success/Fail", response=RequestResult.class)})
    @Audit
    @PostMapping(value={"/{executorName}/traffic"})
    public SuccessResponseEntity extractOrRecoverTraffic(HttpServletRequest request, @AuditParam(value="namespace") @PathVariable String namespace, @AuditParam(value="executorName") @PathVariable String executorName, @AuditParam(value="operation") @RequestParam String operation) throws SaturnJobConsoleException {
        this.assertIsPermitted("executor:extractOrRecoverTraffic", namespace);
        this.extractOrRecoverTraffic(namespace, executorName, operation);
        return new SuccessResponseEntity();
    }

    @ApiResponses(value={@ApiResponse(code=200, message="Success/Fail", response=RequestResult.class)})
    @Audit
    @PostMapping(value={"/traffic"})
    public SuccessResponseEntity batchExtractOrRecoverTraffic(HttpServletRequest request, @AuditParam(value="namespace") @PathVariable String namespace, @AuditParam(value="executorNames") @RequestParam List<String> executorNames, @AuditParam(value="operation") @RequestParam String operation) throws SaturnJobConsoleException {
        this.assertIsPermitted("executor:batchExtractOrRecoverTraffic", namespace);
        ArrayList success2ExtractOrRecoverTrafficExecutors = Lists.newArrayList();
        ArrayList fail2ExtractOrRecoverTrafficExecutors = Lists.newArrayList();
        for (String executorName : executorNames) {
            try {
                this.extractOrRecoverTraffic(namespace, executorName, operation);
                success2ExtractOrRecoverTrafficExecutors.add(executorName);
            }
            catch (Exception e) {
                log.warn("exception happens during extract or recover traffic of executor:" + executorName, (Throwable)e);
                fail2ExtractOrRecoverTrafficExecutors.add(executorName);
            }
        }
        if (!fail2ExtractOrRecoverTrafficExecutors.isEmpty()) {
            StringBuilder message = new StringBuilder();
            message.append("\u64cd\u4f5c\u6210\u529f\u7684executor:").append(success2ExtractOrRecoverTrafficExecutors).append("\uff0c").append("\u64cd\u4f5c\u5931\u8d25\u7684executor:").append(fail2ExtractOrRecoverTrafficExecutors);
            throw new SaturnJobConsoleException(message.toString());
        }
        return new SuccessResponseEntity();
    }

    private void extractOrRecoverTraffic(String namespace, String executorName, String operation) throws SaturnJobConsoleException {
        if (TRAFFIC_OPERATION_EXTRACT.equals(operation)) {
            this.executorService.extractTraffic(namespace, executorName);
        } else if (TRAFFIC_OPERATION_RECOVER.equals(operation)) {
            this.executorService.recoverTraffic(namespace, executorName);
        } else {
            throw new SaturnJobConsoleException(2, "operation " + operation + "\u4e0d\u652f\u6301");
        }
    }

    @ApiResponses(value={@ApiResponse(code=200, message="Success/Fail", response=RequestResult.class)})
    @Audit
    @DeleteMapping(value={"/{executorName}"})
    public SuccessResponseEntity removeExecutor(HttpServletRequest request, @AuditParam(value="namespace") @PathVariable String namespace, @AuditParam(value="executorName") @PathVariable String executorName) throws SaturnJobConsoleException {
        this.assertIsPermitted("executor:remove", namespace);
        this.checkExecutorStatus(namespace, executorName, ServerStatus.OFFLINE, "Executor\u5728\u7ebf\uff0c\u4e0d\u80fd\u79fb\u9664");
        this.executorService.removeExecutor(namespace, executorName);
        return new SuccessResponseEntity();
    }

    @ApiResponses(value={@ApiResponse(code=200, message="Success/Fail", response=RequestResult.class)})
    @Audit
    @DeleteMapping
    public SuccessResponseEntity batchRemoveExecutors(HttpServletRequest request, @AuditParam(value="namespace") @PathVariable String namespace, @AuditParam(value="executorNames") @RequestParam List<String> executorNames) throws SaturnJobConsoleException {
        this.assertIsPermitted("executor:batchRemove", namespace);
        ArrayList success2RemoveExecutors = Lists.newArrayList();
        ArrayList fail2RemoveExecutors = Lists.newArrayList();
        for (String executorName : executorNames) {
            try {
                this.checkExecutorStatus(namespace, executorName, ServerStatus.OFFLINE, "Executor\u5728\u7ebf\uff0c\u4e0d\u80fd\u79fb\u9664");
                this.executorService.removeExecutor(namespace, executorName);
                success2RemoveExecutors.add(executorName);
            }
            catch (Exception e) {
                log.warn("exception happens during remove executor:" + executorName, (Throwable)e);
                fail2RemoveExecutors.add(executorName);
            }
        }
        if (!fail2RemoveExecutors.isEmpty()) {
            StringBuilder message = new StringBuilder();
            message.append("\u5220\u9664\u6210\u529f\u7684executor:").append(success2RemoveExecutors).append("\uff0c").append("\u5220\u9664\u5931\u8d25\u7684executor:").append(fail2RemoveExecutors);
            throw new SaturnJobConsoleException(message.toString());
        }
        return new SuccessResponseEntity();
    }

    private void checkExecutorStatus(String namespace, String executorName, ServerStatus status, String errMsg) throws SaturnJobConsoleException {
        ServerBriefInfo executorInfo = this.executorService.getExecutor(namespace, executorName);
        if (executorInfo == null) {
            throw new SaturnJobConsoleException(1, "Executor\u4e0d\u5b58\u5728");
        }
        if (status != executorInfo.getStatus()) {
            throw new SaturnJobConsoleException(2, errMsg);
        }
    }

    @ApiResponses(value={@ApiResponse(code=200, message="Success/Fail", response=RequestResult.class)})
    @Audit
    @PostMapping(value={"/{executorName}/dump"})
    public SuccessResponseEntity dump(HttpServletRequest request, @AuditParam(value="namespace") @PathVariable String namespace, @AuditParam(value="executorName") @PathVariable String executorName) throws SaturnJobConsoleException {
        this.checkExecutorStatus(namespace, executorName, ServerStatus.ONLINE, "Executor\u5fc5\u987b\u5728\u7ebf\u624d\u53ef\u4ee5dump");
        this.executorService.dump(namespace, executorName);
        return new SuccessResponseEntity();
    }

    @ApiResponses(value={@ApiResponse(code=200, message="Success/Fail", response=RequestResult.class)})
    @Audit
    @PostMapping(value={"/{executorName}/restart"})
    public SuccessResponseEntity restart(HttpServletRequest request, @AuditParam(value="namespace") @PathVariable String namespace, @AuditParam(value="executorName") @PathVariable String executorName) throws SaturnJobConsoleException {
        this.assertIsPermitted("executor:restart", namespace);
        this.checkExecutorStatus(namespace, executorName, ServerStatus.ONLINE, "Executor\u5fc5\u987b\u5728\u7ebf\u624d\u53ef\u4ee5\u91cd\u542f");
        this.executorService.restart(namespace, executorName);
        return new SuccessResponseEntity();
    }
}

