/*
 * Decompiled with CFR 0.152.
 */
package com.vip.saturn.job.console.controller.gui;

import com.vip.saturn.job.console.controller.SuccessResponseEntity;
import com.vip.saturn.job.console.controller.gui.AbstractGUIController;
import com.vip.saturn.job.console.domain.RegistryCenterConfiguration;
import com.vip.saturn.job.console.domain.RequestResult;
import com.vip.saturn.job.console.exception.SaturnJobConsoleException;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;

@RequestMapping(value={"/console/namespaces"})
public class HomeController
extends AbstractGUIController {
    @ApiResponses(value={@ApiResponse(code=200, message="Success/Fail", response=RequestResult.class)})
    @GetMapping
    public SuccessResponseEntity getNamespaces(HttpServletRequest request) throws SaturnJobConsoleException {
        ArrayList<String> namespaceList = new ArrayList<String>();
        List<String> temp = this.registryCenterService.getNamespaces();
        if (temp != null) {
            namespaceList.addAll(temp);
        }
        return new SuccessResponseEntity(namespaceList);
    }

    @ApiResponses(value={@ApiResponse(code=200, message="Success/Fail", response=RequestResult.class)})
    @GetMapping(value={"/{namespace:.+}"}, produces={"application/json;charset=UTF-8"})
    public SuccessResponseEntity getNamespace(HttpServletRequest request, @PathVariable String namespace) throws SaturnJobConsoleException {
        RegistryCenterConfiguration registryCenterConfiguration = this.registryCenterService.findConfigByNamespace(namespace);
        if (registryCenterConfiguration == null) {
            throw new SaturnJobConsoleException(1, "\u8be5\u57df\u540d\uff08" + namespace + "\uff09\u4e0d\u5b58\u5728");
        }
        return new SuccessResponseEntity(registryCenterConfiguration);
    }
}

