/*
 * Decompiled with CFR 0.152.
 */
package com.vip.saturn.job.console.controller.gui;

import com.vip.saturn.job.console.aop.annotation.Audit;
import com.vip.saturn.job.console.aop.annotation.AuditParam;
import com.vip.saturn.job.console.controller.SuccessResponseEntity;
import com.vip.saturn.job.console.controller.gui.AbstractGUIController;
import com.vip.saturn.job.console.domain.RequestResult;
import com.vip.saturn.job.console.exception.SaturnJobConsoleException;
import com.vip.saturn.job.console.service.JobService;
import com.vip.saturn.job.console.vo.UpdateJobConfigVo;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;

@RequestMapping(value={"/console/namespaces/{namespace:.+}/jobs/{jobName}/config"})
public class JobConfigController
extends AbstractGUIController {
    @Resource
    private JobService jobService;

    @ApiResponses(value={@ApiResponse(code=200, message="Success/Fail", response=RequestResult.class)})
    @GetMapping
    public SuccessResponseEntity getJobConfig(HttpServletRequest request, @AuditParam(value="namespace") @PathVariable String namespace, @AuditParam(value="jobName") @PathVariable String jobName) throws SaturnJobConsoleException {
        return new SuccessResponseEntity(this.jobService.getJobConfigVo(namespace, jobName));
    }

    @ApiResponses(value={@ApiResponse(code=200, message="Success/Fail", response=RequestResult.class)})
    @Audit
    @PostMapping
    public SuccessResponseEntity updateJobConfig(HttpServletRequest request, @AuditParam(value="namespace") @PathVariable String namespace, @AuditParam(value="jobName") @PathVariable String jobName, UpdateJobConfigVo updateJobConfigVo) throws SaturnJobConsoleException {
        this.assertIsPermitted("job:update", namespace);
        this.jobService.updateJobConfig(namespace, updateJobConfigVo.toJobConfig(), this.getCurrentLoginUserName());
        return new SuccessResponseEntity();
    }

    @ApiResponses(value={@ApiResponse(code=200, message="Success/Fail", response=RequestResult.class)})
    @Audit
    @PostMapping(value={"/runAtOnce"})
    public SuccessResponseEntity runAtOnce(@AuditParam(value="namespace") @PathVariable String namespace, @AuditParam(value="jobName") @PathVariable String jobName) throws SaturnJobConsoleException {
        this.assertIsPermitted("job:runAtOnce", namespace);
        this.jobService.runAtOnce(namespace, jobName);
        return new SuccessResponseEntity();
    }

    @ApiResponses(value={@ApiResponse(code=200, message="Success/Fail", response=RequestResult.class)})
    @Audit
    @PostMapping(value={"/stopAtOnce"})
    public SuccessResponseEntity stopAtOnce(@AuditParam(value="namespace") @PathVariable String namespace, @AuditParam(value="jobName") @PathVariable String jobName) throws SaturnJobConsoleException {
        this.assertIsPermitted("job:stopAtOnce", namespace);
        this.jobService.stopAtOnce(namespace, jobName);
        return new SuccessResponseEntity();
    }
}

