/*
 * Decompiled with CFR 0.152.
 */
package com.vip.saturn.job.console.controller.gui;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.vip.saturn.job.console.aop.annotation.Audit;
import com.vip.saturn.job.console.aop.annotation.AuditParam;
import com.vip.saturn.job.console.controller.SuccessResponseEntity;
import com.vip.saturn.job.console.controller.gui.AbstractGUIController;
import com.vip.saturn.job.console.domain.AbnormalJob;
import com.vip.saturn.job.console.domain.DependencyJob;
import com.vip.saturn.job.console.domain.JobConfig;
import com.vip.saturn.job.console.domain.JobOverviewJobVo;
import com.vip.saturn.job.console.domain.JobOverviewVo;
import com.vip.saturn.job.console.domain.JobStatus;
import com.vip.saturn.job.console.domain.JobType;
import com.vip.saturn.job.console.domain.RequestResult;
import com.vip.saturn.job.console.exception.SaturnJobConsoleException;
import com.vip.saturn.job.console.service.AlarmStatisticsService;
import com.vip.saturn.job.console.service.JobService;
import com.vip.saturn.job.console.utils.AuditInfoContext;
import com.vip.saturn.job.console.utils.PageableUtil;
import com.vip.saturn.job.console.utils.SaturnBeanUtils;
import com.vip.saturn.job.console.utils.SaturnConsoleUtils;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Pageable;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

@RequestMapping(value={"/console/namespaces/{namespace:.+}/jobs"})
public class JobOverviewController
extends AbstractGUIController {
    private static final Logger log = LoggerFactory.getLogger(JobOverviewController.class);
    private static final String QUERY_CONDITION_STATUS = "status";
    private static final String QUERY_CONDITION_GROUP = "groups";
    @Resource
    private JobService jobService;
    @Resource
    private AlarmStatisticsService alarmStatisticsService;

    @ApiResponses(value={@ApiResponse(code=200, message="Success/Fail", response=RequestResult.class)})
    @GetMapping
    public SuccessResponseEntity getJobsWithCondition(HttpServletRequest request, @PathVariable String namespace, @RequestParam Map<String, Object> condition, @RequestParam(required=false, defaultValue="1") int page, @RequestParam(required=false, defaultValue="25") int size) throws SaturnJobConsoleException {
        String statusStr;
        JobStatus jobStatus;
        if (condition.containsKey(QUERY_CONDITION_STATUS) && (jobStatus = JobStatus.getJobStatus(statusStr = JobOverviewController.checkAndGetParametersValueAsString(condition, QUERY_CONDITION_STATUS, false))) != null) {
            return new SuccessResponseEntity(this.getJobOverviewByStatusAndPage(namespace, jobStatus, condition, page, size));
        }
        return new SuccessResponseEntity(this.getJobOverviewByPage(namespace, condition, page, size));
    }

    @ApiResponses(value={@ApiResponse(code=200, message="Success/Fail", response=RequestResult.class)})
    @GetMapping(value={"/counts"})
    public SuccessResponseEntity countJobsStatus(HttpServletRequest request, @PathVariable String namespace) {
        return new SuccessResponseEntity(this.countJobOverviewVo(namespace));
    }

    @ApiResponses(value={@ApiResponse(code=200, message="Success/Fail", response=RequestResult.class)})
    @GetMapping(value={"/names"})
    public SuccessResponseEntity getJobNames(@PathVariable String namespace) throws SaturnJobConsoleException {
        return new SuccessResponseEntity(this.jobService.getJobNames(namespace));
    }

    @ApiResponses(value={@ApiResponse(code=200, message="Success/Fail", response=RequestResult.class)})
    @GetMapping(value={"/sharding/status"})
    public SuccessResponseEntity getJobsShardingStatus(@PathVariable String namespace, @RequestParam(required=false) List<String> jobNames) throws SaturnJobConsoleException {
        HashMap<String, String> jobShardingMap = new HashMap<String, String>();
        if (!CollectionUtils.isEmpty(jobNames)) {
            for (String jobName : jobNames) {
                boolean isAllocated;
                JobStatus jobStatus = this.jobService.getJobStatus(namespace, jobName);
                boolean bl = isAllocated = !JobStatus.STOPPED.equals((Object)jobStatus) && this.jobService.isJobShardingAllocatedExecutor(namespace, jobName);
                if (isAllocated) {
                    jobShardingMap.put(jobName, "\u5df2\u5206\u914d");
                    continue;
                }
                jobShardingMap.put(jobName, "\u672a\u5206\u914d");
            }
        }
        return new SuccessResponseEntity(jobShardingMap);
    }

    private JobOverviewVo getJobOverviewByPage(String namespace, Map<String, Object> condition, int page, int size) throws SaturnJobConsoleException {
        JobOverviewVo jobOverviewVo = new JobOverviewVo();
        try {
            this.preHandleCondition(condition);
            List<JobConfig> unSystemJobs = this.jobService.getUnSystemJobsWithCondition(namespace, condition, page, size);
            if (unSystemJobs == null || unSystemJobs.isEmpty()) {
                jobOverviewVo.setJobs(Lists.newArrayList());
                jobOverviewVo.setTotalNumber(0);
                return jobOverviewVo;
            }
            List<JobOverviewJobVo> jobOverviewList = this.updateJobOverviewDetail(namespace, unSystemJobs, null);
            jobOverviewVo.setJobs(jobOverviewList);
            jobOverviewVo.setTotalNumber(this.jobService.countUnSystemJobsWithCondition(namespace, condition));
        }
        catch (SaturnJobConsoleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SaturnJobConsoleException(e);
        }
        return jobOverviewVo;
    }

    private JobOverviewVo getJobOverviewByStatusAndPage(String namespace, JobStatus jobStatus, Map<String, Object> condition, int page, int size) throws SaturnJobConsoleException {
        JobOverviewVo jobOverviewVo = new JobOverviewVo();
        try {
            this.preHandleStatusAndCondition(condition, jobStatus);
            List<JobConfig> unSystemJobs = this.jobService.getUnSystemJobsWithCondition(namespace, condition, page, size);
            if (unSystemJobs == null || unSystemJobs.isEmpty()) {
                jobOverviewVo.setJobs(Lists.newArrayList());
                jobOverviewVo.setTotalNumber(0);
                return jobOverviewVo;
            }
            Pageable pageable = PageableUtil.generatePageble(page, size);
            List<JobConfig> targetJobs = this.getJobSubListByPage(unSystemJobs, pageable);
            List<JobOverviewJobVo> jobOverviewList = this.updateJobOverviewDetail(namespace, targetJobs, jobStatus);
            jobOverviewVo.setJobs(jobOverviewList);
            jobOverviewVo.setTotalNumber(unSystemJobs.size());
        }
        catch (SaturnJobConsoleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SaturnJobConsoleException(e);
        }
        return jobOverviewVo;
    }

    private void preHandleCondition(Map<String, Object> condition) {
        if (condition.containsKey(QUERY_CONDITION_GROUP) && "\u672a\u5206\u7ec4".equals(condition.get(QUERY_CONDITION_GROUP))) {
            condition.put(QUERY_CONDITION_GROUP, "");
        }
    }

    private void preHandleStatusAndCondition(Map<String, Object> condition, JobStatus jobStatus) {
        condition.put("jobStatus", (Object)jobStatus);
        if (JobStatus.STOPPED.equals((Object)jobStatus) || JobStatus.STOPPING.equals((Object)jobStatus)) {
            condition.put("isEnabled", 0);
        } else {
            condition.put("isEnabled", 1);
        }
    }

    private void updateAbnormalJobSizeInOverview(String namespace, JobOverviewVo jobOverviewVo) {
        try {
            List<AbnormalJob> abnormalJobList = this.alarmStatisticsService.getAbnormalJobListByNamespace(namespace);
            jobOverviewVo.setAbnormalNumber(abnormalJobList.size());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private List<JobOverviewJobVo> updateJobOverviewDetail(String namespace, List<JobConfig> unSystemJobs, JobStatus jobStatus) {
        ArrayList result = Lists.newArrayList();
        for (JobConfig jobConfig : unSystemJobs) {
            try {
                jobConfig.setDefaultValues();
                JobOverviewJobVo jobOverviewJobVo = new JobOverviewJobVo();
                SaturnBeanUtils.copyProperties(jobConfig, jobOverviewJobVo);
                this.updateJobTypesInOverview(jobConfig, jobOverviewJobVo);
                if (StringUtils.isBlank((CharSequence)jobOverviewJobVo.getGroups())) {
                    jobOverviewJobVo.setGroups("\u672a\u5206\u7ec4");
                }
                if (jobStatus == null) {
                    jobOverviewJobVo.setStatus(this.jobService.getJobStatus(namespace, jobConfig));
                } else {
                    jobOverviewJobVo.setStatus(jobStatus);
                }
                result.add(jobOverviewJobVo);
            }
            catch (Exception e) {
                log.error("list job " + jobConfig.getJobName() + " error", (Throwable)e);
            }
        }
        return result;
    }

    private void updateJobTypesInOverview(JobConfig jobConfig, JobOverviewJobVo jobOverviewJobVo) {
        JobType jobType = JobType.getJobType(jobConfig.getJobType());
        if (JobType.UNKOWN_JOB.equals((Object)jobType)) {
            if (jobOverviewJobVo.getJobClass() != null && jobOverviewJobVo.getJobClass().indexOf("SaturnScriptJob") != -1) {
                jobOverviewJobVo.setJobType(JobType.SHELL_JOB.name());
            } else {
                jobOverviewJobVo.setJobType(JobType.JAVA_JOB.name());
            }
        }
    }

    protected List<JobConfig> getJobSubListByPage(List<JobConfig> unSystemJobs, Pageable pageable) {
        int toIndex;
        int totalCount = unSystemJobs.size();
        int offset = pageable.getOffset();
        int end = offset + pageable.getPageSize();
        int fromIndex = totalCount >= offset ? offset : -1;
        int n = toIndex = totalCount >= end ? end : totalCount;
        if (fromIndex == -1 || fromIndex > toIndex) {
            return Lists.newArrayList();
        }
        return unSystemJobs.subList(fromIndex, toIndex);
    }

    private JobOverviewVo countJobOverviewVo(String namespace) {
        JobOverviewVo jobOverviewVo = new JobOverviewVo();
        jobOverviewVo.setTotalNumber(this.jobService.countUnSystemJobsWithCondition(namespace, Maps.newHashMap()));
        jobOverviewVo.setEnabledNumber(this.jobService.countEnabledUnSystemJobs(namespace));
        this.updateAbnormalJobSizeInOverview(namespace, jobOverviewVo);
        return jobOverviewVo;
    }

    @ApiResponses(value={@ApiResponse(code=200, message="Success/Fail", response=RequestResult.class)})
    @GetMapping(value={"/groups"})
    public SuccessResponseEntity getGroups(HttpServletRequest request, @PathVariable String namespace) throws SaturnJobConsoleException {
        return new SuccessResponseEntity(this.jobService.getGroups(namespace));
    }

    @ApiResponses(value={@ApiResponse(code=200, message="Success/Fail", response=RequestResult.class)})
    @GetMapping(value={"/{jobName}/dependency"})
    public SuccessResponseEntity getDependingJobs(HttpServletRequest request, @PathVariable String namespace, @PathVariable String jobName) throws SaturnJobConsoleException {
        List<DependencyJob> dependencyJobs = this.jobService.getDependingJobs(namespace, jobName);
        return new SuccessResponseEntity(dependencyJobs);
    }

    @ApiResponses(value={@ApiResponse(code=200, message="Success/Fail", response=RequestResult.class)})
    @GetMapping(value={"/dependency"})
    public SuccessResponseEntity batchGetDependingJob(HttpServletRequest request, @PathVariable String namespace, @RequestParam List<String> jobNames) throws SaturnJobConsoleException {
        HashMap<String, List<DependencyJob>> dependencyJobsMap = new HashMap<String, List<DependencyJob>>();
        for (String jobName : jobNames) {
            List<DependencyJob> dependencyJobs = this.jobService.getDependingJobs(namespace, jobName);
            dependencyJobsMap.put(jobName, dependencyJobs);
        }
        return new SuccessResponseEntity(dependencyJobsMap);
    }

    @ApiResponses(value={@ApiResponse(code=200, message="Success/Fail", response=RequestResult.class)})
    @GetMapping(value={"/{jobName}/beDependedJobs"})
    public SuccessResponseEntity getDependedJobs(HttpServletRequest request, @PathVariable String namespace, @PathVariable String jobName) throws SaturnJobConsoleException {
        List<DependencyJob> dependedJobs = this.jobService.getDependedJobs(namespace, jobName);
        return new SuccessResponseEntity(dependedJobs);
    }

    @ApiResponses(value={@ApiResponse(code=200, message="Success/Fail", response=RequestResult.class)})
    @GetMapping(value={"/beDependedJobs"})
    public SuccessResponseEntity batchGetDependedJobs(HttpServletRequest request, @PathVariable String namespace, @RequestParam List<String> jobNames) throws SaturnJobConsoleException {
        HashMap<String, List<DependencyJob>> dependencyJobsMap = new HashMap<String, List<DependencyJob>>();
        for (String jobName : jobNames) {
            List<DependencyJob> dependedJobs = this.jobService.getDependedJobs(namespace, jobName);
            dependencyJobsMap.put(jobName, dependedJobs);
        }
        return new SuccessResponseEntity(dependencyJobsMap);
    }

    @ApiResponses(value={@ApiResponse(code=200, message="Success/Fail", response=RequestResult.class)})
    @Audit
    @PostMapping(value={"/{jobName}/enable"})
    public SuccessResponseEntity enableJob(HttpServletRequest request, @AuditParam(value="namespace") @PathVariable String namespace, @AuditParam(value="jobName") @PathVariable String jobName) throws SaturnJobConsoleException {
        this.assertIsPermitted("job:enable", namespace);
        this.jobService.enableJob(namespace, jobName, this.getCurrentLoginUserName());
        return new SuccessResponseEntity();
    }

    @ApiResponses(value={@ApiResponse(code=200, message="Success/Fail", response=RequestResult.class)})
    @Audit
    @PostMapping(value={"/enable"})
    public SuccessResponseEntity batchEnableJob(HttpServletRequest request, @AuditParam(value="namespace") @PathVariable String namespace, @AuditParam(value="jobNames") @RequestParam List<String> jobNames) throws SaturnJobConsoleException {
        this.assertIsPermitted("job:batchEnable", namespace);
        String userName = this.getCurrentLoginUserName();
        for (String jobName : jobNames) {
            this.jobService.enableJob(namespace, jobName, userName);
        }
        return new SuccessResponseEntity();
    }

    @ApiResponses(value={@ApiResponse(code=200, message="Success/Fail", response=RequestResult.class)})
    @Audit
    @PostMapping(value={"/{jobName}/disable"})
    public SuccessResponseEntity disableJob(HttpServletRequest request, @AuditParam(value="namespace") @PathVariable String namespace, @AuditParam(value="jobName") @PathVariable String jobName) throws SaturnJobConsoleException {
        this.assertIsPermitted("job:disable", namespace);
        this.jobService.disableJob(namespace, jobName, this.getCurrentLoginUserName());
        return new SuccessResponseEntity();
    }

    @ApiResponses(value={@ApiResponse(code=200, message="Success/Fail", response=RequestResult.class)})
    @Audit
    @PostMapping(value={"/disable"})
    public SuccessResponseEntity batchDisableJob(HttpServletRequest request, @AuditParam(value="namespace") @PathVariable String namespace, @AuditParam(value="jobNames") @RequestParam List<String> jobNames) throws SaturnJobConsoleException {
        this.assertIsPermitted("job:batchDisable", namespace);
        String userName = this.getCurrentLoginUserName();
        for (String jobName : jobNames) {
            this.jobService.disableJob(namespace, jobName, userName);
        }
        return new SuccessResponseEntity();
    }

    @ApiResponses(value={@ApiResponse(code=200, message="Success/Fail", response=RequestResult.class)})
    @Audit
    @DeleteMapping(value={"/{jobName}"})
    public SuccessResponseEntity removeJob(HttpServletRequest request, @AuditParam(value="namespace") @PathVariable String namespace, @AuditParam(value="jobName") @PathVariable String jobName) throws SaturnJobConsoleException {
        this.assertIsPermitted("job:remove", namespace);
        this.jobService.removeJob(namespace, jobName);
        return new SuccessResponseEntity();
    }

    @ApiResponses(value={@ApiResponse(code=200, message="Success/Fail", response=RequestResult.class)})
    @Audit
    @DeleteMapping
    public SuccessResponseEntity batchRemoveJob(HttpServletRequest request, @AuditParam(value="namespace") @PathVariable String namespace, @AuditParam(value="jobNames") @RequestParam List<String> jobNames) throws SaturnJobConsoleException {
        this.assertIsPermitted("job:batchRemove", namespace);
        ArrayList<String> successJobNames = new ArrayList<String>();
        ArrayList<String> failJobNames = new ArrayList<String>();
        for (String jobName : jobNames) {
            try {
                this.jobService.removeJob(namespace, jobName);
                successJobNames.add(jobName);
            }
            catch (Exception e) {
                failJobNames.add(jobName);
                log.info("remove job failed, cause of {}", (Throwable)e);
            }
        }
        if (!failJobNames.isEmpty()) {
            StringBuilder message = new StringBuilder();
            message.append("\u5220\u9664\u6210\u529f\u7684\u4f5c\u4e1a:").append(successJobNames).append("\uff0c").append("\u5220\u9664\u5931\u8d25\u7684\u4f5c\u4e1a:").append(failJobNames);
            throw new SaturnJobConsoleException(message.toString());
        }
        return new SuccessResponseEntity();
    }

    @ApiResponses(value={@ApiResponse(code=200, message="Success/Fail", response=RequestResult.class)})
    @Audit
    @PostMapping(value={"/preferExecutors"})
    public SuccessResponseEntity batchSetPreferExecutors(HttpServletRequest request, @AuditParam(value="namespace") @PathVariable String namespace, @AuditParam(value="jobNames") @RequestParam List<String> jobNames, @AuditParam(value="preferList") @RequestParam String preferList) throws SaturnJobConsoleException {
        this.assertIsPermitted("job:batchSetPreferExecutors", namespace);
        String userName = this.getCurrentLoginUserName();
        for (String jobName : jobNames) {
            this.jobService.setPreferList(namespace, jobName, preferList, userName);
        }
        return new SuccessResponseEntity();
    }

    @ApiResponses(value={@ApiResponse(code=200, message="Success/Fail", response=RequestResult.class)})
    @Audit
    @PostMapping(value={"/jobs"})
    public SuccessResponseEntity createJob(HttpServletRequest request, @AuditParam(value="namespace") @PathVariable String namespace, JobConfig jobConfig) throws SaturnJobConsoleException {
        this.assertIsPermitted("job:add", namespace);
        this.jobService.addJob(namespace, jobConfig, this.getCurrentLoginUserName());
        return new SuccessResponseEntity();
    }

    @ApiResponses(value={@ApiResponse(code=200, message="Success/Fail", response=RequestResult.class)})
    @Audit
    @PostMapping(value={"/{jobNameCopied}/copy"})
    public SuccessResponseEntity copyJob(HttpServletRequest request, @AuditParam(value="namespace") @PathVariable String namespace, @AuditParam(value="jobNameCopied") @PathVariable String jobNameCopied, JobConfig jobConfig) throws SaturnJobConsoleException {
        this.assertIsPermitted("job:copy", namespace);
        this.jobService.copyJob(namespace, jobConfig, jobNameCopied, this.getCurrentLoginUserName());
        return new SuccessResponseEntity();
    }

    @ApiResponses(value={@ApiResponse(code=200, message="Success/Fail", response=RequestResult.class)})
    @Audit
    @PostMapping(value={"/import"})
    public SuccessResponseEntity importJobs(HttpServletRequest request, @AuditParam(value="namespace") @PathVariable String namespace, @RequestParam(value="file") MultipartFile file) throws SaturnJobConsoleException {
        this.assertIsPermitted("job:import", namespace);
        if (file.isEmpty()) {
            throw new SaturnJobConsoleException(2, "\u8bf7\u4e0a\u4f20\u4e00\u4e2a\u6709\u5185\u5bb9\u7684\u6587\u4ef6");
        }
        String originalFilename = file.getOriginalFilename();
        if (originalFilename == null || !originalFilename.endsWith(".xls")) {
            throw new SaturnJobConsoleException(2, "\u4ec5\u652f\u6301.xls\u6587\u4ef6\u5bfc\u5165");
        }
        AuditInfoContext.put("originalFilename", originalFilename);
        return new SuccessResponseEntity(this.jobService.importJobs(namespace, file, this.getCurrentLoginUserName()));
    }

    @ApiResponses(value={@ApiResponse(code=200, message="Success/Fail", response=RequestResult.class)})
    @Audit
    @GetMapping(value={"/export"})
    public void exportJobs(HttpServletRequest request, @AuditParam(value="namespace") @PathVariable String namespace, HttpServletResponse response) throws SaturnJobConsoleException {
        File exportJobFile = this.jobService.exportJobs(namespace);
        String currentTime = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
        String exportFileName = namespace + "_allJobs_" + currentTime + ".xls";
        SaturnConsoleUtils.exportFile(response, exportJobFile, exportFileName, true);
    }

    @ApiResponses(value={@ApiResponse(code=200, message="Success/Fail", response=RequestResult.class)})
    @GetMapping(value={"/{jobName}/executors"})
    public SuccessResponseEntity getExecutors(HttpServletRequest request, @PathVariable String namespace, @PathVariable String jobName) throws SaturnJobConsoleException {
        return new SuccessResponseEntity(this.jobService.getCandidateExecutors(namespace, jobName));
    }
}

