/*
 * Decompiled with CFR 0.152.
 */
package com.vip.saturn.job.console.controller.gui;

import com.vip.saturn.job.console.SaturnEnvProperties;
import com.vip.saturn.job.console.aop.annotation.Audit;
import com.vip.saturn.job.console.aop.annotation.AuditParam;
import com.vip.saturn.job.console.controller.SuccessResponseEntity;
import com.vip.saturn.job.console.controller.gui.AbstractGUIController;
import com.vip.saturn.job.console.domain.AddContainerModel;
import com.vip.saturn.job.console.domain.container.ContainerConfig;
import com.vip.saturn.job.console.domain.container.ContainerToken;
import com.vip.saturn.job.console.exception.SaturnJobConsoleException;
import com.vip.saturn.job.console.service.MarathonService;
import com.vip.saturn.job.console.utils.CronExpression;
import com.vip.saturn.job.console.utils.SaturnConstants;
import java.text.ParseException;
import java.util.HashMap;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@RequestMapping(value={"/console/{namespace:.+}/marathon"})
public class MarathonController
extends AbstractGUIController {
    @Resource
    private MarathonService marathonService;

    @GetMapping(value={"/token"})
    public SuccessResponseEntity getToken(@PathVariable String namespace) throws SaturnJobConsoleException {
        return new SuccessResponseEntity(this.marathonService.getContainerToken(namespace));
    }

    @Audit
    @PostMapping(value={"/token"})
    public SuccessResponseEntity saveToken(@AuditParam(value="namespace") @PathVariable String namespace, @AuditParam(value="userName") @RequestParam String userName, @AuditParam(value="password") @RequestParam String password) throws SaturnJobConsoleException {
        this.marathonService.saveContainerToken(namespace, new ContainerToken(userName, password));
        return new SuccessResponseEntity();
    }

    @GetMapping(value={"/containerVos"})
    public SuccessResponseEntity getContainerVos(@PathVariable String namespace) throws SaturnJobConsoleException {
        return new SuccessResponseEntity(this.marathonService.getContainerVos(namespace));
    }

    @PostMapping(value={"/container"})
    @ResponseBody
    public SuccessResponseEntity addContainer(@AuditParam(value="namespace") @PathVariable String namespace, AddContainerModel addContainerModel, HttpServletRequest request) throws SaturnJobConsoleException {
        if (addContainerModel.getContainerToken() == null) {
            throw new SaturnJobConsoleException("Please input container token");
        }
        this.marathonService.checkContainerTokenNotNull(namespace, addContainerModel.getContainerToken());
        this.marathonService.saveOrUpdateContainerTokenIfNecessary(namespace, addContainerModel.getContainerToken());
        ContainerConfig containerConfig = new ContainerConfig();
        containerConfig.setTaskId(addContainerModel.getTaskId());
        containerConfig.setCmd(addContainerModel.getCmd());
        containerConfig.setCpus(addContainerModel.getCpus());
        containerConfig.setMem(addContainerModel.getMem());
        containerConfig.setInstances(addContainerModel.getInstances());
        containerConfig.setConstraints(addContainerModel.getConstraints());
        containerConfig.setEnv(addContainerModel.getEnv());
        containerConfig.setPrivileged(addContainerModel.getPrivileged() == null ? false : addContainerModel.getPrivileged());
        containerConfig.setForcePullImage(addContainerModel.getForcePullImage() == null ? true : addContainerModel.getForcePullImage());
        containerConfig.setParameters(addContainerModel.getParameters());
        containerConfig.setVolumes(addContainerModel.getVolumes());
        containerConfig.setImage(addContainerModel.getImage());
        containerConfig.setCreateTime(System.currentTimeMillis());
        String imageNew = "";
        String vipSaturnDcosRegistryUri = SaturnEnvProperties.VIP_SATURN_DCOS_REGISTRY_URI;
        if (vipSaturnDcosRegistryUri == null || vipSaturnDcosRegistryUri.trim().length() == 0) {
            throw new SaturnJobConsoleException("VIP_SATURN_DCOS_REGISTRY_URI is not configured");
        }
        if (vipSaturnDcosRegistryUri.startsWith("http://")) {
            String tmp = vipSaturnDcosRegistryUri.substring("http://".length());
            while (tmp.endsWith("/")) {
                tmp = tmp.substring(0, tmp.length() - 1);
            }
            imageNew = tmp + "/" + addContainerModel.getImage();
        } else if (vipSaturnDcosRegistryUri.startsWith("https://")) {
            String tmp = vipSaturnDcosRegistryUri.substring("https://".length());
            while (tmp.endsWith("/")) {
                tmp = tmp.substring(0, tmp.length() - 1);
            }
            imageNew = tmp + "/" + addContainerModel.getImage();
        }
        containerConfig.setImage(imageNew);
        if (containerConfig.getEnv() == null) {
            containerConfig.setEnv(new HashMap<String, String>());
        }
        if (!containerConfig.getEnv().containsKey(SaturnEnvProperties.NAME_VIP_SATURN_ZK_CONNECTION)) {
            containerConfig.getEnv().put(SaturnEnvProperties.NAME_VIP_SATURN_ZK_CONNECTION, this.getCurrentZkAddr(request.getSession()));
        }
        this.marathonService.addContainer(namespace, containerConfig);
        return new SuccessResponseEntity();
    }

    @Audit
    @PostMapping(value={"/containerInstances"})
    public SuccessResponseEntity updateContainerInstances(@AuditParam(value="namespace") @PathVariable String namespace, @AuditParam(value="taskId") @RequestParam String taskId, @AuditParam(value="instances") @RequestParam int instances) throws SaturnJobConsoleException {
        if (instances < 0) {
            throw new SaturnJobConsoleException("instances\u4e0d\u80fd\u5c0f\u4e8e0");
        }
        this.marathonService.updateContainerInstances(namespace, taskId, instances);
        return new SuccessResponseEntity();
    }

    @Audit
    @DeleteMapping(value={"/container"})
    public SuccessResponseEntity removeContainer(@AuditParam(value="namespace") @PathVariable String namespace, @AuditParam(value="taskId") @RequestParam String taskId) throws SaturnJobConsoleException {
        this.marathonService.removeContainer(namespace, taskId);
        return new SuccessResponseEntity();
    }

    @GetMapping(value={"/containerDetail"})
    public SuccessResponseEntity getContainerDetail(@PathVariable String namespace, @RequestParam String taskId) throws SaturnJobConsoleException {
        return new SuccessResponseEntity(this.marathonService.getContainerDetail(namespace, taskId));
    }

    @GetMapping(value={"/registryCatalog"})
    public SuccessResponseEntity getRegistryCatalog(@PathVariable String namespace) throws SaturnJobConsoleException {
        return new SuccessResponseEntity(this.marathonService.getRegistryCatalog(namespace));
    }

    @GetMapping(value={"/registryRepositoryTags"})
    public SuccessResponseEntity getRegistryRepositoryTags(@PathVariable String namespace, @RequestParam String repository) throws SaturnJobConsoleException {
        return new SuccessResponseEntity(this.marathonService.getRegistryRepositoryTags(namespace, repository));
    }

    @GetMapping(value={"/timeZoneIds"})
    public SuccessResponseEntity getTimeZoneIds(@PathVariable String namespace) {
        return new SuccessResponseEntity(SaturnConstants.TIME_ZONE_IDS);
    }

    @Audit
    @PostMapping(value={"/containerScaleJob"})
    public SuccessResponseEntity addContainerScaleJob(@AuditParam(value="namespace") @PathVariable String namespace, @AuditParam(value="taskId") @RequestParam String taskId, @AuditParam(value="jobDesc") @RequestParam String jobDesc, @AuditParam(value="instances") @RequestParam int instances, @AuditParam(value="timeZone") @RequestParam String timeZone, @AuditParam(value="cron") @RequestParam String cron) throws SaturnJobConsoleException {
        if (instances < 0) {
            throw new SaturnJobConsoleException("instances\u4e0d\u80fd\u5c0f\u4e8e0");
        }
        try {
            CronExpression.validateExpression(cron);
        }
        catch (ParseException e) {
            throw new SaturnJobConsoleException(String.format("cron(%s)\u65e0\u6548:%s", cron, e.getMessage()));
        }
        this.marathonService.addContainerScaleJob(namespace, taskId, jobDesc, instances, timeZone, cron);
        return new SuccessResponseEntity();
    }

    @GetMapping(value={"/containerScaleJobVo"})
    public SuccessResponseEntity getContainerScaleJob(@PathVariable String namespace, @RequestParam String taskId, @RequestParam String jobName) throws SaturnJobConsoleException {
        return new SuccessResponseEntity(this.marathonService.getContainerScaleJobVo(namespace, taskId, jobName));
    }

    @Audit
    @PostMapping(value={"/enableContainerScaleJob"})
    public SuccessResponseEntity enableContainerScaleJob(@AuditParam(value="namespace") @PathVariable String namespace, @AuditParam(value="jobName") @RequestParam String jobName) throws SaturnJobConsoleException {
        this.marathonService.enableContainerScaleJob(namespace, jobName, true);
        return new SuccessResponseEntity();
    }

    @Audit
    @PostMapping(value={"/disableContainerScaleJob"})
    public SuccessResponseEntity disableContainerScaleJob(@AuditParam(value="namespace") @PathVariable String namespace, @AuditParam(value="jobName") @RequestParam String jobName) throws SaturnJobConsoleException {
        this.marathonService.enableContainerScaleJob(namespace, jobName, false);
        return new SuccessResponseEntity();
    }

    @Audit
    @DeleteMapping(value={"/containerScaleJob"})
    public SuccessResponseEntity deleteContainerScaleJob(@AuditParam(value="namespace") @PathVariable String namespace, @AuditParam(value="taskId") @RequestParam String taskId, @AuditParam(value="jobName") @RequestParam String jobName) throws SaturnJobConsoleException {
        this.marathonService.deleteContainerScaleJob(namespace, taskId, jobName);
        return new SuccessResponseEntity();
    }
}

