/*
 * Decompiled with CFR 0.152.
 */
package com.vip.saturn.job.console.controller.gui;

import com.vip.saturn.job.console.aop.annotation.Audit;
import com.vip.saturn.job.console.aop.annotation.AuditParam;
import com.vip.saturn.job.console.controller.SuccessResponseEntity;
import com.vip.saturn.job.console.controller.gui.AbstractGUIController;
import com.vip.saturn.job.console.domain.RequestResult;
import com.vip.saturn.job.console.exception.SaturnJobConsoleException;
import com.vip.saturn.job.console.service.AlarmStatisticsService;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@RequestMapping(value={"/console/alarmStatistics"})
public class OverallAlarmStatisticsController
extends AbstractGUIController {
    @Resource
    private AlarmStatisticsService alarmStatisticsService;

    @ApiResponses(value={@ApiResponse(code=200, message="Success/Fail", response=RequestResult.class)})
    @GetMapping(value={"/abnormalJobs"})
    public SuccessResponseEntity getAbnormalJobs(@RequestParam(required=false) String zkClusterKey) throws SaturnJobConsoleException {
        if (StringUtils.isBlank((CharSequence)zkClusterKey)) {
            return new SuccessResponseEntity(this.alarmStatisticsService.getAbnormalJobsString());
        }
        return new SuccessResponseEntity(this.alarmStatisticsService.getAbnormalJobsStringByZKCluster(zkClusterKey));
    }

    @ApiResponses(value={@ApiResponse(code=200, message="Success/Fail", response=RequestResult.class)})
    @GetMapping(value={"/unableFailoverJobs"})
    public SuccessResponseEntity getUnableFailoverJobs(@RequestParam(required=false) String zkClusterKey) throws SaturnJobConsoleException {
        if (StringUtils.isBlank((CharSequence)zkClusterKey)) {
            return new SuccessResponseEntity(this.alarmStatisticsService.getUnableFailoverJobsString());
        }
        return new SuccessResponseEntity(this.alarmStatisticsService.getUnableFailoverJobsStringByZKCluster(zkClusterKey));
    }

    @ApiResponses(value={@ApiResponse(code=200, message="Success/Fail", response=RequestResult.class)})
    @GetMapping(value={"/timeout4AlarmJobs"})
    public SuccessResponseEntity getTimeout4AlarmJobs(@RequestParam(required=false) String zkClusterKey) throws SaturnJobConsoleException {
        if (StringUtils.isBlank((CharSequence)zkClusterKey)) {
            return new SuccessResponseEntity(this.alarmStatisticsService.getTimeout4AlarmJobsString());
        }
        return new SuccessResponseEntity(this.alarmStatisticsService.getTimeout4AlarmJobsStringByZKCluster(zkClusterKey));
    }

    @ApiResponses(value={@ApiResponse(code=200, message="Success/Fail", response=RequestResult.class)})
    @GetMapping(value={"/countOfAlarmJobs"})
    public SuccessResponseEntity getCountOfAlarmJobs() throws SaturnJobConsoleException {
        return new SuccessResponseEntity(this.alarmStatisticsService.getCountOfAlarmJobs());
    }

    @ApiResponses(value={@ApiResponse(code=200, message="Success/Fail", response=RequestResult.class)})
    @GetMapping(value={"/abnormalContainers"})
    public SuccessResponseEntity getAbnormalContainers(@RequestParam(required=false) String zkClusterKey) throws SaturnJobConsoleException {
        if (StringUtils.isBlank((CharSequence)zkClusterKey)) {
            return new SuccessResponseEntity(this.alarmStatisticsService.getAbnormalContainers());
        }
        return new SuccessResponseEntity(this.alarmStatisticsService.getAbnormalContainers(zkClusterKey));
    }

    @ApiResponses(value={@ApiResponse(code=200, message="Success/Fail", response=RequestResult.class)})
    @Audit
    @PostMapping(value={"/setAbnormalJobMonitorStatusToRead"})
    public SuccessResponseEntity setAbnormalJobMonitorStatusToRead(@AuditParam(value="uuid") @RequestParam String uuid) throws SaturnJobConsoleException {
        this.assertIsPermitted("alarmCenter:setAbnormalJobRead");
        this.alarmStatisticsService.setAbnormalJobMonitorStatusToRead(uuid);
        return new SuccessResponseEntity();
    }

    @ApiResponses(value={@ApiResponse(code=200, message="Success/Fail", response=RequestResult.class)})
    @Audit
    @PostMapping(value={"/setTimeout4AlarmJobMonitorStatusToRead"})
    public SuccessResponseEntity setTimeout4AlarmJobMonitorStatusToRead(@AuditParam(value="uuid") @RequestParam String uuid) throws SaturnJobConsoleException {
        this.assertIsPermitted("alarmCenter:setTimeout4AlarmJobRead");
        this.alarmStatisticsService.setTimeout4AlarmJobMonitorStatusToRead(uuid);
        return new SuccessResponseEntity();
    }
}

