/*
 * Decompiled with CFR 0.152.
 */
package com.vip.saturn.job.console.controller.gui;

import com.google.common.collect.Lists;
import com.vip.saturn.job.console.aop.annotation.Audit;
import com.vip.saturn.job.console.aop.annotation.AuditParam;
import com.vip.saturn.job.console.controller.SuccessResponseEntity;
import com.vip.saturn.job.console.controller.gui.AbstractGUIController;
import com.vip.saturn.job.console.domain.NamespaceDomainInfo;
import com.vip.saturn.job.console.domain.NamespaceMigrationOverallStatus;
import com.vip.saturn.job.console.domain.RegistryCenterConfiguration;
import com.vip.saturn.job.console.domain.RequestResult;
import com.vip.saturn.job.console.domain.ZkCluster;
import com.vip.saturn.job.console.exception.SaturnJobConsoleException;
import com.vip.saturn.job.console.service.NamespaceZkClusterMappingService;
import com.vip.saturn.job.console.utils.SaturnConsoleUtils;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.File;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@RequestMapping(value={"/console"})
public class RegistryCenterController
extends AbstractGUIController {
    private static final String EXPORT_FILE_NAME = "namespace_info.xls";
    @Resource
    private NamespaceZkClusterMappingService namespaceZkClusterMappingService;

    @ApiResponses(value={@ApiResponse(code=200, message="Success/Fail", response=RequestResult.class)})
    @Audit
    @PostMapping(value={"/namespaces"})
    public SuccessResponseEntity createNamespace(@AuditParam(value="namespace") @RequestParam String namespace, @AuditParam(value="zkClusterKey") @RequestParam String zkClusterKey) throws SaturnJobConsoleException {
        this.assertIsPermitted("registryCenter:addNamespace");
        NamespaceDomainInfo namespaceInfo = this.constructNamespaceDomainInfo(namespace, zkClusterKey);
        this.registryCenterService.createNamespace(namespaceInfo);
        return new SuccessResponseEntity();
    }

    private NamespaceDomainInfo constructNamespaceDomainInfo(String namespace, String zkClusterKey) {
        NamespaceDomainInfo namespaceInfo = new NamespaceDomainInfo();
        namespaceInfo.setNamespace(namespace);
        namespaceInfo.setZkCluster(zkClusterKey);
        namespaceInfo.setContent("");
        return namespaceInfo;
    }

    @ApiResponses(value={@ApiResponse(code=200, message="Success/Fail", response=RequestResult.class)})
    @GetMapping(value={"/namespaces/detail"})
    public SuccessResponseEntity queryAllNamespaceInfo() {
        LinkedList namespaceInfoList = Lists.newLinkedList();
        Collection<ZkCluster> zkClusterList = this.registryCenterService.getZkClusterList();
        for (ZkCluster zkCluster : zkClusterList) {
            if (!zkCluster.isOffline()) {
                namespaceInfoList.addAll(zkCluster.getRegCenterConfList());
                continue;
            }
            List<RegistryCenterConfiguration> configs = this.registryCenterService.findConfigsByZkCluster(zkCluster);
            if (configs == null || configs.isEmpty()) continue;
            namespaceInfoList.addAll(configs);
        }
        return new SuccessResponseEntity(namespaceInfoList);
    }

    @ApiResponses(value={@ApiResponse(code=200, message="Success/Fail", response=RequestResult.class)})
    @GetMapping(value={"/namespaces/export"})
    public void exportNamespaceInfo(@RequestParam(required=false) List<String> namespaceList, HttpServletResponse response) throws SaturnJobConsoleException {
        this.assertIsPermitted("registryCenter:exportNamespaces");
        File exportFile = this.registryCenterService.exportNamespaceInfo(namespaceList);
        SaturnConsoleUtils.exportFile(response, exportFile, EXPORT_FILE_NAME, true);
    }

    @ApiResponses(value={@ApiResponse(code=200, message="Success/Fail", response=RequestResult.class)})
    @Audit
    @RequestMapping(value={"/registryCenter/refresh"}, method={RequestMethod.GET, RequestMethod.POST})
    public SuccessResponseEntity notifyRefreshRegCenter() throws SaturnJobConsoleException {
        this.assertIsPermitted("registryCenter:addNamespace");
        this.registryCenterService.notifyRefreshRegCenter();
        return new SuccessResponseEntity();
    }

    private List<ZkCluster> filterOnlineZkClusters(Collection<ZkCluster> zkClusters) {
        if (zkClusters == null) {
            return Lists.newLinkedList();
        }
        LinkedList onlineZkClusters = Lists.newLinkedList();
        for (ZkCluster zkCluster : zkClusters) {
            if (zkCluster.isOffline()) continue;
            onlineZkClusters.add(zkCluster);
        }
        return onlineZkClusters;
    }

    @ApiResponses(value={@ApiResponse(code=200, message="Success/Fail", response=RequestResult.class)})
    @Audit
    @PostMapping(value={"/zkClusters"})
    public SuccessResponseEntity createZkCluster(@AuditParam(value="zkClusterKey") @RequestParam String zkClusterKey, @AuditParam(value="alias") @RequestParam String alias, @AuditParam(value="connectString") @RequestParam String connectString) throws SaturnJobConsoleException {
        this.assertIsPermitted("registryCenter:addZkCluster");
        this.registryCenterService.createZkCluster(zkClusterKey, alias, connectString.trim());
        return new SuccessResponseEntity();
    }

    @ApiResponses(value={@ApiResponse(code=200, message="Success/Fail", response=RequestResult.class)})
    @Audit
    @PutMapping(value={"/zkClusters"})
    public SuccessResponseEntity updateZkCluster(@AuditParam(value="zkClusterKey") @RequestParam String zkClusterKey, @AuditParam(value="newConnectString") @RequestParam String connectString) throws SaturnJobConsoleException {
        this.assertIsPermitted("registryCenter:addZkCluster");
        this.registryCenterService.updateZkCluster(zkClusterKey, connectString.trim());
        return new SuccessResponseEntity();
    }

    @ApiResponses(value={@ApiResponse(code=200, message="Success/Fail", response=RequestResult.class)})
    @GetMapping(value={"/zkClusters"})
    public SuccessResponseEntity getZkClusters(@RequestParam(required=false) String status, @RequestParam(required=false) String zkClusterKey) throws SaturnJobConsoleException {
        if (StringUtils.isNotBlank((CharSequence)zkClusterKey)) {
            ZkCluster zkCluster = this.registryCenterService.getZkCluster(zkClusterKey);
            if (zkCluster == null) {
                throw new SaturnJobConsoleException(1, String.format("ZK cluster[%s]\u4e0d\u5b58\u5728", zkClusterKey));
            }
            return new SuccessResponseEntity(zkCluster);
        }
        Collection<ZkCluster> zkClusters = this.registryCenterService.getZkClusterList();
        if (StringUtils.isBlank((CharSequence)status) || !"online".equals(status)) {
            return new SuccessResponseEntity(zkClusters);
        }
        List<ZkCluster> onlineZkCluster = this.filterOnlineZkClusters(zkClusters);
        return new SuccessResponseEntity(onlineZkCluster);
    }

    @ApiResponses(value={@ApiResponse(code=200, message="Success/Fail", response=RequestResult.class)})
    @Audit
    @PostMapping(value={"/namespaces/zkCluster/migrate"})
    public SuccessResponseEntity migrateZkCluster(@AuditParam(value="namespaces") @RequestParam String namespaces, @AuditParam(value="zkClusterNew") @RequestParam String zkClusterKeyNew, @RequestParam(required=false, defaultValue="false") boolean updateDBOnly) throws SaturnJobConsoleException {
        this.assertIsPermitted("registryCenter:batchMoveNamespaces");
        this.namespaceZkClusterMappingService.migrateNamespaceListToNewZk(namespaces, zkClusterKeyNew, this.getCurrentLoginUserName(), updateDBOnly);
        return new SuccessResponseEntity();
    }

    @ApiResponses(value={@ApiResponse(code=200, message="Success/Fail", response=RequestResult.class)})
    @GetMapping(value={"/namespaces/zkCluster/migrationStatus"})
    public SuccessResponseEntity getZkClusterMigrationStatus() throws SaturnJobConsoleException {
        NamespaceMigrationOverallStatus namespaceMigrationOverallStatus = this.namespaceZkClusterMappingService.getNamespaceMigrationOverallStatus();
        if (namespaceMigrationOverallStatus == null) {
            throw new SaturnJobConsoleException("The namespace migration status is not existed in db");
        }
        return new SuccessResponseEntity(namespaceMigrationOverallStatus);
    }
}

