/*
 * Decompiled with CFR 0.152.
 */
package com.vip.saturn.job.console.controller.rest;

import com.vip.saturn.job.console.aop.annotation.Audit;
import com.vip.saturn.job.console.aop.annotation.AuditType;
import com.vip.saturn.job.console.controller.rest.AbstractRestController;
import com.vip.saturn.job.console.exception.SaturnJobConsoleException;
import com.vip.saturn.job.console.exception.SaturnJobConsoleHttpException;
import com.vip.saturn.job.console.service.RestApiService;
import com.vip.saturn.job.console.service.SystemConfigService;
import com.vip.saturn.job.integrate.entity.AlarmInfo;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/rest/v1/{namespace}/alarms"})
public class AlarmRestApiController
extends AbstractRestController {
    public static final String ALARM_TYPE = "SATURN.JOB.EXCEPTION";
    private static final String ALARM_TITLE_EXECUTOR_RESTART = "Executor_Restart";
    private static final String ALARM_NAME_EXECUTOR_RESTART = "Saturn Event";
    private static final String ALARM_RAISED_ON_EXECUTOR_RESTART = "ALARM_RAISED_ON_EXECUTOR_RESTART";
    private static final Logger logger = LoggerFactory.getLogger(AlarmRestApiController.class);
    @Resource
    private RestApiService restApiService;
    @Resource
    private SystemConfigService systemConfigService;

    @Audit(type=AuditType.REST)
    @RequestMapping(value={"/raise"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<Object> raise(@PathVariable(value="namespace") String namespace, @RequestBody Map<String, Object> reqParams, HttpServletRequest request) throws SaturnJobConsoleException {
        try {
            String jobName = AlarmRestApiController.checkAndGetParametersValueAsString(reqParams, "jobName", false);
            String executorName = AlarmRestApiController.checkAndGetParametersValueAsString(reqParams, "executorName", true);
            Integer shardItem = AlarmRestApiController.checkAndGetParametersValueAsInteger(reqParams, "shardItem", false);
            AlarmInfo alarmInfo = this.constructAlarmInfo(reqParams);
            logger.info("try to raise alarm: {}, job: {}, executor: {}, item: {}", new Object[]{alarmInfo, jobName, executorName, shardItem});
            boolean isExecutorRestartAlarmEvent = this.isExecutorRestartAlarmEvent(alarmInfo);
            if (isExecutorRestartAlarmEvent) {
                boolean alarmRaisedOnExecutorRestart = this.systemConfigService.getBooleanValue(ALARM_RAISED_ON_EXECUTOR_RESTART, Boolean.FALSE);
                if (!alarmRaisedOnExecutorRestart) {
                    logger.warn(alarmInfo.getMessage());
                } else {
                    this.restApiService.raiseExecutorRestartAlarm(namespace, executorName, alarmInfo);
                }
            } else {
                if (StringUtils.isBlank((CharSequence)jobName)) {
                    throw new SaturnJobConsoleHttpException(HttpStatus.BAD_REQUEST.value(), "Invalid request. Missing parameter: jobName");
                }
                this.restApiService.raiseAlarm(namespace, jobName, executorName, shardItem, alarmInfo);
            }
            return new ResponseEntity(HttpStatus.CREATED);
        }
        catch (SaturnJobConsoleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SaturnJobConsoleHttpException(HttpStatus.INTERNAL_SERVER_ERROR.value(), e.getMessage(), e);
        }
    }

    private boolean isExecutorRestartAlarmEvent(AlarmInfo alarmInfo) {
        return ALARM_TITLE_EXECUTOR_RESTART.equals(alarmInfo.getTitle()) && ALARM_NAME_EXECUTOR_RESTART.equals(alarmInfo.getName());
    }

    private AlarmInfo constructAlarmInfo(Map<String, Object> reqParams) throws SaturnJobConsoleException {
        Map customFields;
        AlarmInfo alarmInfo = new AlarmInfo();
        String level = AlarmRestApiController.checkAndGetParametersValueAsString(reqParams, "level", true);
        alarmInfo.setLevel(level);
        alarmInfo.setType(ALARM_TYPE);
        String name = AlarmRestApiController.checkAndGetParametersValueAsString(reqParams, "name", true);
        alarmInfo.setName(name);
        String title = AlarmRestApiController.checkAndGetParametersValueAsString(reqParams, "title", true);
        alarmInfo.setTitle(title);
        String message = AlarmRestApiController.checkAndGetParametersValueAsString(reqParams, "message", false);
        if (StringUtils.isNotBlank((CharSequence)message)) {
            alarmInfo.setMessage(message);
        }
        if ((customFields = (Map)reqParams.get("additionalInfo")) != null) {
            alarmInfo.getCustomFields().putAll(customFields);
        }
        return alarmInfo;
    }
}

