/*
 * Decompiled with CFR 0.152.
 */
package com.vip.saturn.job.console.controller.rest;

import com.vip.saturn.job.console.aop.annotation.Audit;
import com.vip.saturn.job.console.aop.annotation.AuditType;
import com.vip.saturn.job.console.controller.rest.AbstractRestController;
import com.vip.saturn.job.console.exception.SaturnJobConsoleException;
import com.vip.saturn.job.console.exception.SaturnJobConsoleHttpException;
import com.vip.saturn.job.console.service.StatisticsRefreshService;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@RequestMapping(value={"/rest/v1"})
public class DashboardRefreshRestApiController
extends AbstractRestController {
    @Resource
    private StatisticsRefreshService statisticsRefreshService;

    @Audit(type=AuditType.REST)
    @RequestMapping(value={"/dashboard/refresh"}, method={RequestMethod.POST, RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<Object> dashboardRefresh(String zkClusterKey, HttpServletRequest request) throws SaturnJobConsoleException {
        try {
            DashboardRefreshRestApiController.checkMissingParameter("zkClusterKey", zkClusterKey);
            long beforeRefresh = System.currentTimeMillis();
            this.statisticsRefreshService.refresh(zkClusterKey, true);
            long afterRefresh = System.currentTimeMillis();
            long takeTime = afterRefresh - beforeRefresh;
            return new ResponseEntity((Object)takeTime, HttpStatus.OK);
        }
        catch (SaturnJobConsoleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SaturnJobConsoleHttpException(HttpStatus.INTERNAL_SERVER_ERROR.value(), e.getMessage(), e);
        }
    }
}

