/*
 * Decompiled with CFR 0.152.
 */
package com.vip.saturn.job.console.controller.rest;

import com.vip.saturn.job.console.aop.annotation.Audit;
import com.vip.saturn.job.console.aop.annotation.AuditType;
import com.vip.saturn.job.console.controller.gui.AbstractGUIController;
import com.vip.saturn.job.console.exception.SaturnJobConsoleException;
import com.vip.saturn.job.console.exception.SaturnJobConsoleHttpException;
import com.vip.saturn.job.console.mybatis.entity.ZkClusterInfo;
import com.vip.saturn.job.console.mybatis.service.NamespaceZkClusterMapping4SqlService;
import com.vip.saturn.job.console.mybatis.service.ZkClusterInfoService;
import com.vip.saturn.job.console.service.SystemConfigService;
import java.util.HashMap;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@RequestMapping(value={"/rest/v1/discovery"})
public class DiscoveryRestApiController
extends AbstractGUIController {
    @Resource
    private SystemConfigService systemConfigService;
    @Resource
    private ZkClusterInfoService zkClusterInfoService;
    @Resource
    private NamespaceZkClusterMapping4SqlService namespaceZkclusterMapping4SqlService;

    @Audit(type=AuditType.REST)
    @RequestMapping(method={RequestMethod.POST, RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity discover(String namespace) throws SaturnJobConsoleException {
        DiscoveryRestApiController.checkMissingParameter("namespace", namespace);
        HashMap<String, String> response = new HashMap<String, String>(2);
        response.put("zkConnStr", this.getZkConnStr(namespace));
        response.put("env", this.getEnvConfig());
        return ResponseEntity.ok(response);
    }

    private String getZkConnStr(String namespace) throws SaturnJobConsoleHttpException {
        if (StringUtils.isBlank((CharSequence)namespace)) {
            throw new SaturnJobConsoleHttpException(HttpStatus.BAD_REQUEST.value(), String.format("Invalid request. Missing parameter: {%s}", "namespace"));
        }
        String zkClusterKey = this.namespaceZkclusterMapping4SqlService.getZkClusterKey(namespace);
        if (zkClusterKey == null) {
            throw new SaturnJobConsoleHttpException(HttpStatus.NOT_FOUND.value(), "The namespace\uff1a[" + namespace + "] is not registered in Saturn.");
        }
        ZkClusterInfo zkClusterInfo = this.zkClusterInfoService.getByClusterKey(zkClusterKey);
        if (zkClusterInfo == null) {
            throw new SaturnJobConsoleHttpException(HttpStatus.INTERNAL_SERVER_ERROR.value(), "The clusterKey: [" + zkClusterKey + "] is not configured in db for " + namespace);
        }
        return zkClusterInfo.getConnectString();
    }

    private String getEnvConfig() {
        return this.systemConfigService.getValueDirectly("ENV");
    }
}

