/*
 * Decompiled with CFR 0.152.
 */
package com.vip.saturn.job.console.controller.rest;

import com.vip.saturn.job.console.aop.annotation.Audit;
import com.vip.saturn.job.console.aop.annotation.AuditType;
import com.vip.saturn.job.console.controller.rest.AbstractRestController;
import com.vip.saturn.job.console.domain.JobConfig;
import com.vip.saturn.job.console.domain.JobType;
import com.vip.saturn.job.console.domain.RestApiJobInfo;
import com.vip.saturn.job.console.exception.SaturnJobConsoleException;
import com.vip.saturn.job.console.exception.SaturnJobConsoleHttpException;
import com.vip.saturn.job.console.service.RestApiService;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@RequestMapping(value={"/rest/v1"})
public class JobOperationRestApiController
extends AbstractRestController {
    @Resource
    private RestApiService restApiService;

    @Audit(type=AuditType.REST)
    @RequestMapping(value={"/{namespace}/jobs"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<Object> create(@PathVariable(value="namespace") String namespace, @RequestBody Map<String, Object> reqParams) throws SaturnJobConsoleException {
        try {
            JobConfig jobConfig = this.constructJobConfigOfCreate(namespace, reqParams);
            this.restApiService.createJob(namespace, jobConfig);
            return new ResponseEntity(HttpStatus.CREATED);
        }
        catch (SaturnJobConsoleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SaturnJobConsoleHttpException(HttpStatus.INTERNAL_SERVER_ERROR.value(), e.getMessage(), e);
        }
    }

    @RequestMapping(value={"/{namespace}/jobs/{jobName}"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<Object> query(@PathVariable(value="namespace") String namespace, @PathVariable(value="jobName") String jobName) throws SaturnJobConsoleException {
        HttpHeaders httpHeaders = new HttpHeaders();
        try {
            RestApiJobInfo restAPIJobInfo = this.restApiService.getRestAPIJobInfo(namespace, jobName);
            return new ResponseEntity((Object)restAPIJobInfo, (MultiValueMap)httpHeaders, HttpStatus.OK);
        }
        catch (SaturnJobConsoleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SaturnJobConsoleHttpException(HttpStatus.INTERNAL_SERVER_ERROR.value(), e.getMessage(), e);
        }
    }

    @RequestMapping(value={"/{namespace}/jobs"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<Object> queryAll(@PathVariable(value="namespace") String namespace) throws SaturnJobConsoleException {
        HttpHeaders httpHeaders = new HttpHeaders();
        try {
            List<RestApiJobInfo> restApiJobInfos = this.restApiService.getRestApiJobInfos(namespace);
            return new ResponseEntity(restApiJobInfos, (MultiValueMap)httpHeaders, HttpStatus.OK);
        }
        catch (SaturnJobConsoleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SaturnJobConsoleHttpException(HttpStatus.INTERNAL_SERVER_ERROR.value(), e.getMessage(), e);
        }
    }

    @Audit(type=AuditType.REST)
    @RequestMapping(value={"/{namespace}/{jobName}/enable", "/{namespace}/jobs/{jobName}/enable"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<Object> enable(@PathVariable(value="namespace") String namespace, @PathVariable(value="jobName") String jobName) throws SaturnJobConsoleException {
        HttpHeaders httpHeaders = new HttpHeaders();
        try {
            this.restApiService.enableJob(namespace, jobName);
            return new ResponseEntity((MultiValueMap)httpHeaders, HttpStatus.OK);
        }
        catch (SaturnJobConsoleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SaturnJobConsoleHttpException(HttpStatus.INTERNAL_SERVER_ERROR.value(), e.getMessage(), e);
        }
    }

    @Audit(type=AuditType.REST)
    @RequestMapping(value={"/{namespace}/{jobName}/disable", "/{namespace}/jobs/{jobName}/disable"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<Object> disable(@PathVariable(value="namespace") String namespace, @PathVariable(value="jobName") String jobName) throws SaturnJobConsoleException {
        HttpHeaders httpHeaders = new HttpHeaders();
        try {
            this.restApiService.disableJob(namespace, jobName);
            return new ResponseEntity((MultiValueMap)httpHeaders, HttpStatus.OK);
        }
        catch (SaturnJobConsoleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SaturnJobConsoleHttpException(HttpStatus.INTERNAL_SERVER_ERROR.value(), e.getMessage(), e);
        }
    }

    @Audit(type=AuditType.REST)
    @RequestMapping(value={"/{namespace}/{jobName}/cron", "/{namespace}/jobs/{jobName}/cron"}, method={RequestMethod.PUT}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<Object> updateJobCron(@PathVariable(value="namespace") String namespace, @PathVariable(value="jobName") String jobName, @RequestBody Map<String, String> params, HttpServletRequest request) throws SaturnJobConsoleException {
        HttpHeaders httpHeaders = new HttpHeaders();
        try {
            String cron = params.remove("cron");
            JobOperationRestApiController.checkMissingParameter("cron", cron);
            this.restApiService.updateJobCron(namespace, jobName, cron, params);
            return new ResponseEntity((MultiValueMap)httpHeaders, HttpStatus.OK);
        }
        catch (SaturnJobConsoleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SaturnJobConsoleHttpException(HttpStatus.INTERNAL_SERVER_ERROR.value(), e.getMessage(), e);
        }
    }

    @Audit(type=AuditType.REST)
    @RequestMapping(value={"/{namespace}/jobs/{jobName}/run"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<Object> run(@PathVariable(value="namespace") String namespace, @PathVariable(value="jobName") String jobName) throws SaturnJobConsoleException {
        try {
            this.restApiService.runJobAtOnce(namespace, jobName);
            return new ResponseEntity(HttpStatus.NO_CONTENT);
        }
        catch (SaturnJobConsoleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SaturnJobConsoleHttpException(HttpStatus.INTERNAL_SERVER_ERROR.value(), e.getMessage(), e);
        }
    }

    @Audit(type=AuditType.REST)
    @RequestMapping(value={"/{namespace}/jobs/{jobName}/stop"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<Object> stop(@PathVariable(value="namespace") String namespace, @PathVariable(value="jobName") String jobName) throws SaturnJobConsoleException {
        try {
            this.restApiService.stopJobAtOnce(namespace, jobName);
            return new ResponseEntity(HttpStatus.NO_CONTENT);
        }
        catch (SaturnJobConsoleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SaturnJobConsoleHttpException(HttpStatus.INTERNAL_SERVER_ERROR.value(), e.getMessage(), e);
        }
    }

    @Audit(type=AuditType.REST)
    @RequestMapping(value={"/{namespace}/jobs/{jobName}"}, method={RequestMethod.DELETE}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<Object> delete(@PathVariable(value="namespace") String namespace, @PathVariable(value="jobName") String jobName) throws SaturnJobConsoleException {
        try {
            this.restApiService.deleteJob(namespace, jobName);
            return new ResponseEntity(HttpStatus.NO_CONTENT);
        }
        catch (SaturnJobConsoleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SaturnJobConsoleHttpException(HttpStatus.INTERNAL_SERVER_ERROR.value(), e.getMessage(), e);
        }
    }

    @Audit(type=AuditType.REST)
    @RequestMapping(value={"/{namespace}/jobs/{jobName}"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<Object> update(@PathVariable(value="namespace") String namespace, @PathVariable String jobName, @RequestBody Map<String, Object> reqParams) throws SaturnJobConsoleException {
        try {
            JobConfig jobConfig = this.constructJobConfigOfUpdate(namespace, jobName, reqParams);
            this.restApiService.updateJob(namespace, jobName, jobConfig);
            return new ResponseEntity(HttpStatus.OK);
        }
        catch (SaturnJobConsoleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SaturnJobConsoleHttpException(HttpStatus.INTERNAL_SERVER_ERROR.value(), e.getMessage(), e);
        }
    }

    private JobConfig constructJobConfigOfCreate(String namespace, Map<String, Object> reqParams) throws SaturnJobConsoleException {
        JobOperationRestApiController.checkMissingParameter("namespace", namespace);
        if (!reqParams.containsKey("jobConfig")) {
            throw new SaturnJobConsoleHttpException(HttpStatus.BAD_REQUEST.value(), String.format("Invalid request. Parameter: {%s} %s", "jobConfig", "cannot be blank"));
        }
        JobConfig jobConfig = new JobConfig();
        Map configParams = (Map)reqParams.get("jobConfig");
        jobConfig.setJobName(JobOperationRestApiController.checkAndGetParametersValueAsString(reqParams, "jobName", true));
        jobConfig.setDescription(JobOperationRestApiController.checkAndGetParametersValueAsString(reqParams, "description", false));
        jobConfig.setChannelName(JobOperationRestApiController.checkAndGetParametersValueAsString(configParams, "channelName", false));
        jobConfig.setCron(JobOperationRestApiController.checkAndGetParametersValueAsString(configParams, "cron", false));
        jobConfig.setJobClass(JobOperationRestApiController.checkAndGetParametersValueAsString(configParams, "jobClass", false));
        jobConfig.setJobParameter(JobOperationRestApiController.checkAndGetParametersValueAsString(configParams, "jobParameter", false));
        String jobType = JobOperationRestApiController.checkAndGetParametersValueAsString(configParams, "jobType", true);
        if (JobType.UNKOWN_JOB.equals((Object)JobType.getJobType(jobType))) {
            throw new SaturnJobConsoleHttpException(HttpStatus.BAD_REQUEST.value(), String.format("Invalid request. Parameter: {%s} %s", "jobType", "is malformed"));
        }
        jobConfig.setJobType(jobType);
        jobConfig.setLoadLevel(JobOperationRestApiController.checkAndGetParametersValueAsInteger(configParams, "loadLevel", false));
        jobConfig.setLocalMode(JobOperationRestApiController.checkAndGetParametersValueAsBoolean(configParams, "localMode", false));
        jobConfig.setPausePeriodDate(JobOperationRestApiController.checkAndGetParametersValueAsString(configParams, "pausePeriodDate", false));
        jobConfig.setPausePeriodTime(JobOperationRestApiController.checkAndGetParametersValueAsString(configParams, "pausePeriodTime", false));
        jobConfig.setPreferList(JobOperationRestApiController.checkAndGetParametersValueAsString(configParams, "preferList", false));
        jobConfig.setQueueName(JobOperationRestApiController.checkAndGetParametersValueAsString(configParams, "queueName", false));
        jobConfig.setShardingItemParameters(JobOperationRestApiController.checkAndGetParametersValueAsString(configParams, "shardingItemParameters", true));
        jobConfig.setShardingTotalCount(JobOperationRestApiController.checkAndGetParametersValueAsInteger(configParams, "shardingTotalCount", true));
        jobConfig.setTimeout4AlarmSeconds(JobOperationRestApiController.checkAndGetParametersValueAsInteger(configParams, "timeout4AlarmSeconds", false));
        jobConfig.setUseDispreferList(JobOperationRestApiController.checkAndGetParametersValueAsBoolean(configParams, "useDispreferList", false));
        jobConfig.setUseSerial(JobOperationRestApiController.checkAndGetParametersValueAsBoolean(configParams, "useSerial", false));
        jobConfig.setJobDegree(JobOperationRestApiController.checkAndGetParametersValueAsInteger(configParams, "jobDegree", false));
        jobConfig.setDependencies(JobOperationRestApiController.checkAndGetParametersValueAsString(configParams, "dependencies", false));
        jobConfig.setTimeZone(JobOperationRestApiController.checkAndGetParametersValueAsString(configParams, "timeZone", false));
        jobConfig.setTimeoutSeconds(JobOperationRestApiController.checkAndGetParametersValueAsInteger(configParams, "timeoutSeconds", false));
        jobConfig.setProcessCountIntervalSeconds(JobOperationRestApiController.checkAndGetParametersValueAsInteger(configParams, "processCountIntervalSeconds", false));
        jobConfig.setGroups(JobOperationRestApiController.checkAndGetParametersValueAsString(configParams, "groups", false));
        jobConfig.setShowNormalLog(JobOperationRestApiController.checkAndGetParametersValueAsBoolean(configParams, "showNormalLog", false));
        jobConfig.setFailover(JobOperationRestApiController.checkAndGetParametersValueAsBoolean(configParams, "failover", false));
        jobConfig.setRerun(JobOperationRestApiController.checkAndGetParametersValueAsBoolean(configParams, "rerun", false));
        return jobConfig;
    }

    private JobConfig constructJobConfigOfUpdate(String namespace, String jobName, Map<String, Object> reqParams) throws SaturnJobConsoleException {
        JobOperationRestApiController.checkMissingParameter("namespace", namespace);
        JobOperationRestApiController.checkMissingParameter("jobName", jobName);
        if (!reqParams.containsKey("jobConfig")) {
            throw new SaturnJobConsoleHttpException(HttpStatus.BAD_REQUEST.value(), String.format("Invalid request. Parameter: {%s} %s", "jobConfig", "cannot be blank"));
        }
        JobConfig jobConfig = new JobConfig();
        Map configParams = (Map)reqParams.get("jobConfig");
        jobConfig.setJobName(jobName);
        jobConfig.setDescription(JobOperationRestApiController.checkAndGetParametersValueAsString(reqParams, "description", false));
        jobConfig.setChannelName(JobOperationRestApiController.checkAndGetParametersValueAsString(configParams, "channelName", false));
        jobConfig.setCron(JobOperationRestApiController.checkAndGetParametersValueAsString(configParams, "cron", false));
        jobConfig.setJobParameter(JobOperationRestApiController.checkAndGetParametersValueAsString(configParams, "jobParameter", false));
        jobConfig.setLoadLevel(JobOperationRestApiController.checkAndGetParametersValueAsInteger(configParams, "loadLevel", false));
        jobConfig.setLocalMode(JobOperationRestApiController.checkAndGetParametersValueAsBoolean(configParams, "localMode", false));
        jobConfig.setPausePeriodDate(JobOperationRestApiController.checkAndGetParametersValueAsString(configParams, "pausePeriodDate", false));
        jobConfig.setPausePeriodTime(JobOperationRestApiController.checkAndGetParametersValueAsString(configParams, "pausePeriodTime", false));
        jobConfig.setPreferList(JobOperationRestApiController.checkAndGetParametersValueAsString(configParams, "preferList", false));
        jobConfig.setQueueName(JobOperationRestApiController.checkAndGetParametersValueAsString(configParams, "queueName", false));
        jobConfig.setShardingItemParameters(JobOperationRestApiController.checkAndGetParametersValueAsString(configParams, "shardingItemParameters", false));
        jobConfig.setShardingTotalCount(JobOperationRestApiController.checkAndGetParametersValueAsInteger(configParams, "shardingTotalCount", false));
        jobConfig.setTimeout4AlarmSeconds(JobOperationRestApiController.checkAndGetParametersValueAsInteger(configParams, "timeout4AlarmSeconds", false));
        jobConfig.setUseDispreferList(JobOperationRestApiController.checkAndGetParametersValueAsBoolean(configParams, "useDispreferList", false));
        jobConfig.setUseSerial(JobOperationRestApiController.checkAndGetParametersValueAsBoolean(configParams, "useSerial", false));
        jobConfig.setJobDegree(JobOperationRestApiController.checkAndGetParametersValueAsInteger(configParams, "jobDegree", false));
        jobConfig.setDependencies(JobOperationRestApiController.checkAndGetParametersValueAsString(configParams, "dependencies", false));
        jobConfig.setTimeZone(JobOperationRestApiController.checkAndGetParametersValueAsString(configParams, "timeZone", false));
        jobConfig.setTimeoutSeconds(JobOperationRestApiController.checkAndGetParametersValueAsInteger(configParams, "timeoutSeconds", false));
        jobConfig.setProcessCountIntervalSeconds(JobOperationRestApiController.checkAndGetParametersValueAsInteger(configParams, "processCountIntervalSeconds", false));
        jobConfig.setGroups(JobOperationRestApiController.checkAndGetParametersValueAsString(configParams, "groups", false));
        jobConfig.setShowNormalLog(JobOperationRestApiController.checkAndGetParametersValueAsBoolean(configParams, "showNormalLog", false));
        jobConfig.setRerun(JobOperationRestApiController.checkAndGetParametersValueAsBoolean(configParams, "rerun", false));
        jobConfig.setFailover(JobOperationRestApiController.checkAndGetParametersValueAsBoolean(configParams, "failover", false));
        return jobConfig;
    }
}

