/*
 * Decompiled with CFR 0.152.
 */
package com.vip.saturn.job.console.controller.rest;

import com.vip.saturn.job.console.aop.annotation.Audit;
import com.vip.saturn.job.console.aop.annotation.AuditType;
import com.vip.saturn.job.console.controller.rest.AbstractRestController;
import com.vip.saturn.job.console.domain.NamespaceDomainInfo;
import com.vip.saturn.job.console.exception.SaturnJobConsoleException;
import com.vip.saturn.job.console.exception.SaturnJobConsoleHttpException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@RequestMapping(value={"/rest/v1"})
public class NamespaceManagementRestApiController
extends AbstractRestController {
    @Audit(type=AuditType.REST)
    @RequestMapping(value={"/namespaces"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<Object> create(@RequestBody Map<String, Object> reqParams, HttpServletRequest request) throws SaturnJobConsoleException {
        try {
            NamespaceDomainInfo namespaceInfo = this.constructNamespaceDomainInfo(reqParams);
            this.registryCenterService.createNamespace(namespaceInfo);
            return new ResponseEntity(HttpStatus.CREATED);
        }
        catch (SaturnJobConsoleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SaturnJobConsoleHttpException(HttpStatus.INTERNAL_SERVER_ERROR.value(), e.getMessage(), e);
        }
    }

    @RequestMapping(value={"/namespaces/{namespace:.+}"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<Object> query(@PathVariable(value="namespace") String namespace) throws SaturnJobConsoleException {
        HttpHeaders httpHeaders = new HttpHeaders();
        try {
            NamespaceManagementRestApiController.checkMissingParameter("namespace", namespace);
            NamespaceDomainInfo namespaceDomainInfo = this.registryCenterService.getNamespace(namespace);
            return new ResponseEntity((Object)namespaceDomainInfo, (MultiValueMap)httpHeaders, HttpStatus.OK);
        }
        catch (SaturnJobConsoleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SaturnJobConsoleHttpException(HttpStatus.INTERNAL_SERVER_ERROR.value(), e.getMessage(), e);
        }
    }

    private NamespaceDomainInfo constructNamespaceDomainInfo(Map<String, Object> reqParams) throws SaturnJobConsoleException {
        NamespaceDomainInfo namespaceInfo = new NamespaceDomainInfo();
        namespaceInfo.setNamespace(NamespaceManagementRestApiController.checkAndGetParametersValueAsString(reqParams, "namespace", true));
        namespaceInfo.setZkCluster(NamespaceManagementRestApiController.checkAndGetParametersValueAsString(reqParams, "zkCluster", true));
        namespaceInfo.setContent("");
        return namespaceInfo;
    }
}

