/*
 * Decompiled with CFR 0.152.
 */
package com.vip.saturn.job.console.controller.rest;

import com.vip.saturn.job.console.aop.annotation.Audit;
import com.vip.saturn.job.console.aop.annotation.AuditType;
import com.vip.saturn.job.console.controller.rest.AbstractRestController;
import com.vip.saturn.job.console.domain.JobDiffInfo;
import com.vip.saturn.job.console.exception.SaturnJobConsoleHttpException;
import com.vip.saturn.job.console.service.ZkDBDiffService;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@RequestMapping(value={"/rest/v1"})
public class ZkDbDiffRestApiController
extends AbstractRestController {
    @Resource
    private ZkDBDiffService zkDBDiffService;

    @Audit(type=AuditType.REST)
    @RequestMapping(value={"/diff"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public ResponseEntity<Object> diff(String zkcluster, HttpServletRequest request) throws SaturnJobConsoleHttpException {
        try {
            ZkDbDiffRestApiController.checkMissingParameter("zkcluster", zkcluster);
            List<JobDiffInfo> resultList = this.zkDBDiffService.diffByCluster(zkcluster);
            return new ResponseEntity(resultList, HttpStatus.OK);
        }
        catch (Exception e) {
            throw new SaturnJobConsoleHttpException(HttpStatus.INTERNAL_SERVER_ERROR.value(), e.getMessage(), e);
        }
    }
}

