/*
 * Decompiled with CFR 0.152.
 */
package com.vip.saturn.job.console.domain;

import com.vip.saturn.job.console.domain.JobStatus;
import com.vip.saturn.job.console.domain.ServerStatus;
import java.io.Serializable;
import java.math.RoundingMode;
import java.text.NumberFormat;

public final class JobServer
implements Serializable {
    private static final long serialVersionUID = -7862835299298383387L;
    private String jobName;
    private String ip;
    private String executorName;
    private ServerStatus status;
    private int processSuccessCount;
    private int processFailureCount;
    private String sharding;
    private boolean leader;
    private String version;
    private String jobVersion;
    private boolean leaderStopped;
    private JobStatus jobStatus;
    private boolean isContainer;

    public String getPercentage() {
        int total = this.processSuccessCount + this.processFailureCount;
        if (total == 0) {
            return "";
        }
        int count = this.processSuccessCount;
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMaximumFractionDigits(2);
        numberFormat.setRoundingMode(RoundingMode.FLOOR);
        String result = numberFormat.format((double)count / (double)total * 100.0);
        return result + "%";
    }

    public String getJobName() {
        return this.jobName;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getExecutorName() {
        return this.executorName;
    }

    public void setExecutorName(String executorName) {
        this.executorName = executorName;
    }

    public ServerStatus getStatus() {
        return this.status;
    }

    public void setStatus(ServerStatus status) {
        this.status = status;
    }

    public int getProcessSuccessCount() {
        return this.processSuccessCount;
    }

    public void setProcessSuccessCount(int processSuccessCount) {
        this.processSuccessCount = processSuccessCount;
    }

    public int getProcessFailureCount() {
        return this.processFailureCount;
    }

    public void setProcessFailureCount(int processFailureCount) {
        this.processFailureCount = processFailureCount;
    }

    public String getSharding() {
        return this.sharding;
    }

    public void setSharding(String sharding) {
        this.sharding = sharding;
    }

    public boolean isLeader() {
        return this.leader;
    }

    public void setLeader(boolean leader) {
        this.leader = leader;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public boolean isLeaderStopped() {
        return this.leaderStopped;
    }

    public void setLeaderStopped(boolean leaderStopped) {
        this.leaderStopped = leaderStopped;
    }

    public JobStatus getJobStatus() {
        return this.jobStatus;
    }

    public void setJobStatus(JobStatus jobStatus) {
        this.jobStatus = jobStatus;
    }

    public String getJobVersion() {
        return this.jobVersion;
    }

    public void setJobVersion(String jobVersion) {
        this.jobVersion = jobVersion;
    }

    public boolean isContainer() {
        return this.isContainer;
    }

    public void setContainer(boolean container) {
        this.isContainer = container;
    }
}

