/*
 * Decompiled with CFR 0.152.
 */
package com.vip.saturn.job.console.domain;

import java.io.Serializable;

public class JobStatistics
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int processCountOfAllTime;
    private int errorCountOfAllTime;
    private int processCountOfTheDay;
    private int failureCountOfTheDay;
    private int totalLoadLevel;
    private int jobDegree;
    private String jobName;
    private String domainName;
    private String nns;
    private String executorsAndShards;

    public JobStatistics() {
    }

    public JobStatistics(String jobName, String domainName, String nns) {
        this.jobName = jobName;
        this.domainName = domainName;
        this.nns = nns;
    }

    public int getProcessCountOfAllTime() {
        return this.processCountOfAllTime;
    }

    public void setProcessCountOfAllTime(int processCountOfAllTime) {
        this.processCountOfAllTime = processCountOfAllTime;
    }

    public int getErrorCountOfAllTime() {
        return this.errorCountOfAllTime;
    }

    public void setErrorCountOfAllTime(int errorCountOfAllTime) {
        this.errorCountOfAllTime = errorCountOfAllTime;
    }

    public int getProcessCountOfTheDay() {
        return this.processCountOfTheDay;
    }

    public void setProcessCountOfTheDay(int processCountOfTheDay) {
        this.processCountOfTheDay = processCountOfTheDay;
    }

    public synchronized void incrProcessCountOfTheDay(int processCount) {
        this.processCountOfTheDay += processCount;
    }

    public int getFailureCountOfTheDay() {
        return this.failureCountOfTheDay;
    }

    public void setFailureCountOfTheDay(int failureCountOfTheDay) {
        this.failureCountOfTheDay = failureCountOfTheDay;
    }

    public synchronized void incrFailureCountOfTheDay(int failureCount) {
        this.failureCountOfTheDay += failureCount;
    }

    public int getTotalLoadLevel() {
        return this.totalLoadLevel;
    }

    public void setTotalLoadLevel(int totalLoadLevel) {
        this.totalLoadLevel = totalLoadLevel;
    }

    public int getJobDegree() {
        return this.jobDegree;
    }

    public void setJobDegree(int jobDegree) {
        this.jobDegree = jobDegree;
    }

    public String getJobName() {
        return this.jobName;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public String getNns() {
        return this.nns;
    }

    public void setNns(String nns) {
        this.nns = nns;
    }

    public String getExecutorsAndShards() {
        return this.executorsAndShards;
    }

    public void setExecutorsAndShards(String executorsAndShards) {
        this.executorsAndShards = executorsAndShards;
    }

    public float getFailureRateOfAllTime() {
        if (this.processCountOfAllTime == 0) {
            return 0.0f;
        }
        double rate = (double)this.errorCountOfAllTime / (double)this.processCountOfAllTime;
        return (float)(Math.floor(rate * 10000.0) / 10000.0);
    }
}

