/*
 * Decompiled with CFR 0.152.
 */
package com.vip.saturn.job.console.interceptor;

import com.google.common.base.Strings;
import com.vip.saturn.job.console.domain.RegistryCenterClient;
import com.vip.saturn.job.console.domain.RegistryCenterConfiguration;
import com.vip.saturn.job.console.service.RegistryCenterService;
import com.vip.saturn.job.console.utils.ThreadLocalCuratorClient;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public final class CuratorSessionClientInterceptor
extends HandlerInterceptorAdapter {
    @Resource
    private RegistryCenterService registryCenterService;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String nns = request.getParameter("nns");
        if (!Strings.isNullOrEmpty((String)nns)) {
            RegistryCenterClient client = this.registryCenterService.connect(nns);
            ThreadLocalCuratorClient.setCuratorClient(client.getCuratorClient());
            RegistryCenterConfiguration conf = this.registryCenterService.findConfig(client.getNameAndNamespace());
            if (conf == null) {
                response.sendRedirect(request.getContextPath() + "/registry_center_page");
                return false;
            }
            request.getSession().setAttribute("activated_config", (Object)conf);
            request.getSession().setAttribute("current_zk_cluster_key", (Object)conf.getZkClusterKey());
            return true;
        }
        RegistryCenterConfiguration reg = (RegistryCenterConfiguration)request.getSession().getAttribute("activated_config");
        if (reg == null) {
            response.sendRedirect(request.getContextPath() + "/registry_center_page");
            return false;
        }
        RegistryCenterClient client = this.registryCenterService.getCuratorByNameAndNamespace(reg.getNameAndNamespace());
        if (null == client || !client.isConnected()) {
            response.sendRedirect(request.getContextPath() + "/registry_center_page");
            return false;
        }
        ThreadLocalCuratorClient.setCuratorClient(client.getCuratorClient());
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        ThreadLocalCuratorClient.clear();
    }
}

