/*
 * Decompiled with CFR 0.152.
 */
package com.vip.saturn.job.console.mybatis.service.impl;

import com.vip.saturn.job.console.exception.SaturnJobConsoleException;
import com.vip.saturn.job.console.mybatis.entity.JobConfig4DB;
import com.vip.saturn.job.console.mybatis.repository.CurrentJobConfigRepository;
import com.vip.saturn.job.console.mybatis.service.CurrentJobConfigService;
import com.vip.saturn.job.console.mybatis.service.HistoryJobConfigService;
import java.io.Closeable;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.io.IOUtils;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CurrentJobConfigServiceImpl
implements CurrentJobConfigService {
    @Resource
    private HistoryJobConfigService historyJobConfigService;
    @Autowired
    private CurrentJobConfigRepository currentJobConfigRepo;
    @Autowired
    private SqlSessionFactory sqlSessionFactory;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int create(JobConfig4DB currentJobConfig) throws Exception {
        return this.currentJobConfigRepo.insert(currentJobConfig);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int createSelective(JobConfig4DB currentJobConfig) throws Exception {
        return this.currentJobConfigRepo.insertSelective(currentJobConfig);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int deleteByPrimaryKey(Long id) throws Exception {
        return this.currentJobConfigRepo.deleteByPrimaryKey(id);
    }

    @Override
    @Transactional(readOnly=true)
    public JobConfig4DB findByPrimaryKey(Long id) throws Exception {
        JobConfig4DB currentJobConfig = this.currentJobConfigRepo.selectByPrimaryKey(id);
        return currentJobConfig;
    }

    @Override
    @Transactional(readOnly=true)
    public int selectCount(JobConfig4DB currentJobConfig) throws Exception {
        return this.currentJobConfigRepo.selectCount(currentJobConfig);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int updateByPrimaryKey(JobConfig4DB currentJobConfig) throws Exception {
        return this.currentJobConfigRepo.updateByPrimaryKey(currentJobConfig);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int updateByPrimaryKeySelective(JobConfig4DB currentJobConfig) throws Exception {
        return this.currentJobConfigRepo.updateByPrimaryKeySelective(currentJobConfig);
    }

    @Override
    public void batchUpdatePreferList(List<JobConfig4DB> jobConfigs) throws SaturnJobConsoleException {
        SqlSession batchSqlSession = this.sqlSessionFactory.openSession(ExecutorType.BATCH, false);
        try {
            for (JobConfig4DB currentJobConfig : jobConfigs) {
                ((CurrentJobConfigRepository)batchSqlSession.getMapper(CurrentJobConfigRepository.class)).updatePreferList(currentJobConfig);
            }
            batchSqlSession.commit();
        }
        catch (Exception e) {
            batchSqlSession.rollback();
            throw new SaturnJobConsoleException("error when batchUpdatePreferList", e);
        }
        finally {
            IOUtils.closeQuietly((Closeable)batchSqlSession);
        }
    }

    @Override
    public List<JobConfig4DB> selectPage(JobConfig4DB currentJobConfig, Pageable pageable) throws Exception {
        return this.currentJobConfigRepo.selectPage(currentJobConfig, pageable);
    }

    @Override
    public JobConfig4DB findConfigByNamespaceAndJobName(String namespace, String jobName) {
        return this.currentJobConfigRepo.findConfigByNamespaceAndJobName(namespace, jobName);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateNewAndSaveOld2History(JobConfig4DB newJobConfig, JobConfig4DB oldJobConfig, String userName) throws Exception {
        if (userName != null) {
            newJobConfig.setLastUpdateBy(userName);
        }
        newJobConfig.setLastUpdateTime(new Date());
        this.updateByPrimaryKey(newJobConfig);
        oldJobConfig.setId(null);
        this.historyJobConfigService.create(oldJobConfig);
    }

    @Override
    public List<JobConfig4DB> findConfigsByNamespace(String namespace) {
        return this.currentJobConfigRepo.findConfigsByNamespace(namespace);
    }

    @Override
    public List<JobConfig4DB> findConfigsByNamespaceWithCondition(String namespace, Map<String, Object> condition, Pageable pageable) {
        return this.currentJobConfigRepo.findConfigsByNamespaceWithCondition(namespace, condition, pageable);
    }

    @Override
    public int countConfigsByNamespaceWithCondition(String namespace, Map<String, Object> condition) {
        return this.currentJobConfigRepo.countConfigsByNamespaceWithCondition(namespace, condition);
    }

    @Override
    public int countEnabledUnSystemJobsByNamespace(String namespace) {
        return this.currentJobConfigRepo.countEnabledUnSystemJobsByNamespace(namespace, 1);
    }

    @Override
    public List<String> findConfigNamesByNamespace(String namespace) {
        return this.currentJobConfigRepo.findConfigNamesByNamespace(namespace);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int deleteAll(int limitNum) {
        return this.currentJobConfigRepo.deleteAll(limitNum);
    }
}

