/*
 * Decompiled with CFR 0.152.
 */
package com.vip.saturn.job.console.mybatis.service.impl;

import com.vip.saturn.job.console.mybatis.entity.NamespaceInfo;
import com.vip.saturn.job.console.mybatis.repository.NamespaceInfoRepository;
import com.vip.saturn.job.console.mybatis.service.NamespaceInfoService;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class NamespaceInfoServiceImpl
implements NamespaceInfoService {
    private static final Logger log = LoggerFactory.getLogger(NamespaceInfoServiceImpl.class);
    private static final int BATCH_NUM = 2000;
    @Autowired
    private NamespaceInfoRepository namespaceInfoRepository;

    @Override
    public NamespaceInfo selectByNamespace(String namespace) {
        return this.namespaceInfoRepository.selectByNamespace(namespace);
    }

    @Override
    public List<NamespaceInfo> selectAll() {
        return this.namespaceInfoRepository.selectAll();
    }

    @Override
    public List<NamespaceInfo> selectAll(List<String> nsList) {
        return this.namespaceInfoRepository.selectAllByNamespaces(nsList);
    }

    @Override
    @Transactional
    public void create(NamespaceInfo namespaceInfo) {
        this.namespaceInfoRepository.insert(namespaceInfo);
    }

    @Override
    public void update(NamespaceInfo namespaceInfo) {
        this.namespaceInfoRepository.update(namespaceInfo);
    }

    @Override
    @Transactional
    public void replaceAll(List<NamespaceInfo> namespaceInfos) {
        this.deleteAll();
        if (CollectionUtils.isEmpty(namespaceInfos)) {
            return;
        }
        this.batchCreate(namespaceInfos);
    }

    @Override
    @Transactional
    public void batchCreate(List<NamespaceInfo> namespaceInfos) {
        List<NamespaceInfo> toInsertList;
        if (CollectionUtils.isEmpty(namespaceInfos)) {
            return;
        }
        int divNum = namespaceInfos.size() / 2000;
        for (int i = 0; i < divNum; ++i) {
            toInsertList = namespaceInfos.subList(i * 2000, (i + 1) * 2000);
            this.namespaceInfoRepository.batchInsert(toInsertList);
        }
        if (namespaceInfos.size() > divNum * 2000) {
            toInsertList = namespaceInfos.subList(divNum * 2000, namespaceInfos.size());
            this.namespaceInfoRepository.batchInsert(toInsertList);
        }
    }

    @Override
    @Transactional
    public int deleteByNamespace(String namespace) {
        return this.namespaceInfoRepository.deleteByNamespace(namespace);
    }

    @Override
    @Transactional
    public void deleteAll() {
        int deleteNum = 0;
        while ((deleteNum = this.namespaceInfoRepository.batchDelete(2000).intValue()) >= 2000) {
            try {
                TimeUnit.MILLISECONDS.sleep(50L);
                continue;
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                continue;
            }
            break;
        }
        return;
    }
}

