/*
 * Decompiled with CFR 0.152.
 */
package com.vip.saturn.job.console.mybatis.service.impl;

import com.vip.saturn.job.console.mybatis.entity.NamespaceVersionMapping;
import com.vip.saturn.job.console.mybatis.repository.NamespaceVersionMappingRepository;
import com.vip.saturn.job.console.mybatis.service.NamespaceVersionMappingService;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class NamespaceVersionMappingServiceImpl
implements NamespaceVersionMappingService {
    @Autowired
    private NamespaceVersionMappingRepository namespaceVersionMappingRepository;

    @Override
    public int insertOrUpdate(String namespace, String versionNumber, boolean isForced, String who) {
        NamespaceVersionMapping namespaceVersionMapping = this.namespaceVersionMappingRepository.selectByNamespace(namespace);
        if (namespaceVersionMapping != null) {
            namespaceVersionMapping.setVersionNumber(versionNumber);
            namespaceVersionMapping.setIsForced(isForced);
            namespaceVersionMapping.setLastUpdatedBy(who);
            namespaceVersionMapping.setIsDeleted(false);
            return this.namespaceVersionMappingRepository.update(namespaceVersionMapping);
        }
        namespaceVersionMapping = new NamespaceVersionMapping();
        namespaceVersionMapping.setNamespace(namespace);
        namespaceVersionMapping.setVersionNumber(versionNumber);
        namespaceVersionMapping.setIsForced(isForced);
        namespaceVersionMapping.setCreatedBy(who);
        Date now = new Date();
        namespaceVersionMapping.setCreateTime(now);
        namespaceVersionMapping.setLastUpdatedBy(who);
        namespaceVersionMapping.setLastUpdateTime(now);
        namespaceVersionMapping.setIsDeleted(false);
        return this.namespaceVersionMappingRepository.insert(namespaceVersionMapping);
    }

    @Override
    @Transactional(readOnly=true)
    public List<NamespaceVersionMapping> selectAllWithNotDeleted() {
        return this.namespaceVersionMappingRepository.selectAllWithNotDeleted();
    }

    @Override
    public NamespaceVersionMapping selectByNamespace(String namespace) {
        return this.namespaceVersionMappingRepository.selectByNamespace(namespace);
    }

    @Override
    public int deleteMapping(String namespace, String versionNumber) {
        return this.namespaceVersionMappingRepository.deleteByNamespaceAndVersionNumber(namespace, versionNumber);
    }
}

