/*
 * Decompiled with CFR 0.152.
 */
package com.vip.saturn.job.console.mybatis.service.impl;

import com.vip.saturn.job.console.mybatis.entity.NamespaceZkClusterMapping;
import com.vip.saturn.job.console.mybatis.repository.NamespaceZkClusterMappingRepository;
import com.vip.saturn.job.console.mybatis.service.NamespaceZkClusterMapping4SqlService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class NamespaceZkClusterMapping4SqlServiceImpl
implements NamespaceZkClusterMapping4SqlService {
    @Autowired
    private NamespaceZkClusterMappingRepository namespaceZkClusterMappingRepository;

    private List<NamespaceZkClusterMapping> existingAll(List<NamespaceZkClusterMapping> namespaceZkClusterMappings) {
        ArrayList<NamespaceZkClusterMapping> existingAll = new ArrayList<NamespaceZkClusterMapping>();
        if (namespaceZkClusterMappings != null) {
            for (NamespaceZkClusterMapping next : namespaceZkClusterMappings) {
                if (next.getIsDeleted() != 0) continue;
                existingAll.add(next);
            }
        }
        return existingAll;
    }

    @Override
    @Transactional(readOnly=true)
    public List<NamespaceZkClusterMapping> getAllMappings() {
        return this.existingAll(this.namespaceZkClusterMappingRepository.selectAll());
    }

    @Override
    @Transactional(readOnly=true)
    public List<NamespaceZkClusterMapping> getAllMappingsOfCluster(String zkClusterKey) {
        return this.existingAll(this.namespaceZkClusterMappingRepository.selectByZkClusterKey(zkClusterKey));
    }

    @Override
    @Transactional(readOnly=true)
    public List<String> getAllNamespacesOfCluster(String zkClusterKey) {
        ArrayList<String> result = new ArrayList<String>();
        List<NamespaceZkClusterMapping> namespaceZkClusterMappings = this.existingAll(this.namespaceZkClusterMappingRepository.selectByZkClusterKey(zkClusterKey));
        for (NamespaceZkClusterMapping mapping : namespaceZkClusterMappings) {
            result.add(mapping.getNamespace());
        }
        return result;
    }

    @Override
    @Transactional(readOnly=true)
    public String getZkClusterKey(String namespace) {
        NamespaceZkClusterMapping namespaceZkClusterMapping = this.namespaceZkClusterMappingRepository.selectByNamespace(namespace);
        if (namespaceZkClusterMapping == null) {
            return null;
        }
        if (namespaceZkClusterMapping.getIsDeleted() == 1) {
            return null;
        }
        return namespaceZkClusterMapping.getZkClusterKey();
    }

    @Override
    @Transactional
    public Integer insert(String namespace, String name, String zkClusterKey, String createdBy) {
        boolean insert;
        NamespaceZkClusterMapping namespaceZkClusterMapping = this.namespaceZkClusterMappingRepository.selectByNamespace(namespace);
        if (namespaceZkClusterMapping == null) {
            namespaceZkClusterMapping = new NamespaceZkClusterMapping();
            insert = true;
        } else {
            insert = false;
        }
        Date now = new Date();
        namespaceZkClusterMapping.setIsDeleted(0);
        namespaceZkClusterMapping.setCreateTime(now);
        namespaceZkClusterMapping.setCreatedBy(createdBy);
        namespaceZkClusterMapping.setLastUpdateTime(now);
        namespaceZkClusterMapping.setLastUpdatedBy(createdBy);
        namespaceZkClusterMapping.setNamespace(namespace);
        namespaceZkClusterMapping.setName(name);
        namespaceZkClusterMapping.setZkClusterKey(zkClusterKey);
        if (insert) {
            return this.namespaceZkClusterMappingRepository.insert(namespaceZkClusterMapping);
        }
        return this.namespaceZkClusterMappingRepository.updateAllById(namespaceZkClusterMapping);
    }

    @Override
    @Transactional
    public Integer remove(String namespace, String lastUpdatedBy) {
        NamespaceZkClusterMapping namespaceZkClusterMapping = this.namespaceZkClusterMappingRepository.selectByNamespace(namespace);
        namespaceZkClusterMapping.setIsDeleted(1);
        namespaceZkClusterMapping.setLastUpdatedBy(lastUpdatedBy);
        return this.namespaceZkClusterMappingRepository.updateById(namespaceZkClusterMapping);
    }

    @Override
    @Transactional
    public Integer update(String namespace, String name, String zkClusterKey, String lastUpdatedBy) {
        NamespaceZkClusterMapping namespaceZkClusterMapping = this.namespaceZkClusterMappingRepository.selectByNamespace(namespace);
        if (name != null) {
            namespaceZkClusterMapping.setName(name);
        }
        if (zkClusterKey != null) {
            namespaceZkClusterMapping.setZkClusterKey(zkClusterKey);
        }
        namespaceZkClusterMapping.setLastUpdatedBy(lastUpdatedBy);
        return this.namespaceZkClusterMappingRepository.updateById(namespaceZkClusterMapping);
    }
}

