/*
 * Decompiled with CFR 0.152.
 */
package com.vip.saturn.job.console.mybatis.service.impl;

import com.vip.saturn.job.console.exception.SaturnJobConsoleException;
import com.vip.saturn.job.console.mybatis.entity.ReleaseVersionInfo;
import com.vip.saturn.job.console.mybatis.repository.ReleaseVersionInfoRepository;
import com.vip.saturn.job.console.mybatis.service.ReleaseVersionInfoService;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ReleaseVersionInfoServiceImpl
implements ReleaseVersionInfoService {
    @Autowired
    private ReleaseVersionInfoRepository releaseVersionInfoRepository;

    @Override
    public ReleaseVersionInfo selectByNamespace(String namespace) {
        return this.releaseVersionInfoRepository.selectByNamespace(namespace);
    }

    @Override
    public int insert(ReleaseVersionInfo releaseVersionInfo) throws SaturnJobConsoleException {
        ReleaseVersionInfo oldVersionInfo = this.selectByVersionNumber(releaseVersionInfo.getVersionNumber());
        if (oldVersionInfo != null) {
            throw new SaturnJobConsoleException("the version number " + releaseVersionInfo.getVersionNumber() + " has existed.");
        }
        releaseVersionInfo.setCreateTime(new Date());
        releaseVersionInfo.setLastUpdateTime(new Date());
        return this.releaseVersionInfoRepository.insert(releaseVersionInfo);
    }

    @Override
    public List<ReleaseVersionInfo> getVersions() {
        return this.releaseVersionInfoRepository.selectAll();
    }

    @Override
    public ReleaseVersionInfo selectByVersionNumber(String versionNumber) {
        return this.releaseVersionInfoRepository.selectByVersionNumber(versionNumber);
    }

    @Override
    public boolean isInUsing(String versionNumber) {
        int count = this.releaseVersionInfoRepository.selectInUsingNamespaceCount(versionNumber);
        return count > 0;
    }

    @Override
    public int deleteByVersionNumber(String versionNumber) throws SaturnJobConsoleException {
        ReleaseVersionInfo versionInfo = this.selectByVersionNumber(versionNumber);
        if (versionInfo == null) {
            throw new SaturnJobConsoleException("\u5220\u9664\u5931\u8d25\uff1a\u4e0d\u5b58\u5728\u7248\u672c\u53f7\u4e3a" + versionNumber + "\u7684\u53d1\u5e03\u7248\u672c");
        }
        if (this.isInUsing(versionNumber)) {
            throw new SaturnJobConsoleException("\u5220\u9664\u5931\u8d25\uff1a\u8be5\u7248\u672c\u53f7" + versionNumber + "\u5df2\u7ecf\u5728\u57df\u7684\u5f85\u5347\u7ea7\u7248\u672c\u8bbe\u7f6e\u4e2d\uff01");
        }
        return this.releaseVersionInfoRepository.deleteByVersionNumber(versionNumber);
    }

    @Override
    public int update(ReleaseVersionInfo releaseVersionInfo) {
        return this.releaseVersionInfoRepository.updateByVersionNumber(releaseVersionInfo);
    }
}

