/*
 * Decompiled with CFR 0.152.
 */
package com.vip.saturn.job.console.repository.zookeeper.impl;

import com.google.common.base.Strings;
import com.vip.saturn.job.console.exception.JobConsoleException;
import com.vip.saturn.job.console.repository.zookeeper.CuratorRepository;
import com.vip.saturn.job.console.utils.ThreadLocalCuratorClient;
import com.vip.saturn.job.sharding.utils.CuratorUtils;
import java.io.Closeable;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ACLProvider;
import org.apache.curator.framework.api.transaction.CuratorTransactionBridge;
import org.apache.curator.framework.api.transaction.CuratorTransactionFinal;
import org.apache.curator.framework.api.transaction.CuratorTransactionResult;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.curator.utils.CloseableUtils;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository
public class CuratorRepositoryImpl
implements CuratorRepository {
    private static final int WAITING_SECONDS = 2;
    protected static Logger log = LoggerFactory.getLogger(CuratorRepositoryImpl.class);
    private static final int SESSION_TIMEOUT = 20000;
    private static final int CONNECTION_TIMEOUT = 20000;

    @Override
    public CuratorFramework connect(String connectString, String namespace, String digest) {
        CuratorFrameworkFactory.Builder builder = CuratorFrameworkFactory.builder().connectString(connectString).sessionTimeoutMs(20000).connectionTimeoutMs(20000).retryPolicy((RetryPolicy)new ExponentialBackoffRetry(1000, 3, 3000));
        if (namespace != null) {
            builder.namespace(namespace);
        }
        if (!Strings.isNullOrEmpty((String)digest)) {
            builder.authorization("digest", digest.getBytes(Charset.forName("UTF-8"))).aclProvider(new ACLProvider(){

                public List<ACL> getDefaultAcl() {
                    return ZooDefs.Ids.CREATOR_ALL_ACL;
                }

                public List<ACL> getAclForPath(String path) {
                    return ZooDefs.Ids.CREATOR_ALL_ACL;
                }
            });
        }
        CuratorFramework client = builder.build();
        client.start();
        boolean established = false;
        try {
            established = client.blockUntilConnected(2, TimeUnit.SECONDS);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        if (established) {
            return client;
        }
        CloseableUtils.closeQuietly((Closeable)client);
        return null;
    }

    @Override
    public CuratorRepository.CuratorFrameworkOp inSessionClient() {
        return new CuratorFrameworkOpImpl(ThreadLocalCuratorClient.getCuratorClient());
    }

    @Override
    public CuratorRepository.CuratorFrameworkOp newCuratorFrameworkOp(CuratorFramework curatorFramework) {
        return new CuratorFrameworkOpImpl(curatorFramework);
    }

    static class CuratorFrameworkOpImpl
    implements CuratorRepository.CuratorFrameworkOp {
        private CuratorFramework curatorFramework;

        public CuratorFrameworkOpImpl(CuratorFramework curatorFramework) {
            this.curatorFramework = curatorFramework;
        }

        @Override
        public boolean checkExists(String znode) {
            try {
                return null != this.curatorFramework.checkExists().forPath(znode);
            }
            catch (Exception ex) {
                throw new JobConsoleException(ex);
            }
        }

        @Override
        public String getData(String znode) {
            try {
                if (this.checkExists(znode)) {
                    byte[] getZnodeData = (byte[])this.curatorFramework.getData().forPath(znode);
                    if (getZnodeData == null) {
                        return null;
                    }
                    return new String(getZnodeData, Charset.forName("UTF-8"));
                }
                return null;
            }
            catch (KeeperException.NoNodeException ignore) {
                return null;
            }
            catch (Exception ex) {
                throw new JobConsoleException(ex);
            }
        }

        @Override
        public List<String> getChildren(String znode) {
            try {
                return (List)this.curatorFramework.getChildren().forPath(znode);
            }
            catch (KeeperException.NoNodeException ignore) {
                return null;
            }
            catch (Exception ex) {
                throw new JobConsoleException(ex);
            }
        }

        @Override
        public void create(String znode) {
            this.create(znode, "");
        }

        @Override
        public void create(String znode, Object data) {
            try {
                this.curatorFramework.create().creatingParentsIfNeeded().forPath(znode, data.toString().getBytes(Charset.forName("UTF-8")));
            }
            catch (KeeperException.NodeExistsException ignore) {
            }
            catch (Exception ex) {
                throw new JobConsoleException(ex);
            }
        }

        @Override
        public void update(String znode, Object value) {
            try {
                if (this.checkExists(znode)) {
                    ((CuratorTransactionBridge)((CuratorTransactionBridge)this.curatorFramework.inTransaction().check().forPath(znode)).and().setData().forPath(znode, value.toString().getBytes(Charset.forName("UTF-8")))).and().commit();
                } else {
                    this.create(znode, value);
                }
            }
            catch (KeeperException.NoNodeException ignore) {
            }
            catch (Exception ex) {
                throw new JobConsoleException(ex);
            }
        }

        @Override
        public void delete(String znode) {
            try {
                if (null != this.curatorFramework.checkExists().forPath(znode)) {
                    this.curatorFramework.delete().forPath(znode);
                }
            }
            catch (KeeperException.NoNodeException ignore) {
            }
            catch (Exception ex) {
                throw new JobConsoleException(ex);
            }
        }

        @Override
        public void deleteRecursive(String znode) {
            try {
                if (null != this.curatorFramework.checkExists().forPath(znode)) {
                    CuratorUtils.deletingChildrenIfNeeded((CuratorFramework)this.curatorFramework, (String)znode);
                }
            }
            catch (KeeperException.NoNodeException ignore) {
            }
            catch (Exception ex) {
                throw new JobConsoleException(ex);
            }
        }

        @Override
        public void fillJobNodeIfNotExist(String node, Object value) {
            if (null == value) {
                log.info("job node value is null, node:{}", (Object)node);
                return;
            }
            if (!this.checkExists(node)) {
                try {
                    this.curatorFramework.create().creatingParentsIfNeeded().forPath(node, value.toString().getBytes(Charset.forName("UTF-8")));
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }

        @Override
        public Stat getStat(String node) {
            try {
                return (Stat)this.curatorFramework.checkExists().forPath(node);
            }
            catch (Exception ex) {
                throw new JobConsoleException(ex);
            }
        }

        @Override
        public long getMtime(String node) {
            try {
                Stat stat = (Stat)this.curatorFramework.checkExists().forPath(node);
                if (stat != null) {
                    return stat.getMtime();
                }
                return 0L;
            }
            catch (Exception ex) {
                throw new JobConsoleException(ex);
            }
        }

        @Override
        public long getCtime(String node) {
            try {
                Stat stat = (Stat)this.curatorFramework.checkExists().forPath(node);
                if (stat != null) {
                    return stat.getCtime();
                }
                return 0L;
            }
            catch (Exception ex) {
                throw new JobConsoleException(ex);
            }
        }

        @Override
        public CuratorRepository.CuratorFrameworkOp.CuratorTransactionOp inTransaction() {
            try {
                return new CuratorTransactionOpImpl(this.curatorFramework);
            }
            catch (Exception ex) {
                throw new JobConsoleException(ex);
            }
        }

        @Override
        public CuratorFramework getCuratorFramework() {
            return this.curatorFramework;
        }

        static class CuratorTransactionOpImpl
        implements CuratorRepository.CuratorFrameworkOp.CuratorTransactionOp {
            private CuratorTransactionFinal curatorTransactionFinal;
            private CuratorFramework curatorClient;

            public CuratorTransactionOpImpl(CuratorFramework curatorClient) {
                this.curatorClient = curatorClient;
                try {
                    this.curatorTransactionFinal = ((CuratorTransactionBridge)curatorClient.inTransaction().check().forPath("/")).and();
                }
                catch (Exception ex) {
                    throw new JobConsoleException(ex);
                }
            }

            private boolean checkExists(String znode) throws Exception {
                return this.curatorClient.checkExists().forPath(znode) != null;
            }

            private CuratorTransactionOpImpl create(String znode, byte[] data) throws Exception {
                this.curatorTransactionFinal = ((CuratorTransactionBridge)this.curatorTransactionFinal.create().forPath(znode, data)).and();
                return this;
            }

            private byte[] getData(String znode) throws Exception {
                return (byte[])this.curatorClient.getData().forPath(znode);
            }

            private byte[] toData(Object value) {
                return (value == null ? "" : value.toString()).getBytes(Charset.forName("UTF-8"));
            }

            private boolean bytesEquals(byte[] a, byte[] b) {
                if (a == null || b == null) {
                    return a == null && b == null;
                }
                if (a.length != b.length) {
                    return false;
                }
                int size = a.length;
                for (int i = 0; i < size; ++i) {
                    if (a[i] == b[i]) continue;
                    return false;
                }
                return true;
            }

            @Override
            public CuratorTransactionOpImpl replaceIfChanged(String znode, Object value) throws Exception {
                return this.replaceIfChanged(znode, value, new AtomicInteger(0));
            }

            @Override
            public CuratorTransactionOpImpl replaceIfChanged(String znode, Object value, AtomicInteger changedCount) throws Exception {
                byte[] newData = this.toData(value);
                if (this.checkExists(znode)) {
                    byte[] oldData = this.getData(znode);
                    if (!this.bytesEquals(newData, oldData)) {
                        this.curatorTransactionFinal = ((CuratorTransactionBridge)((CuratorTransactionBridge)this.curatorTransactionFinal.check().forPath(znode)).and().setData().forPath(znode, newData)).and();
                        changedCount.incrementAndGet();
                    }
                } else {
                    this.create(znode, newData);
                    changedCount.incrementAndGet();
                }
                return this;
            }

            @Override
            public CuratorTransactionOpImpl create(String znode) throws Exception {
                this.curatorTransactionFinal = ((CuratorTransactionBridge)this.curatorTransactionFinal.create().forPath(znode)).and();
                return this;
            }

            @Override
            public CuratorRepository.CuratorFrameworkOp.CuratorTransactionOp delete(String znode) throws Exception {
                this.curatorTransactionFinal = ((CuratorTransactionBridge)this.curatorTransactionFinal.delete().forPath(znode)).and();
                return this;
            }

            @Override
            public Collection<CuratorTransactionResult> commit() throws Exception {
                return this.curatorTransactionFinal.commit();
            }
        }
    }
}

