/*
 * Decompiled with CFR 0.152.
 */
package com.vip.saturn.job.console.response.converter;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.DefaultSerializerProvider;
import com.fasterxml.jackson.databind.ser.std.NonTypedScalarSerializerBase;
import java.io.IOException;
import java.lang.reflect.Type;

public class CustomNullValueMapper
extends ObjectMapper {
    private static final long serialVersionUID = 1L;

    public CustomNullValueMapper() {
        DefaultSerializerProvider.Impl sp = new DefaultSerializerProvider.Impl();
        sp.setNullValueSerializer((JsonSerializer)new JsonSerializer<Object>(){

            public void serialize(Object value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
                jgen.writeString("");
            }
        });
        this.setSerializerProvider((DefaultSerializerProvider)sp);
        SimpleModule module = new SimpleModule();
        module.addSerializer(String.class, (JsonSerializer)new CustomStringSerializer());
        this.registerModule((Module)module);
    }

    class CustomStringSerializer
    extends NonTypedScalarSerializerBase<String> {
        public CustomStringSerializer() {
            super(String.class);
        }

        public boolean isEmpty(String value) {
            return value == null || value.length() == 0;
        }

        public void serialize(String value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeString(value == null ? "" : ("null".equals(value) ? "" : value));
        }

        public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
            return this.createSchemaNode("string", true);
        }

        public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
            if (visitor != null) {
                visitor.expectStringFormat(typeHint);
            }
        }
    }
}

