/*
 * Decompiled with CFR 0.152.
 */
package com.vip.saturn.job.console.service;

import com.vip.saturn.job.console.domain.DependencyJob;
import com.vip.saturn.job.console.domain.ExecutionInfo;
import com.vip.saturn.job.console.domain.ExecutorProvided;
import com.vip.saturn.job.console.domain.ImportJobResult;
import com.vip.saturn.job.console.domain.JobConfig;
import com.vip.saturn.job.console.domain.JobServer;
import com.vip.saturn.job.console.domain.JobServerStatus;
import com.vip.saturn.job.console.domain.JobStatus;
import com.vip.saturn.job.console.exception.SaturnJobConsoleException;
import com.vip.saturn.job.console.repository.zookeeper.CuratorRepository;
import com.vip.saturn.job.console.vo.GetJobConfigVo;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.springframework.web.multipart.MultipartFile;

public interface JobService {
    public List<String> getGroups(String var1) throws SaturnJobConsoleException;

    public List<DependencyJob> getDependingJobs(String var1, String var2) throws SaturnJobConsoleException;

    public List<DependencyJob> getDependedJobs(String var1, String var2) throws SaturnJobConsoleException;

    public void enableJob(String var1, String var2, String var3) throws SaturnJobConsoleException;

    public void disableJob(String var1, String var2, String var3) throws SaturnJobConsoleException;

    public void removeJob(String var1, String var2) throws SaturnJobConsoleException;

    public List<ExecutorProvided> getCandidateExecutors(String var1, String var2) throws SaturnJobConsoleException;

    public void setPreferList(String var1, String var2, String var3, String var4) throws SaturnJobConsoleException;

    public void addJob(String var1, JobConfig var2, String var3) throws SaturnJobConsoleException;

    public void copyJob(String var1, JobConfig var2, String var3, String var4) throws SaturnJobConsoleException;

    public int getMaxJobNum() throws SaturnJobConsoleException;

    public boolean jobIncExceeds(String var1, int var2, int var3) throws SaturnJobConsoleException;

    public List<JobConfig> getUnSystemJobs(String var1) throws SaturnJobConsoleException;

    public List<JobConfig> getUnSystemJobsWithCondition(String var1, Map<String, Object> var2, int var3, int var4) throws SaturnJobConsoleException;

    public int countUnSystemJobsWithCondition(String var1, Map<String, Object> var2);

    public int countEnabledUnSystemJobs(String var1);

    @Deprecated
    public List<String> getUnSystemJobNames(String var1) throws SaturnJobConsoleException;

    public List<String> getJobNames(String var1) throws SaturnJobConsoleException;

    public void persistJobFromDB(String var1, JobConfig var2) throws SaturnJobConsoleException;

    public void persistJobFromDB(JobConfig var1, CuratorRepository.CuratorFrameworkOp var2) throws SaturnJobConsoleException;

    public List<ImportJobResult> importJobs(String var1, MultipartFile var2, String var3) throws SaturnJobConsoleException;

    public File exportJobs(String var1) throws SaturnJobConsoleException;

    public JobConfig getJobConfigFromZK(String var1, String var2) throws SaturnJobConsoleException;

    public JobConfig getJobConfig(String var1, String var2) throws SaturnJobConsoleException;

    public JobStatus getJobStatus(String var1, String var2) throws SaturnJobConsoleException;

    public JobStatus getJobStatus(String var1, JobConfig var2) throws SaturnJobConsoleException;

    public boolean isJobShardingAllocatedExecutor(String var1, String var2) throws SaturnJobConsoleException;

    public List<String> getJobServerList(String var1, String var2) throws SaturnJobConsoleException;

    public GetJobConfigVo getJobConfigVo(String var1, String var2) throws SaturnJobConsoleException;

    public void updateJobConfig(String var1, JobConfig var2, String var3) throws SaturnJobConsoleException;

    public List<String> getAllJobNamesFromZK(String var1) throws SaturnJobConsoleException;

    public void updateJobCron(String var1, String var2, String var3, Map<String, String> var4, String var5) throws SaturnJobConsoleException;

    public List<JobServer> getJobServers(String var1, String var2) throws SaturnJobConsoleException;

    public List<JobServerStatus> getJobServersStatus(String var1, String var2) throws SaturnJobConsoleException;

    public void runAtOnce(String var1, String var2) throws SaturnJobConsoleException;

    public void stopAtOnce(String var1, String var2) throws SaturnJobConsoleException;

    public List<ExecutionInfo> getExecutionStatus(String var1, String var2) throws SaturnJobConsoleException;

    public String getExecutionLog(String var1, String var2, String var3) throws SaturnJobConsoleException;
}

