/*
 * Decompiled with CFR 0.152.
 */
package com.vip.saturn.job.console.service.cache;

import com.vip.saturn.job.console.utils.ConsoleThreadFactory;
import com.vip.saturn.job.console.utils.LocalHostService;
import com.vip.saturn.job.sharding.listener.AbstractConnectionListener;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.recipes.cache.NodeCache;
import org.apache.curator.framework.recipes.cache.NodeCacheListener;
import org.apache.curator.framework.recipes.leader.LeaderLatch;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DashboardLeaderHandler {
    private static final Logger log = LoggerFactory.getLogger(DashboardLeaderHandler.class);
    private final String hostValue = LocalHostService.cachedIpAddress + "-" + UUID.randomUUID().toString();
    private String zkAlias;
    private CuratorFramework curatorFramework;
    private NodeCache nodeCache;
    private ExecutorService executorService;
    private DashboardLeaderConnectionListener dashboardLeaderConnectionListener;

    public DashboardLeaderHandler(String zkAlias, CuratorFramework curatorFramework) {
        this.zkAlias = zkAlias;
        this.curatorFramework = curatorFramework;
    }

    public void start() throws Exception {
        this.dashboardLeaderConnectionListener = new DashboardLeaderConnectionListener("connectionListener-for-dashboardLeaderHandler-" + this.zkAlias);
        this.curatorFramework.getConnectionStateListenable().addListener((Object)this.dashboardLeaderConnectionListener);
        this.createNodeCache();
        this.electLeaderIfNecessary();
    }

    private void createNodeCache() throws Exception {
        this.executorService = Executors.newSingleThreadExecutor(new ConsoleThreadFactory("nodeCache-for-dashboardLeaderHost-" + this.zkAlias, false));
        this.nodeCache = new NodeCache(this.curatorFramework, "/$SaturnSelf/saturn-console/dashboard/leader/host");
        this.nodeCache.start();
        this.nodeCache.getListenable().addListener((Object)new NodeCacheListener(){

            public void nodeChanged() throws Exception {
                DashboardLeaderHandler.this.electLeaderIfNecessary();
            }
        }, (Executor)this.executorService);
    }

    private void electLeaderIfNecessary() throws Exception {
        if (!this.hasLeader()) {
            this.electLeader();
        }
    }

    private boolean hasLeader() throws Exception {
        if (!this.curatorFramework.getZookeeperClient().isConnected()) {
            return false;
        }
        Stat stat = (Stat)this.curatorFramework.checkExists().forPath("/$SaturnSelf/saturn-console/dashboard/leader/host");
        return stat != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void electLeader() throws Exception {
        LeaderLatch leaderLatch = null;
        try {
            if (!this.curatorFramework.getZookeeperClient().isConnected()) {
                return;
            }
            leaderLatch = new LeaderLatch(this.curatorFramework, "/$SaturnSelf/saturn-console/dashboard/leader/latch");
            leaderLatch.start();
            int timeoutSeconds = 60;
            if (leaderLatch.await((long)timeoutSeconds, TimeUnit.SECONDS)) {
                if (!this.hasLeader()) {
                    ((ACLBackgroundPathAndBytesable)this.curatorFramework.create().creatingParentsIfNeeded().withMode(CreateMode.EPHEMERAL)).forPath("/$SaturnSelf/saturn-console/dashboard/leader/host", this.hostValue.getBytes("UTF-8"));
                }
            } else {
                log.error("Try to elect dashboard leader timeout({}s), zkCluster zkAlias is {}", (Object)timeoutSeconds, (Object)this.zkAlias);
            }
        }
        finally {
            if (leaderLatch != null) {
                try {
                    leaderLatch.close();
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private void releaseLeader() {
        try {
            String data;
            byte[] bytes;
            if (!this.curatorFramework.getZookeeperClient().isConnected()) {
                return;
            }
            if (this.curatorFramework.checkExists().forPath("/$SaturnSelf/saturn-console/dashboard/leader/host") != null && (bytes = (byte[])this.curatorFramework.getData().forPath("/$SaturnSelf/saturn-console/dashboard/leader/host")) != null && (data = new String(bytes, "UTF-8")).equals(this.hostValue)) {
                this.curatorFramework.delete().guaranteed().deletingChildrenIfNeeded().forPath("/$SaturnSelf/saturn-console/dashboard/leader/host");
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private void removeAndShutdownConnectionListener() {
        try {
            if (this.dashboardLeaderConnectionListener != null) {
                this.curatorFramework.getConnectionStateListenable().removeListener((Object)this.dashboardLeaderConnectionListener);
                this.dashboardLeaderConnectionListener.shutdownNowUntilTerminated();
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private void closeNodeCache() {
        try {
            if (this.nodeCache != null) {
                this.nodeCache.close();
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        if (this.executorService != null) {
            this.executorService.shutdownNow();
        }
    }

    public void shutdown() {
        this.removeAndShutdownConnectionListener();
        this.closeNodeCache();
        this.releaseLeader();
    }

    public void shutdownWithCurator() {
        this.shutdown();
        this.curatorFramework.close();
    }

    public boolean isLeader() {
        try {
            this.electLeaderIfNecessary();
            if (!this.curatorFramework.getZookeeperClient().isConnected()) {
                return false;
            }
            byte[] bytes = (byte[])this.curatorFramework.getData().forPath("/$SaturnSelf/saturn-console/dashboard/leader/host");
            if (bytes != null) {
                String data = new String(bytes, "UTF-8");
                return data.equals(this.hostValue);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return false;
    }

    class DashboardLeaderConnectionListener
    extends AbstractConnectionListener {
        public DashboardLeaderConnectionListener(String threadName) {
            super(threadName);
        }

        public void stop() {
            DashboardLeaderHandler.this.closeNodeCache();
        }

        public void restart() {
            try {
                DashboardLeaderHandler.this.createNodeCache();
                DashboardLeaderHandler.this.electLeaderIfNecessary();
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }
}

