/*
 * Decompiled with CFR 0.152.
 */
package com.vip.saturn.job.console.service.helper;

import com.vip.saturn.job.console.service.SystemConfigService;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkClusterMappingUtils {
    private static final Logger log = LoggerFactory.getLogger(ZkClusterMappingUtils.class);
    private static final String DEFAULT_CONSOLE_CLUSTER_ID = "default";
    private static final String NAME_VIP_SATURN_CONSOLE_CLUSTER = "VIP_SATURN_CONSOLE_CLUSTER";
    public static String VIP_SATURN_CONSOLE_CLUSTER_ID = StringUtils.trim((String)System.getProperty("VIP_SATURN_CONSOLE_CLUSTER", System.getenv("VIP_SATURN_CONSOLE_CLUSTER")));

    public static String getIdcByZkClusterKey(SystemConfigService systemConfigService, String zkClusterKey) {
        return ZkClusterMappingUtils.getValue(systemConfigService, "IDC_ZK_CLUSTER_MAPPING", zkClusterKey);
    }

    private static String getValue(SystemConfigService systemConfigService, String mappingName, String key) {
        String[] split;
        String mappingValue = StringUtils.deleteWhitespace((String)systemConfigService.getValueDirectly(mappingName));
        if (StringUtils.isBlank((CharSequence)mappingValue)) {
            log.warn("The {} is not configured in sys_config", (Object)mappingName);
            return null;
        }
        for (String temp : split = mappingValue.split(";")) {
            String[] valuesArray;
            int idx = temp.indexOf(58);
            if (idx < 0) {
                log.warn("The {}' value {}, whose format is not correct, should like key:value1,value2;key2:value3,value4", (Object)mappingName, (Object)mappingValue);
                return null;
            }
            String tempKey = temp.substring(0, idx);
            String tempValues = temp.substring(idx + 1);
            for (String value : valuesArray = tempValues.split(",")) {
                if (!value.equals(key)) continue;
                return tempKey;
            }
        }
        return null;
    }

    public static String getIdcByConsoleId(SystemConfigService systemConfigService, String consoleId) {
        return ZkClusterMappingUtils.getValue(systemConfigService, "IDC_CONSOLE_ID_MAPPING", consoleId);
    }

    public static boolean isCurrentConsoleInTheSameIdc(SystemConfigService systemConfigService, String zkClusterKey) {
        try {
            String zkClusterIdc = ZkClusterMappingUtils.getIdcByZkClusterKey(systemConfigService, zkClusterKey);
            if (StringUtils.isBlank((CharSequence)zkClusterIdc)) {
                log.warn("The mapping idc is not found for the zkClusterKey that is {}", (Object)zkClusterKey);
                return true;
            }
            String consoleIdc = ZkClusterMappingUtils.getIdcByConsoleId(systemConfigService, VIP_SATURN_CONSOLE_CLUSTER_ID);
            return zkClusterIdc.equalsIgnoreCase(consoleIdc);
        }
        catch (Exception e) {
            log.error("isCurrentConsoleInTheSameIdc error, will return true", (Throwable)e);
            return true;
        }
    }

    public static String getConsoleDomainByIdc(SystemConfigService systemConfigService, String idc) {
        String[] split;
        String mappingValue = StringUtils.deleteWhitespace((String)systemConfigService.getValueDirectly("IDC_CONSOLE_DOMAIN_MAPPING"));
        if (StringUtils.isBlank((CharSequence)mappingValue)) {
            log.warn("The {} is not configured in sys_config", (Object)"IDC_CONSOLE_DOMAIN_MAPPING");
            return null;
        }
        for (String temp : split = mappingValue.split(";")) {
            int idx = temp.indexOf(58);
            if (idx < 0) {
                log.warn("The {}' value {}, whose format is not correct, should like key:value;key2:value2", (Object)"IDC_CONSOLE_DOMAIN_MAPPING", (Object)mappingValue);
                return null;
            }
            String tempIdc = temp.substring(0, idx);
            String tempDomain = temp.substring(idx + 1);
            if (!tempIdc.equals(idc)) continue;
            return tempDomain;
        }
        return null;
    }

    public static String getConsoleDomainByZkClusterKey(SystemConfigService systemConfigService, String zkClusterKey) {
        String idc = ZkClusterMappingUtils.getIdcByZkClusterKey(systemConfigService, zkClusterKey);
        return StringUtils.isNotBlank((CharSequence)idc) ? ZkClusterMappingUtils.getConsoleDomainByIdc(systemConfigService, idc) : null;
    }

    static {
        if (StringUtils.isBlank((CharSequence)VIP_SATURN_CONSOLE_CLUSTER_ID)) {
            log.warn("The {} is not configured, will use the default value that is {}", (Object)NAME_VIP_SATURN_CONSOLE_CLUSTER, (Object)DEFAULT_CONSOLE_CLUSTER_ID);
            VIP_SATURN_CONSOLE_CLUSTER_ID = DEFAULT_CONSOLE_CLUSTER_ID;
        }
    }
}

