/*
 * Decompiled with CFR 0.152.
 */
package com.vip.saturn.job.console.service.impl;

import com.alibaba.fastjson.JSON;
import com.vip.saturn.job.console.domain.AbnormalContainer;
import com.vip.saturn.job.console.domain.AbnormalJob;
import com.vip.saturn.job.console.domain.AbstractAlarmJob;
import com.vip.saturn.job.console.domain.AlarmJobCount;
import com.vip.saturn.job.console.domain.RegistryCenterConfiguration;
import com.vip.saturn.job.console.domain.Timeout4AlarmJob;
import com.vip.saturn.job.console.domain.ZkCluster;
import com.vip.saturn.job.console.exception.SaturnJobConsoleException;
import com.vip.saturn.job.console.mybatis.entity.SaturnStatistics;
import com.vip.saturn.job.console.mybatis.service.SaturnStatisticsService;
import com.vip.saturn.job.console.service.AlarmStatisticsService;
import com.vip.saturn.job.console.service.RegistryCenterService;
import com.vip.saturn.job.console.service.helper.DashboardServiceHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;

public class AlarmStatisticsServiceImpl
implements AlarmStatisticsService {
    @Resource
    private RegistryCenterService registryCenterService;
    @Resource
    private SaturnStatisticsService saturnStatisticsService;

    @Override
    public String getAbnormalJobsString() throws SaturnJobConsoleException {
        List<AbnormalJob> abnormalJobList = this.getAbnormalJobList();
        return JSON.toJSONString(DashboardServiceHelper.sortUnnormaoJobByTimeDesc(abnormalJobList));
    }

    @Override
    public String getUnableFailoverJobsString() throws SaturnJobConsoleException {
        List<AbnormalJob> abnormalJobList = this.getUnableFailoverJobList();
        return JSON.toJSONString(abnormalJobList);
    }

    @Override
    public String getTimeout4AlarmJobsString() throws SaturnJobConsoleException {
        List<Timeout4AlarmJob> timeout4AlarmJobList = this.getTimeout4AlarmJobList();
        return JSON.toJSONString(timeout4AlarmJobList);
    }

    @Override
    public List<AlarmJobCount> getCountOfAlarmJobs() throws SaturnJobConsoleException {
        ArrayList<AlarmJobCount> alarmJobCountList = new ArrayList<AlarmJobCount>();
        alarmJobCountList.add(new AlarmJobCount("unnormal_job", this.getAbnormalJobList().size()));
        alarmJobCountList.add(new AlarmJobCount("unable_failover_job", this.getUnableFailoverJobList().size()));
        alarmJobCountList.add(new AlarmJobCount("timeout_4_alarm_job", this.getTimeout4AlarmJobList().size()));
        return alarmJobCountList;
    }

    @Override
    public String getAbnormalContainers() throws SaturnJobConsoleException {
        ArrayList abnormalContainerList = new ArrayList();
        Collection<ZkCluster> zkClusterList = this.registryCenterService.getZkClusterList();
        for (ZkCluster zkCluster : zkClusterList) {
            String result = this.getAbnormalContainers(zkCluster.getZkClusterKey());
            List tempList = JSON.parseArray((String)result, AbnormalContainer.class);
            if (tempList == null) continue;
            abnormalContainerList.addAll(tempList);
        }
        return JSON.toJSONString(abnormalContainerList);
    }

    @Override
    public void setAbnormalJobMonitorStatusToRead(String uuid) throws SaturnJobConsoleException {
        if (StringUtils.isBlank((CharSequence)uuid)) {
            throw new SaturnJobConsoleException("uuid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.setAlarmJobMonitorStatusToRead(uuid, "unnormal_job", AbnormalJob.class);
    }

    @Override
    public void setTimeout4AlarmJobMonitorStatusToRead(String uuid) throws SaturnJobConsoleException {
        if (StringUtils.isBlank((CharSequence)uuid)) {
            throw new SaturnJobConsoleException("uuid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.setAlarmJobMonitorStatusToRead(uuid, "timeout_4_alarm_job", Timeout4AlarmJob.class);
    }

    public List<AbnormalJob> getAbnormalJobList() throws SaturnJobConsoleException {
        ArrayList<AbnormalJob> abnormalJobList = new ArrayList<AbnormalJob>();
        Collection<ZkCluster> zkClusterList = this.registryCenterService.getZkClusterList();
        for (ZkCluster zkCluster : zkClusterList) {
            String result = this.getAbnormalJobsStringByZKCluster(zkCluster.getZkClusterKey());
            List tempList = JSON.parseArray((String)result, AbnormalJob.class);
            if (tempList == null) continue;
            abnormalJobList.addAll(tempList);
        }
        return abnormalJobList;
    }

    public List<AbnormalJob> getUnableFailoverJobList() throws SaturnJobConsoleException {
        ArrayList<AbnormalJob> abnormalJobList = new ArrayList<AbnormalJob>();
        Collection<ZkCluster> zkClusterList = this.registryCenterService.getZkClusterList();
        for (ZkCluster zkCluster : zkClusterList) {
            String result = this.getUnableFailoverJobsStringByZKCluster(zkCluster.getZkClusterKey());
            List tempList = JSON.parseArray((String)result, AbnormalJob.class);
            if (tempList == null) continue;
            abnormalJobList.addAll(tempList);
        }
        return abnormalJobList;
    }

    public List<Timeout4AlarmJob> getTimeout4AlarmJobList() throws SaturnJobConsoleException {
        ArrayList<Timeout4AlarmJob> timeout4AlarmJobList = new ArrayList<Timeout4AlarmJob>();
        Collection<ZkCluster> zkClusterList = this.registryCenterService.getZkClusterList();
        for (ZkCluster zkCluster : zkClusterList) {
            String result = this.getTimeout4AlarmJobsStringByZKCluster(zkCluster.getZkClusterKey());
            List tempList = JSON.parseArray((String)result, Timeout4AlarmJob.class);
            if (tempList == null) continue;
            timeout4AlarmJobList.addAll(tempList);
        }
        return timeout4AlarmJobList;
    }

    private <T extends AbstractAlarmJob> void setAlarmJobMonitorStatusToRead(String uuid, String alarmJobType, Class<T> t) throws SaturnJobConsoleException {
        Collection<ZkCluster> zkClusterList = this.registryCenterService.getZkClusterList();
        for (ZkCluster zkCluster : zkClusterList) {
            String result;
            List jobs;
            SaturnStatistics saturnStatistics = this.saturnStatisticsService.findStatisticsByNameAndZkList(alarmJobType, zkCluster.getZkAddr());
            if (null == saturnStatistics || (jobs = JSON.parseArray((String)(result = saturnStatistics.getResult()), t)) == null) continue;
            boolean find = false;
            for (AbstractAlarmJob job : jobs) {
                if (!uuid.equals(job.getUuid())) continue;
                job.setRead(true);
                find = true;
                break;
            }
            if (!find) continue;
            saturnStatistics.setResult(JSON.toJSONString((Object)jobs));
            this.saturnStatisticsService.updateByPrimaryKeySelective(saturnStatistics);
            return;
        }
        throw new SaturnJobConsoleException(String.format("\u8be5uuid(%s)\u4e0d\u5b58\u5728", uuid));
    }

    private ZkCluster validateAndGetZKCluster(String zkClusterKey) throws SaturnJobConsoleException {
        ZkCluster zkCluster = this.registryCenterService.getZkCluster(zkClusterKey);
        if (zkCluster == null) {
            throw new SaturnJobConsoleException(String.format("\u8be5\u96c6\u7fa4key(%s)\u4e0d\u5b58\u5728", zkClusterKey));
        }
        return zkCluster;
    }

    @Override
    public String getAbnormalJobsStringByZKCluster(String zkClusterKey) throws SaturnJobConsoleException {
        ZkCluster zkCluster = this.validateAndGetZKCluster(zkClusterKey);
        SaturnStatistics saturnStatistics = this.saturnStatisticsService.findStatisticsByNameAndZkList("unnormal_job", zkCluster.getZkAddr());
        return saturnStatistics != null ? saturnStatistics.getResult() : null;
    }

    @Override
    public String getUnableFailoverJobsStringByZKCluster(String zkClusterKey) throws SaturnJobConsoleException {
        ZkCluster zkCluster = this.validateAndGetZKCluster(zkClusterKey);
        SaturnStatistics saturnStatistics = this.saturnStatisticsService.findStatisticsByNameAndZkList("unable_failover_job", zkCluster.getZkAddr());
        return saturnStatistics != null ? saturnStatistics.getResult() : null;
    }

    @Override
    public String getTimeout4AlarmJobsStringByZKCluster(String zkClusterKey) throws SaturnJobConsoleException {
        ZkCluster zkCluster = this.validateAndGetZKCluster(zkClusterKey);
        SaturnStatistics saturnStatistics = this.saturnStatisticsService.findStatisticsByNameAndZkList("timeout_4_alarm_job", zkCluster.getZkAddr());
        return saturnStatistics != null ? saturnStatistics.getResult() : null;
    }

    @Override
    public String getAbnormalContainers(String zkClusterKey) throws SaturnJobConsoleException {
        ZkCluster zkCluster = this.validateAndGetZKCluster(zkClusterKey);
        SaturnStatistics saturnStatistics = this.saturnStatisticsService.findStatisticsByNameAndZkList("abnormal_container", zkCluster.getZkAddr());
        return saturnStatistics != null ? saturnStatistics.getResult() : null;
    }

    private RegistryCenterConfiguration validateAndGetConf(String namespace) throws SaturnJobConsoleException {
        RegistryCenterConfiguration conf = this.registryCenterService.findConfigByNamespace(namespace);
        if (conf == null) {
            throw new SaturnJobConsoleException(String.format("\u8be5\u57df(%s)\u4e0d\u5b58\u5728", namespace));
        }
        return conf;
    }

    @Override
    public List<AbnormalJob> getAbnormalJobListByNamespace(String namespace) throws SaturnJobConsoleException {
        ArrayList<AbnormalJob> abnormalJobList = new ArrayList<AbnormalJob>();
        RegistryCenterConfiguration conf = this.validateAndGetConf(namespace);
        String result = this.getAbnormalJobsStringByZKCluster(conf.getZkClusterKey());
        abnormalJobList.addAll(this.getAlarmJobListFilterByNamespace(namespace, result, AbnormalJob.class));
        return abnormalJobList;
    }

    @Override
    public String getAbnormalJobsStringByNamespace(String namespace) throws SaturnJobConsoleException {
        RegistryCenterConfiguration conf = this.validateAndGetConf(namespace);
        String result = this.getAbnormalJobsStringByZKCluster(conf.getZkClusterKey());
        return JSON.toJSONString(this.getAlarmJobListFilterByNamespace(namespace, result, AbnormalJob.class));
    }

    public List<AbnormalJob> getUnableFailoverListByNamespace(String namespace) throws SaturnJobConsoleException {
        ArrayList<AbnormalJob> abnormalJobList = new ArrayList<AbnormalJob>();
        RegistryCenterConfiguration conf = this.validateAndGetConf(namespace);
        String result = this.getUnableFailoverJobsStringByZKCluster(conf.getZkClusterKey());
        abnormalJobList.addAll(this.getAlarmJobListFilterByNamespace(namespace, result, AbnormalJob.class));
        return abnormalJobList;
    }

    @Override
    public String getUnableFailoverJobsStringByNamespace(String namespace) throws SaturnJobConsoleException {
        RegistryCenterConfiguration conf = this.validateAndGetConf(namespace);
        String result = this.getUnableFailoverJobsStringByZKCluster(conf.getZkClusterKey());
        return JSON.toJSONString(this.getAlarmJobListFilterByNamespace(namespace, result, AbnormalJob.class));
    }

    public List<Timeout4AlarmJob> getTimeout4AlarmJobListByNamespace(String namespace) throws SaturnJobConsoleException {
        ArrayList<Timeout4AlarmJob> timeout4AlarmJobs = new ArrayList<Timeout4AlarmJob>();
        RegistryCenterConfiguration conf = this.validateAndGetConf(namespace);
        String result = this.getTimeout4AlarmJobsStringByZKCluster(conf.getZkClusterKey());
        timeout4AlarmJobs.addAll(this.getAlarmJobListFilterByNamespace(namespace, result, Timeout4AlarmJob.class));
        return timeout4AlarmJobs;
    }

    @Override
    public String getTimeout4AlarmJobsStringByNamespace(String namespace) throws SaturnJobConsoleException {
        RegistryCenterConfiguration conf = this.validateAndGetConf(namespace);
        String result = this.getTimeout4AlarmJobsStringByZKCluster(conf.getZkClusterKey());
        return JSON.toJSONString(this.getAlarmJobListFilterByNamespace(namespace, result, Timeout4AlarmJob.class));
    }

    @Override
    public List<AlarmJobCount> getCountOfAlarmJobsByNamespace(String namespace) throws SaturnJobConsoleException {
        ArrayList<AlarmJobCount> alarmJobCountList = new ArrayList<AlarmJobCount>();
        alarmJobCountList.add(new AlarmJobCount("unnormal_job", this.getAbnormalJobListByNamespace(namespace).size()));
        alarmJobCountList.add(new AlarmJobCount("unable_failover_job", this.getUnableFailoverListByNamespace(namespace).size()));
        alarmJobCountList.add(new AlarmJobCount("timeout_4_alarm_job", this.getTimeout4AlarmJobListByNamespace(namespace).size()));
        return alarmJobCountList;
    }

    @Override
    public String getAbnormalContainersByNamespace(String namespace) throws SaturnJobConsoleException {
        ArrayList<AbnormalContainer> jobsByNamespace = new ArrayList<AbnormalContainer>();
        RegistryCenterConfiguration conf = this.validateAndGetConf(namespace);
        String result = this.getAbnormalContainers(conf.getZkClusterKey());
        List jobs = JSON.parseArray((String)result, AbnormalContainer.class);
        if (jobs != null) {
            for (AbnormalContainer job : jobs) {
                if (!namespace.equals(job.getDomainName())) continue;
                jobsByNamespace.add(job);
            }
        }
        return JSON.toJSONString(jobsByNamespace);
    }

    @Override
    public AbnormalJob isAbnormalJob(String namespace, String jobName) throws SaturnJobConsoleException {
        RegistryCenterConfiguration conf = this.validateAndGetConf(namespace);
        String result = this.getAbnormalJobsStringByZKCluster(conf.getZkClusterKey());
        return this.getAlarmJobFilterByNamespaceAndJobName(namespace, jobName, result, AbnormalJob.class);
    }

    @Override
    public AbnormalJob isUnableFailoverJob(String namespace, String jobName) throws SaturnJobConsoleException {
        RegistryCenterConfiguration conf = this.validateAndGetConf(namespace);
        String result = this.getUnableFailoverJobsStringByZKCluster(conf.getZkClusterKey());
        return this.getAlarmJobFilterByNamespaceAndJobName(namespace, jobName, result, AbnormalJob.class);
    }

    @Override
    public Timeout4AlarmJob isTimeout4AlarmJob(String namespace, String jobName) throws SaturnJobConsoleException {
        RegistryCenterConfiguration conf = this.validateAndGetConf(namespace);
        String result = this.getTimeout4AlarmJobsStringByZKCluster(conf.getZkClusterKey());
        return this.getAlarmJobFilterByNamespaceAndJobName(namespace, jobName, result, Timeout4AlarmJob.class);
    }

    private <T extends AbstractAlarmJob> List<T> getAlarmJobListFilterByNamespace(String namespace, String result, Class<T> t) {
        ArrayList<AbstractAlarmJob> jobsByNamespace = new ArrayList<AbstractAlarmJob>();
        List jobs = JSON.parseArray((String)result, t);
        if (jobs != null) {
            for (AbstractAlarmJob job : jobs) {
                if (!namespace.equals(job.getDomainName())) continue;
                jobsByNamespace.add(job);
            }
        }
        return jobsByNamespace;
    }

    private <T extends AbstractAlarmJob> T getAlarmJobFilterByNamespaceAndJobName(String namespace, String jobName, String result, Class<T> t) {
        List jobs = JSON.parseArray((String)result, t);
        if (jobs != null) {
            for (AbstractAlarmJob job : jobs) {
                if (!namespace.equals(job.getDomainName()) || !jobName.equals(job.getJobName())) continue;
                return (T)job;
            }
        }
        return null;
    }
}

