/*
 * Decompiled with CFR 0.152.
 */
package com.vip.saturn.job.console.service.impl;

import com.vip.saturn.job.console.exception.SaturnJobConsoleException;
import com.vip.saturn.job.console.mybatis.entity.User;
import com.vip.saturn.job.console.mybatis.repository.UserRepository;
import com.vip.saturn.job.console.service.AuthenticationService;
import com.vip.saturn.job.console.utils.PasswordUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

public class AuthenticationServiceImpl
implements AuthenticationService {
    @Autowired
    private UserRepository userRepository;
    @Value(value="${authentication.hash:plaintext}")
    private String hashMethod;

    @Override
    @Transactional(readOnly=true)
    public User authenticate(String username, String password) throws SaturnJobConsoleException {
        if (StringUtils.isEmpty((Object)password)) {
            throw new SaturnJobConsoleException(4, "\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        User user = this.userRepository.select(username);
        if (user == null) {
            throw new SaturnJobConsoleException(4, "\u7528\u6237\u540d\u4e0d\u5b58\u5728");
        }
        PasswordUtils.validate(password, user.getPassword(), this.hashMethod);
        return user;
    }

    public void setHashMethod(String hashMethod) {
        this.hashMethod = hashMethod;
    }
}

