/*
 * Decompiled with CFR 0.152.
 */
package com.vip.saturn.job.console.service.impl;

import com.vip.saturn.job.console.exception.SaturnJobConsoleException;
import com.vip.saturn.job.console.mybatis.entity.Role;
import com.vip.saturn.job.console.mybatis.entity.User;
import com.vip.saturn.job.console.mybatis.entity.UserRole;
import com.vip.saturn.job.console.mybatis.repository.RoleRepository;
import com.vip.saturn.job.console.mybatis.repository.UserRepository;
import com.vip.saturn.job.console.mybatis.repository.UserRoleRepository;
import com.vip.saturn.job.console.service.AuthorizationManageService;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class AuthorizationManageServiceImpl
implements AuthorizationManageService {
    @Autowired
    protected RoleRepository roleRepository;
    @Autowired
    protected UserRepository userRepository;
    @Autowired
    protected UserRoleRepository userRoleRepository;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addUserRole(UserRole userRole) throws SaturnJobConsoleException {
        this.validateUser(userRole);
        String roleKey = userRole.getRoleKey();
        Role role = this.roleRepository.selectByKey(roleKey);
        if (role == null) {
            throw new SaturnJobConsoleException(String.format("\u89d2\u8272key(%s)\u4e0d\u5b58\u5728", roleKey));
        }
        UserRole pre = this.userRoleRepository.selectWithNotFilterDeleted(userRole);
        if (pre == null) {
            this.userRoleRepository.insert(userRole);
        } else {
            this.userRoleRepository.update(pre, userRole);
        }
    }

    protected void validateUser(UserRole userRole) throws SaturnJobConsoleException {
        String userName = userRole.getUserName();
        User user = this.userRepository.selectWithNotFilterDeleted(userName);
        if (user == null) {
            throw new SaturnJobConsoleException(String.format("\u7528\u6237\u540d(%s)\u4e0d\u5b58\u5728", userName));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteUserRole(UserRole userRole) throws SaturnJobConsoleException {
        this.userRoleRepository.delete(userRole);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateUserRole(UserRole pre, UserRole cur) throws SaturnJobConsoleException {
        this.userRoleRepository.delete(pre);
        UserRole userRole = this.userRoleRepository.selectWithNotFilterDeleted(cur);
        if (userRole == null) {
            this.userRoleRepository.insert(cur);
        } else {
            this.userRoleRepository.update(userRole, cur);
        }
    }

    @Override
    @Transactional(readOnly=true)
    public List<Role> getRoles() throws SaturnJobConsoleException {
        ArrayList roles = this.roleRepository.selectAll();
        return roles == null ? new ArrayList() : roles;
    }

    @Override
    @Transactional(readOnly=true)
    public List<UserRole> getUserRoles(String userName, String roleKey, String namespace) throws SaturnJobConsoleException {
        ArrayList userRoles = this.userRoleRepository.select(new UserRole(userName, roleKey, namespace));
        return userRoles == null ? new ArrayList() : userRoles;
    }
}

