/*
 * Decompiled with CFR 0.152.
 */
package com.vip.saturn.job.console.service.impl;

import com.vip.saturn.job.console.exception.SaturnJobConsoleException;
import com.vip.saturn.job.console.mybatis.entity.Permission;
import com.vip.saturn.job.console.mybatis.entity.Role;
import com.vip.saturn.job.console.mybatis.entity.RolePermission;
import com.vip.saturn.job.console.mybatis.entity.User;
import com.vip.saturn.job.console.mybatis.entity.UserRole;
import com.vip.saturn.job.console.mybatis.repository.PermissionRepository;
import com.vip.saturn.job.console.mybatis.repository.RolePermissionRepository;
import com.vip.saturn.job.console.mybatis.repository.RoleRepository;
import com.vip.saturn.job.console.mybatis.repository.UserRepository;
import com.vip.saturn.job.console.mybatis.repository.UserRoleRepository;
import com.vip.saturn.job.console.service.AuthorizationService;
import com.vip.saturn.job.console.service.SystemConfigService;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.transaction.annotation.Transactional;

public class AuthorizationServiceImpl
implements AuthorizationService {
    private static final Logger log = LoggerFactory.getLogger(AuthorizationServiceImpl.class);
    @Autowired
    protected PermissionRepository permissionRepository;
    @Autowired
    protected RoleRepository roleRepository;
    @Autowired
    protected UserRepository userRepository;
    @Autowired
    protected RolePermissionRepository rolePermissionRepository;
    @Autowired
    protected UserRoleRepository userRoleRepository;
    @Autowired
    protected SystemConfigService systemConfigService;
    @Value(value="${authorization.enabled.default}")
    private boolean authorizationEnabledDefault;
    protected String systemAdminRoleKey = "system_admin";
    protected ConcurrentMap<String, Role> rolesCache = new ConcurrentHashMap<String, Role>();
    private Timer refreshAuthCacheTimer = null;

    @PostConstruct
    public void init() {
        this.refreshAuthCacheTimer = new Timer("refresh-auth-cache-timer", true);
        this.refreshAuthCacheTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                try {
                    AuthorizationServiceImpl.this.refreshAuthCache();
                }
                catch (Throwable t) {
                    log.error(t.getMessage(), t);
                }
            }
        }, 1000L, 900000L);
    }

    @PreDestroy
    public void destroy() {
        if (this.refreshAuthCacheTimer != null) {
            this.refreshAuthCacheTimer.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(readOnly=true)
    public synchronized void refreshAuthCache() throws SaturnJobConsoleException {
        log.info("Start refresh auth cache");
        long startTime = System.currentTimeMillis();
        try {
            this.handleRefreshAuthCache();
        }
        finally {
            log.info("End refresh auth cache, cost {}ms", (Object)(System.currentTimeMillis() - startTime));
        }
    }

    protected void handleRefreshAuthCache() throws SaturnJobConsoleException {
        if (!this.isAuthorizationEnabled()) {
            this.rolesCache.clear();
            return;
        }
        List<Role> roles = this.roleRepository.selectAll();
        if (roles == null || roles.isEmpty()) {
            this.rolesCache.clear();
            return;
        }
        ConcurrentHashMap<String, Role> rolesMap = new ConcurrentHashMap<String, Role>();
        for (Role role : roles) {
            String roleKey = role.getRoleKey();
            if (StringUtils.isBlank((CharSequence)roleKey)) continue;
            List<RolePermission> rolePermissions = this.rolePermissionRepository.selectByRoleKey(roleKey);
            if (rolePermissions != null) {
                role.setRolePermissions(rolePermissions);
                for (RolePermission rolePermission : rolePermissions) {
                    Permission permission = this.permissionRepository.selectByKey(rolePermission.getPermissionKey());
                    rolePermission.setPermission(permission);
                }
            }
            rolesMap.put(roleKey, role);
        }
        this.rolesCache = rolesMap;
    }

    @Override
    public boolean isAuthorizationEnabled() throws SaturnJobConsoleException {
        return this.systemConfigService.getBooleanValue("AUTHORIZATION_ENABLED", this.authorizationEnabledDefault);
    }

    @Override
    @Transactional(readOnly=true)
    public User getUser(String userName) throws SaturnJobConsoleException {
        User user = null;
        if (!this.isAuthorizationEnabled()) {
            return this.constructAvailableUser(user, userName);
        }
        user = this.constructAvailableUser(this.userRepository.select(userName), userName);
        List<UserRole> userRoles = this.userRoleRepository.selectByUserName(userName);
        if (userRoles != null) {
            user.setUserRoles(userRoles);
            for (UserRole userRole : userRoles) {
                String roleKey = userRole.getRoleKey();
                Role role = (Role)this.rolesCache.get(roleKey);
                userRole.setRole(role);
            }
        }
        return user;
    }

    protected User constructAvailableUser(User user, String userName) {
        if (user == null) {
            user = new User();
        }
        user.setUserName(userName);
        if (user.getUserRoles() == null) {
            user.setUserRoles(new ArrayList<UserRole>());
        }
        return user;
    }

    @Override
    @Transactional(readOnly=true)
    public boolean hasUserRole(UserRole userRole) throws SaturnJobConsoleException {
        if (!this.isAuthorizationEnabled()) {
            return true;
        }
        List<UserRole> result = this.userRoleRepository.select(userRole);
        return result != null && !result.isEmpty();
    }

    @Override
    public void assertIsPermitted(String permissionKey, String userName, String namespace) throws SaturnJobConsoleException {
        if (!this.isAuthorizationEnabled()) {
            return;
        }
        User user = this.getUser(userName);
        List<UserRole> userRoles = user.getUserRoles();
        if (userRoles != null) {
            for (UserRole userRole : userRoles) {
                List<RolePermission> rolePermissions;
                Role role = userRole.getRole();
                if (role == null || role.getIsRelatingToNamespace().booleanValue() && !namespace.equals(userRole.getNamespace()) || (rolePermissions = role.getRolePermissions()) == null || rolePermissions.isEmpty()) continue;
                for (RolePermission rolePermission : rolePermissions) {
                    if (!permissionKey.equals(rolePermission.getPermissionKey())) continue;
                    return;
                }
            }
        }
        throw new SaturnJobConsoleException(String.format("\u60a8\u6ca1\u6709\u64cd\u4f5c\u6240\u9700\u8981\u7684\u6743\u9650\uff1a\u57df:%s\uff0c\u6743\u9650:%s", namespace, permissionKey));
    }

    @Override
    public void assertIsSystemAdmin(String userName) throws SaturnJobConsoleException {
        if (!this.isAuthorizationEnabled()) {
            return;
        }
        User user = this.getUser(userName);
        List<UserRole> userRoles = user.getUserRoles();
        if (userRoles != null) {
            for (UserRole userRole : userRoles) {
                if (!this.systemAdminRoleKey.equals(userRole.getRoleKey())) continue;
                return;
            }
        }
        throw new SaturnJobConsoleException("\u60a8\u4e0d\u662f\u7cfb\u7edf\u7ba1\u7406\u5458\uff0c\u6ca1\u6709\u6743\u9650");
    }
}

