/*
 * Decompiled with CFR 0.152.
 */
package com.vip.saturn.job.console.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.vip.saturn.job.console.domain.DomainStatistics;
import com.vip.saturn.job.console.domain.ExecutorStatistics;
import com.vip.saturn.job.console.domain.JobStatistics;
import com.vip.saturn.job.console.domain.RegistryCenterConfiguration;
import com.vip.saturn.job.console.domain.ZkCluster;
import com.vip.saturn.job.console.domain.ZkStatistics;
import com.vip.saturn.job.console.exception.SaturnJobConsoleException;
import com.vip.saturn.job.console.mybatis.entity.SaturnStatistics;
import com.vip.saturn.job.console.mybatis.service.SaturnStatisticsService;
import com.vip.saturn.job.console.repository.zookeeper.CuratorRepository;
import com.vip.saturn.job.console.service.DashboardService;
import com.vip.saturn.job.console.service.JobService;
import com.vip.saturn.job.console.service.RegistryCenterService;
import com.vip.saturn.job.console.service.StatisticsRefreshService;
import com.vip.saturn.job.console.service.helper.DashboardServiceHelper;
import com.vip.saturn.job.console.utils.JobNodePath;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class DashboardServiceImpl
implements DashboardService {
    private static final Logger log = LoggerFactory.getLogger(DashboardServiceImpl.class);
    @Autowired
    private SaturnStatisticsService saturnStatisticsService;
    @Autowired
    private RegistryCenterService registryCenterService;
    @Autowired
    private JobService jobService;
    @Autowired
    private StatisticsRefreshService statisticsRefreshService;
    private ExecutorService updateStatisticsThreadPool;

    @PostConstruct
    public void init() {
        this.initUpdateStatisticsThreadPool();
    }

    @PreDestroy
    public void destroy() {
        if (this.updateStatisticsThreadPool != null) {
            this.updateStatisticsThreadPool.shutdownNow();
        }
    }

    private void initUpdateStatisticsThreadPool() {
        this.updateStatisticsThreadPool = Executors.newSingleThreadExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                String name = "single-update-statistics";
                Thread t = new Thread(r, name);
                if (t.isDaemon()) {
                    t.setDaemon(false);
                }
                if (t.getPriority() != 5) {
                    t.setPriority(5);
                }
                return t;
            }
        });
    }

    @Override
    public int executorInDockerCount(String zkList) throws SaturnJobConsoleException {
        return this.getCountFromDB("executor_in_docker_count", zkList);
    }

    @Override
    public int executorNotInDockerCount(String zkList) throws SaturnJobConsoleException {
        return this.getCountFromDB("executor_not_in_docker_count", zkList);
    }

    @Override
    public int jobCount(String zkList) throws SaturnJobConsoleException {
        return this.getCountFromDB("job_count", zkList);
    }

    private int getCountFromDB(String name, String zkList) {
        SaturnStatistics ss = this.saturnStatisticsService.findStatisticsByNameAndZkList(name, zkList);
        if (ss == null || StringUtils.isBlank((CharSequence)ss.getResult())) {
            return 0;
        }
        String result = ss.getResult();
        try {
            Integer count = (Integer)JSON.parseObject((String)result, (TypeReference)new TypeReference<Integer>(){}, (Feature[])new Feature[0]);
            return count == null ? 0 : count;
        }
        catch (Exception e) {
            log.error("exception throws during get count from DB. name:" + name, (Throwable)e);
            return 0;
        }
    }

    @Override
    public SaturnStatistics top10FailureJob(String zklist) throws SaturnJobConsoleException {
        return this.saturnStatisticsService.findStatisticsByNameAndZkList("top_10_fail_job", zklist);
    }

    @Override
    public String top10FailureJobByAllZkCluster() throws SaturnJobConsoleException {
        List<JobStatistics> jobStatisticsList = new ArrayList<JobStatistics>();
        List<ZkCluster> zkClusterList = this.registryCenterService.getOnlineZkClusterList();
        for (ZkCluster zkCluster : zkClusterList) {
            String result;
            List tempList;
            SaturnStatistics saturnStatistics = this.top10FailureJob(zkCluster.getZkAddr());
            if (saturnStatistics == null || (tempList = JSON.parseArray((String)(result = saturnStatistics.getResult()), JobStatistics.class)) == null) continue;
            jobStatisticsList.addAll(tempList);
        }
        List<JobStatistics> top10FailJob = jobStatisticsList.subList(0, (jobStatisticsList = DashboardServiceHelper.sortJobByAllTimeFailureRate(jobStatisticsList)).size() > 9 ? 10 : jobStatisticsList.size());
        return JSON.toJSONString(top10FailJob);
    }

    @Override
    public SaturnStatistics top10FailureExecutor(String zklist) throws SaturnJobConsoleException {
        return this.saturnStatisticsService.findStatisticsByNameAndZkList("top_10_fail_executor", zklist);
    }

    @Override
    public String top10FailureExecutorByAllZkCluster() throws SaturnJobConsoleException {
        List<ExecutorStatistics> executorStatisticsList = new ArrayList<ExecutorStatistics>();
        List<ZkCluster> zkClusterList = this.registryCenterService.getOnlineZkClusterList();
        for (ZkCluster zkCluster : zkClusterList) {
            String result;
            List tempList;
            SaturnStatistics saturnStatistics = this.top10FailureExecutor(zkCluster.getZkAddr());
            if (saturnStatistics == null || (tempList = JSON.parseArray((String)(result = saturnStatistics.getResult()), ExecutorStatistics.class)) == null) continue;
            executorStatisticsList.addAll(tempList);
        }
        List<ExecutorStatistics> top10FailureExecutor = executorStatisticsList.subList(0, (executorStatisticsList = DashboardServiceHelper.sortExecutorByFailureRate(executorStatisticsList)).size() > 9 ? 10 : executorStatisticsList.size());
        return JSON.toJSONString(top10FailureExecutor);
    }

    @Override
    public SaturnStatistics top10AactiveJob(String zklist) throws SaturnJobConsoleException {
        return this.saturnStatisticsService.findStatisticsByNameAndZkList("top_10_active_job", zklist);
    }

    @Override
    public String top10AactiveJobByAllZkCluster() throws SaturnJobConsoleException {
        List<JobStatistics> jobStatisticsList = new ArrayList<JobStatistics>();
        List<ZkCluster> zkClusterList = this.registryCenterService.getOnlineZkClusterList();
        for (ZkCluster zkCluster : zkClusterList) {
            String result;
            List tempList;
            SaturnStatistics saturnStatistics = this.top10AactiveJob(zkCluster.getZkAddr());
            if (saturnStatistics == null || (tempList = JSON.parseArray((String)(result = saturnStatistics.getResult()), JobStatistics.class)) == null) continue;
            jobStatisticsList.addAll(tempList);
        }
        List<JobStatistics> top10AactiveJob = jobStatisticsList.subList(0, (jobStatisticsList = DashboardServiceHelper.sortJobByDayProcessCount(jobStatisticsList)).size() > 9 ? 10 : jobStatisticsList.size());
        return JSON.toJSONString(top10AactiveJob);
    }

    @Override
    public SaturnStatistics top10LoadExecutor(String zklist) throws SaturnJobConsoleException {
        return this.saturnStatisticsService.findStatisticsByNameAndZkList("top_10_load_executor", zklist);
    }

    @Override
    public String top10LoadExecutorByAllZkCluster() throws SaturnJobConsoleException {
        List<ExecutorStatistics> executorStatisticsList = new ArrayList<ExecutorStatistics>();
        List<ZkCluster> zkClusterList = this.registryCenterService.getOnlineZkClusterList();
        for (ZkCluster zkCluster : zkClusterList) {
            String result;
            List tempList;
            SaturnStatistics saturnStatistics = this.top10LoadExecutor(zkCluster.getZkAddr());
            if (saturnStatistics == null || (tempList = JSON.parseArray((String)(result = saturnStatistics.getResult()), ExecutorStatistics.class)) == null) continue;
            executorStatisticsList.addAll(tempList);
        }
        List<ExecutorStatistics> top10LoadExecutor = executorStatisticsList.subList(0, (executorStatisticsList = DashboardServiceHelper.sortExecutorByLoadLevel(executorStatisticsList)).size() > 9 ? 10 : executorStatisticsList.size());
        return JSON.toJSONString(top10LoadExecutor);
    }

    @Override
    public SaturnStatistics top10LoadJob(String zklist) throws SaturnJobConsoleException {
        return this.saturnStatisticsService.findStatisticsByNameAndZkList("top_10_load_job", zklist);
    }

    @Override
    public String top10LoadJobByAllZkCluster() throws SaturnJobConsoleException {
        List<JobStatistics> jobStatisticsList = new ArrayList<JobStatistics>();
        List<ZkCluster> zkClusterList = this.registryCenterService.getOnlineZkClusterList();
        for (ZkCluster zkCluster : zkClusterList) {
            String result;
            List tempList;
            SaturnStatistics saturnStatistics = this.top10LoadJob(zkCluster.getZkAddr());
            if (saturnStatistics == null || (tempList = JSON.parseArray((String)(result = saturnStatistics.getResult()), JobStatistics.class)) == null) continue;
            jobStatisticsList.addAll(tempList);
        }
        List<JobStatistics> top10LoadJob = jobStatisticsList.subList(0, (jobStatisticsList = DashboardServiceHelper.sortJobByLoadLevel(jobStatisticsList)).size() > 9 ? 10 : jobStatisticsList.size());
        return JSON.toJSONString(top10LoadJob);
    }

    @Override
    public SaturnStatistics top10UnstableDomain(String zklist) throws SaturnJobConsoleException {
        return this.saturnStatisticsService.findStatisticsByNameAndZkList("top_10_unstable_domain", zklist);
    }

    @Override
    public String top10UnstableDomainByAllZkCluster() throws SaturnJobConsoleException {
        List<DomainStatistics> domainStatisticsList = new ArrayList<DomainStatistics>();
        List<ZkCluster> zkClusterList = this.registryCenterService.getOnlineZkClusterList();
        for (ZkCluster zkCluster : zkClusterList) {
            String result;
            List tempList;
            SaturnStatistics saturnStatistics = this.top10UnstableDomain(zkCluster.getZkAddr());
            if (saturnStatistics == null || (tempList = JSON.parseArray((String)(result = saturnStatistics.getResult()), DomainStatistics.class)) == null) continue;
            domainStatisticsList.addAll(tempList);
        }
        List<DomainStatistics> top10UnstableDomain = domainStatisticsList.subList(0, (domainStatisticsList = DashboardServiceHelper.sortDomainByShardingCount(domainStatisticsList)).size() > 9 ? 10 : domainStatisticsList.size());
        return JSON.toJSONString(top10UnstableDomain);
    }

    @Override
    public SaturnStatistics allProcessAndErrorCountOfTheDay(String zklist) throws SaturnJobConsoleException {
        return this.saturnStatisticsService.findStatisticsByNameAndZkList("domain_process_count_of_the_day", zklist);
    }

    @Override
    public String allProcessAndErrorCountOfTheDayByAllZkCluster() throws SaturnJobConsoleException {
        int count = 0;
        int error = 0;
        List<ZkCluster> zkClusterList = this.registryCenterService.getOnlineZkClusterList();
        for (ZkCluster zkCluster : zkClusterList) {
            String result;
            ZkStatistics temp;
            SaturnStatistics saturnStatistics = this.allProcessAndErrorCountOfTheDay(zkCluster.getZkAddr());
            if (saturnStatistics == null || (temp = (ZkStatistics)JSON.parseObject((String)(result = saturnStatistics.getResult()), ZkStatistics.class)) == null) continue;
            count += temp.getCount();
            error += temp.getError();
        }
        return JSON.toJSONString((Object)new ZkStatistics(count, error));
    }

    @Override
    public SaturnStatistics top10FailureDomain(String zklist) throws SaturnJobConsoleException {
        return this.saturnStatisticsService.findStatisticsByNameAndZkList("top_10_fail_domain", zklist);
    }

    @Override
    public String top10FailureDomainByAllZkCluster() throws SaturnJobConsoleException {
        List<DomainStatistics> domainStatisticsList = new ArrayList<DomainStatistics>();
        List<ZkCluster> zkClusterList = this.registryCenterService.getOnlineZkClusterList();
        for (ZkCluster zkCluster : zkClusterList) {
            String result;
            List tempList;
            SaturnStatistics saturnStatistics = this.top10FailureDomain(zkCluster.getZkAddr());
            if (saturnStatistics == null || (tempList = JSON.parseArray((String)(result = saturnStatistics.getResult()), DomainStatistics.class)) == null) continue;
            domainStatisticsList.addAll(tempList);
        }
        List<DomainStatistics> top10FailureDomain = domainStatisticsList.subList(0, (domainStatisticsList = DashboardServiceHelper.sortDomainByAllTimeFailureRate(domainStatisticsList)).size() > 9 ? 10 : domainStatisticsList.size());
        return JSON.toJSONString(top10FailureDomain);
    }

    @Override
    public void cleanShardingCount(String namespace) throws SaturnJobConsoleException {
        CuratorRepository.CuratorFrameworkOp curatorFrameworkOp = this.registryCenterService.getCuratorFrameworkOp(namespace);
        curatorFrameworkOp.update("/$SaturnExecutors/sharding/count", "0");
        this.asyncForceRefreshStatistics(namespace);
    }

    @Override
    public void cleanOneJobAnalyse(String namespace, String jobName) throws SaturnJobConsoleException {
        CuratorRepository.CuratorFrameworkOp curatorFrameworkOp = this.registryCenterService.getCuratorFrameworkOp(namespace);
        this.updateResetValue(curatorFrameworkOp, jobName, "a");
        this.resetOneJobAnalyse(jobName, curatorFrameworkOp);
        this.asyncForceRefreshStatistics(namespace);
    }

    @Override
    public void cleanAllJobAnalyse(String namespace) throws SaturnJobConsoleException {
        CuratorRepository.CuratorFrameworkOp curatorFrameworkOp = this.registryCenterService.getCuratorFrameworkOp(namespace);
        List<String> jobs = this.jobService.getUnSystemJobNames(namespace);
        for (String job : jobs) {
            this.resetOneJobAnalyse(job, curatorFrameworkOp);
            this.updateResetValue(curatorFrameworkOp, job, "a");
        }
        this.asyncForceRefreshStatistics(namespace);
    }

    @Override
    public void cleanAllJobExecutorCount(String namespace) throws SaturnJobConsoleException {
        CuratorRepository.CuratorFrameworkOp curatorFrameworkOp = this.registryCenterService.getCuratorFrameworkOp(namespace);
        List<String> jobs = this.jobService.getUnSystemJobNames(namespace);
        for (String job : jobs) {
            this.resetOneJobExecutorCount(job, curatorFrameworkOp);
            this.updateResetValue(curatorFrameworkOp, job, "s");
        }
        this.asyncForceRefreshStatistics(namespace);
    }

    @Override
    public void cleanOneJobExecutorCount(String namespace, String jobName) throws SaturnJobConsoleException {
        CuratorRepository.CuratorFrameworkOp curatorFrameworkOp = this.registryCenterService.getCuratorFrameworkOp(namespace);
        this.updateResetValue(curatorFrameworkOp, jobName, "s");
        this.resetOneJobExecutorCount(jobName, curatorFrameworkOp);
        this.asyncForceRefreshStatistics(namespace);
    }

    private void resetOneJobExecutorCount(String jobName, CuratorRepository.CuratorFrameworkOp curatorFrameworkOp) {
        if (curatorFrameworkOp.checkExists(JobNodePath.getServerNodePath(jobName))) {
            List<String> servers = curatorFrameworkOp.getChildren(JobNodePath.getServerNodePath(jobName));
            for (String server : servers) {
                curatorFrameworkOp.update(JobNodePath.getProcessSucessCount(jobName, server), "0");
                curatorFrameworkOp.update(JobNodePath.getProcessFailureCount(jobName, server), "0");
            }
        }
    }

    private void resetOneJobAnalyse(String jobName, CuratorRepository.CuratorFrameworkOp curatorFrameworkOp) {
        curatorFrameworkOp.update(JobNodePath.getProcessCountPath(jobName), "0");
        curatorFrameworkOp.update(JobNodePath.getErrorCountPath(jobName), "0");
    }

    private void updateResetValue(CuratorRepository.CuratorFrameworkOp curatorFrameworkOp, String job, String value) {
        String path = JobNodePath.getAnalyseResetPath(job);
        curatorFrameworkOp.update(path, value.getBytes());
    }

    private void asyncForceRefreshStatistics(final String namespace) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    RegistryCenterConfiguration conf = DashboardServiceImpl.this.registryCenterService.findConfigByNamespace(namespace);
                    if (conf != null) {
                        DashboardServiceImpl.this.statisticsRefreshService.refresh(conf.getZkClusterKey(), false);
                    }
                }
                catch (Throwable t) {
                    log.error("async refresh statistics error", t);
                }
            }
        };
        this.updateStatisticsThreadPool.submit(runnable);
    }

    @Override
    public Map<String, Integer> loadDomainRankDistribution(String zkClusterKey) throws SaturnJobConsoleException {
        ZkCluster zkCluster;
        HashMap<String, Integer> domainMap = new HashMap<String, Integer>();
        if (zkClusterKey != null && (zkCluster = this.registryCenterService.getZkCluster(zkClusterKey)) != null && !zkCluster.isOffline()) {
            for (RegistryCenterConfiguration config : zkCluster.getRegCenterConfList()) {
                Integer count = (Integer)domainMap.get(config.getDegree());
                if (null == config.getDegree()) continue;
                domainMap.put(config.getDegree(), count == null ? 1 : count + 1);
            }
        }
        return domainMap;
    }

    @Override
    public Map<String, Integer> loadDomainRankDistributionByAllZkCluster() throws SaturnJobConsoleException {
        HashMap<String, Integer> domainMap = new HashMap<String, Integer>();
        List<ZkCluster> zkClusterList = this.registryCenterService.getOnlineZkClusterList();
        for (ZkCluster zkCluster : zkClusterList) {
            ArrayList<RegistryCenterConfiguration> regCenterConfList = zkCluster.getRegCenterConfList();
            if (regCenterConfList == null) continue;
            for (RegistryCenterConfiguration config : regCenterConfList) {
                String degree = config.getDegree();
                if (degree == null) continue;
                Integer count = (Integer)domainMap.get(degree);
                domainMap.put(degree, count == null ? 1 : count + 1);
            }
        }
        return domainMap;
    }

    @Override
    public Map<Integer, Integer> loadJobRankDistribution(String zklist) throws SaturnJobConsoleException {
        SaturnStatistics ss = this.saturnStatisticsService.findStatisticsByNameAndZkList("job_rank_distribution", zklist);
        if (ss != null) {
            String result = ss.getResult();
            return (Map)JSON.parseObject((String)result, (TypeReference)new TypeReference<Map<Integer, Integer>>(){}, (Feature[])new Feature[0]);
        }
        return new HashMap<Integer, Integer>();
    }

    @Override
    public Map<Integer, Integer> loadJobRankDistributionByAllZkCluster() throws SaturnJobConsoleException {
        HashMap<Integer, Integer> jobDegreeCountMap = new HashMap<Integer, Integer>();
        List<ZkCluster> zkClusterList = this.registryCenterService.getOnlineZkClusterList();
        for (ZkCluster zkCluster : zkClusterList) {
            String zkAddr = zkCluster.getZkAddr();
            Map<Integer, Integer> temp = this.loadJobRankDistribution(zkAddr);
            if (temp == null) continue;
            for (Map.Entry<Integer, Integer> next : temp.entrySet()) {
                Integer jobDegree = next.getKey();
                Integer count = next.getValue();
                if (jobDegree == null || count == null) continue;
                if (jobDegreeCountMap.containsKey(jobDegree)) {
                    jobDegreeCountMap.put(jobDegree, (Integer)jobDegreeCountMap.get(jobDegree) + count);
                    continue;
                }
                jobDegreeCountMap.put(jobDegree, count);
            }
        }
        return jobDegreeCountMap;
    }

    @Override
    public Map<String, Long> versionDomainNumber(String currentZkAddr) throws SaturnJobConsoleException {
        SaturnStatistics ss = this.saturnStatisticsService.findStatisticsByNameAndZkList("version_domain_number", currentZkAddr);
        if (ss != null) {
            String result = ss.getResult();
            return (Map)JSON.parseObject((String)result, (TypeReference)new TypeReference<Map<String, Long>>(){}, (Feature[])new Feature[0]);
        }
        return new HashMap<String, Long>();
    }

    @Override
    public Map<String, Long> versionDomainNumberByAllZkCluster() throws SaturnJobConsoleException {
        HashMap<String, Long> versionDomainNumberMap = new HashMap<String, Long>();
        List<ZkCluster> zkClusterList = this.registryCenterService.getOnlineZkClusterList();
        for (ZkCluster zkCluster : zkClusterList) {
            String zkAddr = zkCluster.getZkAddr();
            Map<String, Long> temp = this.versionDomainNumber(zkAddr);
            if (temp == null) continue;
            for (Map.Entry<String, Long> next : temp.entrySet()) {
                String version = next.getKey();
                Long domainNumber = next.getValue();
                if (version == null || domainNumber == null) continue;
                if (versionDomainNumberMap.containsKey(version)) {
                    versionDomainNumberMap.put(version, (Long)versionDomainNumberMap.get(version) + domainNumber);
                    continue;
                }
                versionDomainNumberMap.put(version, domainNumber);
            }
        }
        return versionDomainNumberMap;
    }

    @Override
    public Map<String, Long> versionExecutorNumber(String currentZkAddr) throws SaturnJobConsoleException {
        SaturnStatistics ss = this.saturnStatisticsService.findStatisticsByNameAndZkList("version_executor_number", currentZkAddr);
        if (ss != null) {
            String result = ss.getResult();
            return (Map)JSON.parseObject((String)result, (TypeReference)new TypeReference<Map<String, Long>>(){}, (Feature[])new Feature[0]);
        }
        return new HashMap<String, Long>();
    }

    @Override
    public Map<String, Long> versionExecutorNumberByAllZkCluster() throws SaturnJobConsoleException {
        HashMap<String, Long> versionExecutorNumberMap = new HashMap<String, Long>();
        List<ZkCluster> zkClusterList = this.registryCenterService.getOnlineZkClusterList();
        for (ZkCluster zkCluster : zkClusterList) {
            String zkAddr = zkCluster.getZkAddr();
            Map<String, Long> temp = this.versionExecutorNumber(zkAddr);
            if (temp == null) continue;
            for (Map.Entry<String, Long> next : temp.entrySet()) {
                String version = next.getKey();
                Long executorNumber = next.getValue();
                if (version == null || executorNumber == null) continue;
                if (versionExecutorNumberMap.containsKey(version)) {
                    versionExecutorNumberMap.put(version, (Long)versionExecutorNumberMap.get(version) + executorNumber);
                    continue;
                }
                versionExecutorNumberMap.put(version, executorNumber);
            }
        }
        return versionExecutorNumberMap;
    }
}

