/*
 * Decompiled with CFR 0.152.
 */
package com.vip.saturn.job.console.service.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.vip.saturn.job.console.domain.JobConfig;
import com.vip.saturn.job.console.domain.JobStatus;
import com.vip.saturn.job.console.domain.JobType;
import com.vip.saturn.job.console.domain.ServerAllocationInfo;
import com.vip.saturn.job.console.domain.ServerBriefInfo;
import com.vip.saturn.job.console.domain.ServerRunningInfo;
import com.vip.saturn.job.console.domain.ServerStatus;
import com.vip.saturn.job.console.exception.SaturnJobConsoleException;
import com.vip.saturn.job.console.repository.zookeeper.CuratorRepository;
import com.vip.saturn.job.console.service.ExecutorService;
import com.vip.saturn.job.console.service.JobService;
import com.vip.saturn.job.console.service.RegistryCenterService;
import com.vip.saturn.job.console.service.SystemConfigService;
import com.vip.saturn.job.console.utils.ExecutorNodePath;
import com.vip.saturn.job.console.utils.JobNodePath;
import com.vip.saturn.job.console.utils.SaturnConsoleUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

public class ExecutorServiceImpl
implements ExecutorService {
    private static final int DEFAULT_MAX_SECONDS_FORCE_KILL_EXECUTOR = 300;
    private static final int SMALLEST_VERSION_SUPPORTED_DUMP = 3;
    private static final Set<String> SUPPORT_DUMP_VERSION_WHITE_LIST = Sets.newHashSet((Object[])new String[]{"saturn-dev", "master-SNAPSHOT"});
    @Resource
    private CuratorRepository curatorRepository;
    @Resource
    private JobService jobService;
    @Resource
    private RegistryCenterService registryCenterService;
    @Resource
    private SystemConfigService systemConfigService;

    @Override
    public List<ServerBriefInfo> getExecutors(String namespace) throws SaturnJobConsoleException {
        return this.getExecutors(namespace, null);
    }

    @Override
    public List<ServerBriefInfo> getExecutors(String namespace, ServerStatus expectedServerStatus) throws SaturnJobConsoleException {
        CuratorRepository.CuratorFrameworkOp curatorFrameworkOp = this.getCuratorFrameworkOp(namespace);
        List<String> executors = curatorFrameworkOp.getChildren(ExecutorNodePath.getExecutorNodePath());
        if (executors == null || executors.isEmpty()) {
            return Lists.newArrayList();
        }
        ArrayList executorInfoList = Lists.newArrayList();
        for (String executor : executors) {
            ServerBriefInfo executorInfo = this.getServerBriefInfo(executor, curatorFrameworkOp);
            if (expectedServerStatus != null && executorInfo.getStatus() != expectedServerStatus) continue;
            executorInfoList.add(executorInfo);
        }
        return executorInfoList;
    }

    @Override
    public ServerBriefInfo getExecutor(String namespace, String executorName) throws SaturnJobConsoleException {
        CuratorRepository.CuratorFrameworkOp curatorFrameworkOp = this.getCuratorFrameworkOp(namespace);
        if (!curatorFrameworkOp.checkExists(ExecutorNodePath.getExecutorNodePath(executorName))) {
            return null;
        }
        return this.getServerBriefInfo(executorName, curatorFrameworkOp);
    }

    private ServerBriefInfo getServerBriefInfo(String executorName, CuratorRepository.CuratorFrameworkOp curatorFrameworkOp) {
        ServerBriefInfo executorInfo = new ServerBriefInfo(executorName);
        String ip = curatorFrameworkOp.getData(ExecutorNodePath.getExecutorIpNodePath(executorName));
        executorInfo.setServerIp(ip);
        if (StringUtils.isNotBlank((CharSequence)ip)) {
            executorInfo.setStatus(ServerStatus.ONLINE);
        } else {
            executorInfo.setStatus(ServerStatus.OFFLINE);
        }
        String restartNodePath = ExecutorNodePath.getExecutorRestartNodePath(executorName);
        long restartTriggerTime = curatorFrameworkOp.getCtime(restartNodePath);
        long now = System.currentTimeMillis();
        long maxRestartInv = (long)this.systemConfigService.getIntegerValue("MAX_SECONDS_FORCE_KILL_EXECUTOR", 300).intValue() * 1000L;
        if (0L != restartTriggerTime && now - restartTriggerTime < maxRestartInv) {
            executorInfo.setRestarting(true);
        } else {
            executorInfo.setRestarting(false);
        }
        executorInfo.setNoTraffic(curatorFrameworkOp.checkExists(ExecutorNodePath.getExecutorNoTrafficNodePath(executorName)));
        String lastBeginTime = curatorFrameworkOp.getData(ExecutorNodePath.getExecutorNodePath(executorInfo.getExecutorName(), "lastBeginTime"));
        executorInfo.setLastBeginTime(SaturnConsoleUtils.parseMillisecond2DisplayTime(lastBeginTime));
        executorInfo.setVersion(curatorFrameworkOp.getData(ExecutorNodePath.getExecutorVersionNodePath(executorName)));
        String task = curatorFrameworkOp.getData(ExecutorNodePath.getExecutorTaskNodePath(executorName));
        if (StringUtils.isNotBlank((CharSequence)task)) {
            executorInfo.setGroupName(task);
            executorInfo.setContainer(true);
        }
        return executorInfo;
    }

    @Override
    public ServerAllocationInfo getExecutorAllocation(String namespace, String executorName) throws SaturnJobConsoleException {
        CuratorRepository.CuratorFrameworkOp curatorFrameworkOp = this.getCuratorFrameworkOp(namespace);
        List<JobConfig> unSystemJobs = this.jobService.getUnSystemJobs(namespace);
        ServerAllocationInfo serverAllocationInfo = new ServerAllocationInfo(executorName);
        for (JobConfig jobConfig : unSystemJobs) {
            String sharding;
            String jobName = jobConfig.getJobName();
            String serverNodePath = JobNodePath.getServerNodePath(jobName);
            if (!curatorFrameworkOp.checkExists(serverNodePath) || !StringUtils.isNotBlank((CharSequence)(sharding = curatorFrameworkOp.getData(JobNodePath.getServerNodePath(jobName, executorName, "sharding")))) || JobStatus.STOPPED.equals((Object)this.jobService.getJobStatus(namespace, jobName))) continue;
            serverAllocationInfo.getAllocationMap().put(jobName, sharding);
            String loadLevelNode = curatorFrameworkOp.getData(JobNodePath.getConfigNodePath(jobName, "loadLevel"));
            Integer loadLevel = 1;
            if (StringUtils.isNotBlank((CharSequence)loadLevelNode)) {
                loadLevel = Integer.valueOf(loadLevelNode);
            }
            int shardingItemNum = sharding.split(",").length;
            int curJobLoad = shardingItemNum * loadLevel;
            int totalLoad = serverAllocationInfo.getTotalLoadLevel();
            serverAllocationInfo.setTotalLoadLevel(totalLoad + curJobLoad);
        }
        return serverAllocationInfo;
    }

    @Override
    public ServerRunningInfo getExecutorRunningInfo(String namespace, String executorName) throws SaturnJobConsoleException {
        CuratorRepository.CuratorFrameworkOp curatorFrameworkOp = this.getCuratorFrameworkOp(namespace);
        List<JobConfig> unSystemJobs = this.jobService.getUnSystemJobs(namespace);
        ServerRunningInfo serverRunningInfo = new ServerRunningInfo(executorName);
        for (JobConfig jobConfig : unSystemJobs) {
            boolean needToCheckFailover = this.needToCheckFailover(jobConfig);
            String jobName = jobConfig.getJobName();
            String serverNodePath = JobNodePath.getServerNodePath(jobName);
            if (!curatorFrameworkOp.checkExists(serverNodePath)) continue;
            String sharding = curatorFrameworkOp.getData(JobNodePath.getServerNodePath(jobName, executorName, "sharding"));
            Set<String> shardingItems = this.getShardingItems(sharding);
            if (needToCheckFailover) {
                this.obtainServerRunningInfoWhileNeedToCheckFailover(executorName, curatorFrameworkOp, jobName, shardingItems, serverRunningInfo);
                continue;
            }
            if (shardingItems.isEmpty()) continue;
            this.obtainServerRunningInfoWhileNoNeedToCheckFailover(curatorFrameworkOp, jobConfig, shardingItems, serverRunningInfo);
        }
        return serverRunningInfo;
    }

    private void obtainServerRunningInfoWhileNoNeedToCheckFailover(CuratorRepository.CuratorFrameworkOp curatorFrameworkOp, JobConfig jobConfig, Set<String> shardingItems, ServerRunningInfo serverRunningInfo) {
        String jobName = jobConfig.getJobName();
        if (!jobConfig.getEnabledReport().booleanValue()) {
            serverRunningInfo.getPotentialRunningJobItems().put(jobName, StringUtils.join(shardingItems, (char)','));
        }
        ArrayList runningItems = Lists.newArrayList();
        for (String item : shardingItems) {
            if (!curatorFrameworkOp.checkExists(JobNodePath.getExecutionNodePath(jobConfig.getJobName(), item, "running"))) continue;
            runningItems.add(item);
        }
        if (!runningItems.isEmpty()) {
            serverRunningInfo.getRunningJobItems().put(jobConfig.getJobName(), StringUtils.join((Iterable)runningItems, (char)','));
        }
    }

    private void obtainServerRunningInfoWhileNeedToCheckFailover(String executorName, CuratorRepository.CuratorFrameworkOp curatorFrameworkOp, String jobName, Set<String> shardingItems, ServerRunningInfo serverRunningInfo) {
        List<String> executionItems = curatorFrameworkOp.getChildren(JobNodePath.getExecutionNodePath(jobName));
        if (CollectionUtils.isEmpty(executionItems)) {
            return;
        }
        ArrayList runningItems = Lists.newArrayList();
        for (String item : executionItems) {
            boolean isItemRunning = curatorFrameworkOp.checkExists(JobNodePath.getExecutionNodePath(jobName, item, "running"));
            if (!isItemRunning) continue;
            if (shardingItems != null && shardingItems.contains(item)) {
                runningItems.add(item);
                continue;
            }
            String failoverValue = curatorFrameworkOp.getData(JobNodePath.getExecutionNodePath(jobName, item, "failover"));
            if (!StringUtils.isNotBlank((CharSequence)failoverValue) || !failoverValue.equals(executorName)) continue;
            runningItems.add(item);
        }
        if (!runningItems.isEmpty()) {
            serverRunningInfo.getRunningJobItems().put(jobName, StringUtils.join((Iterable)runningItems, (char)','));
        }
    }

    private Set<String> getShardingItems(String sharding) {
        if (StringUtils.isBlank((CharSequence)sharding)) {
            return Sets.newHashSet();
        }
        String[] items = sharding.split(",");
        TreeSet result = Sets.newTreeSet();
        for (String item : items) {
            if (StringUtils.isBlank((CharSequence)item)) continue;
            result.add(item.trim());
        }
        return result;
    }

    private boolean needToCheckFailover(JobConfig jobConfig) {
        if (!jobConfig.getFailover().booleanValue()) {
            return false;
        }
        if (JobType.MSG_JOB.name().equals(jobConfig.getJobType())) {
            return false;
        }
        if (jobConfig.getLocalMode().booleanValue()) {
            return false;
        }
        return jobConfig.getEnabledReport() != false;
    }

    @Override
    public void extractTraffic(String namespace, String executorName) throws SaturnJobConsoleException {
        CuratorRepository.CuratorFrameworkOp curatorFrameworkOp = this.getCuratorFrameworkOp(namespace);
        this.validateIfExecutorNameExisted(executorName, curatorFrameworkOp);
        curatorFrameworkOp.create(ExecutorNodePath.getExecutorNoTrafficNodePath(executorName));
    }

    @Override
    public void recoverTraffic(String namespace, String executorName) throws SaturnJobConsoleException {
        CuratorRepository.CuratorFrameworkOp curatorFrameworkOp = this.getCuratorFrameworkOp(namespace);
        this.validateIfExecutorNameExisted(executorName, curatorFrameworkOp);
        curatorFrameworkOp.deleteRecursive(ExecutorNodePath.getExecutorNoTrafficNodePath(executorName));
    }

    @Override
    public void removeExecutor(String namespace, String executorName) throws SaturnJobConsoleException {
        CuratorRepository.CuratorFrameworkOp curatorFrameworkOp = this.getCuratorFrameworkOp(namespace);
        curatorFrameworkOp.deleteRecursive(ExecutorNodePath.getExecutorNodePath(executorName));
        List<String> jobNames = this.jobService.getAllJobNamesFromZK(namespace);
        if (CollectionUtils.isEmpty(jobNames)) {
            return;
        }
        for (String jobName : jobNames) {
            String executorNode = JobNodePath.getServerNodePath(jobName, executorName);
            curatorFrameworkOp.deleteRecursive(executorNode);
        }
    }

    @Override
    public void shardAll(String namespace) throws SaturnJobConsoleException {
        CuratorRepository.CuratorFrameworkOp curatorFrameworkOp = this.getCuratorFrameworkOp(namespace);
        String shardAllAtOnceNodePath = ExecutorNodePath.getExecutorShardingNodePath("shardAllAtOnce");
        curatorFrameworkOp.deleteRecursive(shardAllAtOnceNodePath);
        curatorFrameworkOp.create(shardAllAtOnceNodePath);
    }

    @Override
    public void dump(String namespace, String executorName) throws SaturnJobConsoleException {
        CuratorRepository.CuratorFrameworkOp curatorFrameworkOp = this.getCuratorFrameworkOp(namespace);
        String version = curatorFrameworkOp.getData(ExecutorNodePath.getExecutorVersionNodePath(executorName));
        if (!this.isVersionSupportedDump(version)) {
            throw new SaturnJobConsoleException(2, "Saturn executor\u7248\u672c\u4f4e\u4e8e3.0.0\u65e0\u6cd5\u8fdb\u884c\u4e00\u952edump");
        }
        String dumpNodePath = ExecutorNodePath.getExecutorDumpNodePath(executorName);
        curatorFrameworkOp.delete(dumpNodePath);
        curatorFrameworkOp.create(dumpNodePath);
    }

    private boolean isVersionSupportedDump(String version) {
        if (SUPPORT_DUMP_VERSION_WHITE_LIST.contains(version)) {
            return true;
        }
        String[] items = version.split("\\.");
        if (items.length < 3) {
            return false;
        }
        int majorVersion = Integer.parseInt(items[0]);
        return majorVersion >= 3;
    }

    @Override
    public File dumpAsFile(String namespace, String executorName) throws SaturnJobConsoleException {
        throw new UnsupportedOperationException("this method is not supported yet");
    }

    @Override
    public void restart(String namespace, String executorName) throws SaturnJobConsoleException {
        CuratorRepository.CuratorFrameworkOp curatorFrameworkOp = this.getCuratorFrameworkOp(namespace);
        String restartNodePath = ExecutorNodePath.getExecutorRestartNodePath(executorName);
        curatorFrameworkOp.delete(restartNodePath);
        curatorFrameworkOp.create(restartNodePath);
    }

    private void validateIfExecutorNameExisted(String executorName, CuratorRepository.CuratorFrameworkOp curatorFrameworkOp) throws SaturnJobConsoleException {
        if (!curatorFrameworkOp.checkExists(ExecutorNodePath.getExecutorNodePath(executorName))) {
            throw new SaturnJobConsoleException("The executorName(" + executorName + ") is not existed.");
        }
    }

    protected CuratorRepository.CuratorFrameworkOp getCuratorFrameworkOp(String namespace) throws SaturnJobConsoleException {
        return this.registryCenterService.getCuratorFrameworkOp(namespace);
    }
}

