/*
 * Decompiled with CFR 0.152.
 */
package com.vip.saturn.job.console.service.impl;

import com.google.gson.Gson;
import com.vip.saturn.job.console.domain.NamespaceMigrationOverallStatus;
import com.vip.saturn.job.console.domain.NamespaceZkClusterMappingVo;
import com.vip.saturn.job.console.domain.ZkCluster;
import com.vip.saturn.job.console.exception.SaturnJobConsoleException;
import com.vip.saturn.job.console.mybatis.entity.JobConfig4DB;
import com.vip.saturn.job.console.mybatis.entity.NamespaceZkClusterMapping;
import com.vip.saturn.job.console.mybatis.entity.TemporarySharedStatus;
import com.vip.saturn.job.console.mybatis.entity.ZkClusterInfo;
import com.vip.saturn.job.console.mybatis.service.CurrentJobConfigService;
import com.vip.saturn.job.console.mybatis.service.NamespaceZkClusterMapping4SqlService;
import com.vip.saturn.job.console.mybatis.service.TemporarySharedStatusService;
import com.vip.saturn.job.console.mybatis.service.ZkClusterInfoService;
import com.vip.saturn.job.console.repository.zookeeper.CuratorRepository;
import com.vip.saturn.job.console.service.JobService;
import com.vip.saturn.job.console.service.NamespaceZkClusterMappingService;
import com.vip.saturn.job.console.service.RegistryCenterService;
import com.vip.saturn.job.console.utils.ConsoleThreadFactory;
import com.vip.saturn.job.console.utils.JobNodePath;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.zookeeper.CreateMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

public class NamespaceZkClusterMappingServiceImpl
implements NamespaceZkClusterMappingService {
    private static final Logger log = LoggerFactory.getLogger(NamespaceZkClusterMappingServiceImpl.class);
    @Resource
    private ZkClusterInfoService zkClusterInfoService;
    @Resource
    private NamespaceZkClusterMapping4SqlService namespaceZkclusterMapping4SqlService;
    @Resource
    private CuratorRepository curatorRepository;
    @Resource
    private CurrentJobConfigService currentJobConfigService;
    @Resource
    private JobService jobService;
    @Resource
    private RegistryCenterService registryCenterService;
    @Resource
    private TemporarySharedStatusService temporarySharedStatusService;
    private Gson gson = new Gson();
    private ExecutorService moveNamespaceBatchThreadPool;

    @PostConstruct
    public void init() {
        if (this.moveNamespaceBatchThreadPool != null) {
            this.moveNamespaceBatchThreadPool.shutdownNow();
        }
        this.moveNamespaceBatchThreadPool = Executors.newSingleThreadExecutor(new ConsoleThreadFactory("moveNamespaceBatchThread", false));
    }

    @PreDestroy
    public void destroy() {
        if (this.moveNamespaceBatchThreadPool != null) {
            this.moveNamespaceBatchThreadPool.shutdownNow();
        }
    }

    @Override
    public List<NamespaceZkClusterMappingVo> getNamespaceZkClusterMappingList() throws SaturnJobConsoleException {
        ArrayList<NamespaceZkClusterMappingVo> result = new ArrayList<NamespaceZkClusterMappingVo>();
        List<NamespaceZkClusterMapping> namespaceZkClusterMappingList = this.namespaceZkclusterMapping4SqlService.getAllMappings();
        if (namespaceZkClusterMappingList != null) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            for (NamespaceZkClusterMapping tmp : namespaceZkClusterMappingList) {
                try {
                    if (tmp.getIsDeleted() != 0) continue;
                    NamespaceZkClusterMappingVo vo = new NamespaceZkClusterMappingVo();
                    vo.setNamespace(tmp.getNamespace());
                    vo.setZkClusterKey(tmp.getZkClusterKey());
                    vo.setCreateTime(sdf.format(tmp.getCreateTime()));
                    vo.setCreatedBy(tmp.getCreatedBy());
                    vo.setLastUpdateTime(sdf.format(tmp.getLastUpdateTime()));
                    vo.setLastUpdatedBy(tmp.getLastUpdatedBy());
                    result.add(vo);
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return result;
    }

    @Override
    public void initNamespaceZkClusterMapping(String createdBy) throws SaturnJobConsoleException {
        try {
            List<ZkClusterInfo> allZkClusterInfo = this.zkClusterInfoService.getAllZkClusterInfo();
            if (allZkClusterInfo != null) {
                for (ZkClusterInfo zkClusterInfo : allZkClusterInfo) {
                    String zkClusterKey = zkClusterInfo.getZkClusterKey();
                    String connectString = zkClusterInfo.getConnectString();
                    CuratorFramework curatorFramework = null;
                    CuratorRepository.CuratorFrameworkOp curatorFrameworkOp = this.registryCenterService.connectOnly(connectString, null);
                    if (curatorFrameworkOp != null) {
                        curatorFramework = curatorFrameworkOp.getCuratorFramework();
                    }
                    if (curatorFramework == null) continue;
                    this.updateNamepsaceAndZKClusterMapping(createdBy, zkClusterKey, curatorFramework);
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new SaturnJobConsoleException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateNamepsaceAndZKClusterMapping(String createdBy, String zkClusterKey, CuratorFramework curatorFramework) throws Exception {
        try {
            List namespaces = (List)curatorFramework.getChildren().forPath("/");
            if (namespaces != null) {
                for (String namespace : namespaces) {
                    if (!this.registryCenterService.namespaceIsCorrect(namespace, curatorFramework)) continue;
                    this.namespaceZkclusterMapping4SqlService.insert(namespace, "", zkClusterKey, createdBy);
                }
            }
        }
        finally {
            curatorFramework.close();
        }
    }

    @Override
    public List<String> getZkClusterListWithOnline() throws SaturnJobConsoleException {
        ArrayList<String> zkClusterList = new ArrayList<String>();
        Collection<ZkCluster> tmp = this.registryCenterService.getZkClusterList();
        if (tmp != null) {
            for (ZkCluster next : tmp) {
                if (next.isOffline()) continue;
                zkClusterList.add(next.getZkClusterKey());
            }
        }
        return zkClusterList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(rollbackFor={SaturnJobConsoleException.class})
    public void migrateNamespaceToNewZk(String namespace, String zkClusterKeyNew, String lastUpdatedBy, boolean updateDBOnly) throws SaturnJobConsoleException {
        block15: {
            try {
                log.info("Start to migrate namespace: [{}] to zk cluster:[{}]", (Object)namespace, (Object)zkClusterKeyNew);
                if (updateDBOnly) {
                    this.namespaceZkclusterMapping4SqlService.update(namespace, null, zkClusterKeyNew, lastUpdatedBy);
                    break block15;
                }
                String zkClusterKey = this.namespaceZkclusterMapping4SqlService.getZkClusterKey(namespace);
                if (zkClusterKey != null && zkClusterKey.equals(zkClusterKeyNew)) {
                    throw new SaturnJobConsoleException("The namespace(" + namespace + ") is in " + zkClusterKey);
                }
                ZkCluster zkCluster = this.registryCenterService.getZkCluster(zkClusterKeyNew);
                if (zkCluster == null) {
                    throw new SaturnJobConsoleException("The " + zkClusterKeyNew + " is not exists");
                }
                if (zkCluster.isOffline()) {
                    throw new SaturnJobConsoleException("The " + zkClusterKeyNew + " zkCluster is offline");
                }
                String zkAddr = zkCluster.getZkAddr();
                CuratorRepository.CuratorFrameworkOp targetCuratorFrameworkOpByRoot = this.registryCenterService.connectOnly(zkAddr, null);
                if (targetCuratorFrameworkOpByRoot == null) {
                    throw new SaturnJobConsoleException("The " + zkClusterKeyNew + " zkCluster is offline");
                }
                CuratorFramework targetCuratorFrameworkByRoot = targetCuratorFrameworkOpByRoot.getCuratorFramework();
                CuratorRepository.CuratorFrameworkOp targetCuratorFrameworkOpByNamespace = this.registryCenterService.connectOnly(zkAddr, namespace);
                CuratorFramework targetCuratorFrameworkByNamespace = targetCuratorFrameworkOpByNamespace.getCuratorFramework();
                try {
                    String namespaceNodePath = "/" + namespace;
                    if (targetCuratorFrameworkByRoot.checkExists().forPath(namespaceNodePath) != null) {
                        targetCuratorFrameworkByRoot.delete().deletingChildrenIfNeeded().forPath(namespaceNodePath);
                    }
                    String jobsNodePath = namespaceNodePath + JobNodePath.get$JobsNodePath();
                    ((ACLBackgroundPathAndBytesable)targetCuratorFrameworkByRoot.create().creatingParentsIfNeeded().withMode(CreateMode.PERSISTENT)).forPath(jobsNodePath);
                    this.persistJobsToTargetZkCluster(namespace, targetCuratorFrameworkOpByNamespace);
                }
                finally {
                    targetCuratorFrameworkByRoot.close();
                    targetCuratorFrameworkByNamespace.close();
                }
                this.namespaceZkclusterMapping4SqlService.update(namespace, null, zkClusterKeyNew, lastUpdatedBy);
                log.info("Update zkcluster mapping between ns:[{}] and zk:[{}] in DB successfully", (Object)namespace, (Object)zkClusterKeyNew);
            }
            catch (SaturnJobConsoleException e) {
                log.error("Fail to migrate namespace:[" + namespace + "] to zk [" + zkClusterKeyNew + "]", (Throwable)e);
                throw e;
            }
            catch (Exception e) {
                log.error("Fail to migrate namespace:[" + namespace + "] to zk [" + zkClusterKeyNew + "] with unexpected exception", (Throwable)e);
                throw new SaturnJobConsoleException(e.getMessage(), e);
            }
            finally {
                log.info("Finish migrate namespace:[{}] to zk zkcluster:[{}]", (Object)namespace, (Object)zkClusterKeyNew);
            }
        }
    }

    private void persistJobsToTargetZkCluster(String namespace, CuratorRepository.CuratorFrameworkOp targetCuratorFrameworkOpByNamespace) throws SaturnJobConsoleException {
        List<JobConfig4DB> configs = this.currentJobConfigService.findConfigsByNamespace(namespace);
        log.debug("Obtain job config list of namespace:[{}] successfully", (Object)namespace);
        if (configs != null) {
            for (JobConfig4DB jobConfig : configs) {
                this.jobService.persistJobFromDB(jobConfig, targetCuratorFrameworkOpByNamespace);
                log.info("Migrate job:[{}] of namespace:[{}] to new zk (DB+ZK) successfully", (Object)jobConfig.getJobName(), (Object)namespace);
            }
        }
    }

    @Override
    public void migrateNamespaceListToNewZk(String namespaces, final String zkClusterKeyNew, final String lastUpdatedBy, final boolean updateDBOnly) throws SaturnJobConsoleException {
        final ArrayList<String> namespaceList = new ArrayList<String>();
        String[] split = namespaces.split(",");
        if (split != null) {
            for (String tmp : split) {
                String namespace = tmp.trim();
                if (namespace.isEmpty()) continue;
                namespaceList.add(namespace);
            }
        }
        int size = namespaceList.size();
        final NamespaceMigrationOverallStatus migrationStatus = new NamespaceMigrationOverallStatus(size);
        this.temporarySharedStatusService.delete("MOVE_NAMESPACE_BATCH_STATUS");
        this.temporarySharedStatusService.create("MOVE_NAMESPACE_BATCH_STATUS", this.gson.toJson((Object)migrationStatus));
        this.moveNamespaceBatchThreadPool.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    for (String namespace : namespaceList) {
                        try {
                            migrationStatus.setMoving(namespace);
                            NamespaceZkClusterMappingServiceImpl.this.temporarySharedStatusService.update("MOVE_NAMESPACE_BATCH_STATUS", NamespaceZkClusterMappingServiceImpl.this.gson.toJson((Object)migrationStatus));
                            NamespaceZkClusterMappingServiceImpl.this.migrateNamespaceToNewZk(namespace, zkClusterKeyNew, lastUpdatedBy, updateDBOnly);
                            migrationStatus.incrementSuccessCount();
                        }
                        catch (SaturnJobConsoleException e) {
                            log.info("Unable to migrate to new zk for some reason.", (Throwable)e);
                            if (("The namespace(" + namespace + ") is in " + zkClusterKeyNew).equals(e.getMessage())) {
                                migrationStatus.incrementIgnoreCount();
                                continue;
                            }
                            migrationStatus.incrementFailCount();
                        }
                        finally {
                            migrationStatus.setMoving("");
                            migrationStatus.decrementUnDoCount();
                            NamespaceZkClusterMappingServiceImpl.this.temporarySharedStatusService.update("MOVE_NAMESPACE_BATCH_STATUS", NamespaceZkClusterMappingServiceImpl.this.gson.toJson((Object)migrationStatus));
                        }
                    }
                }
                finally {
                    if (migrationStatus.getSuccessCount() > 0) {
                        try {
                            NamespaceZkClusterMappingServiceImpl.this.registryCenterService.notifyRefreshRegCenter();
                        }
                        catch (Exception e) {
                            log.error("Fail to refresh registry center.", (Throwable)e);
                        }
                    }
                    migrationStatus.setFinished(true);
                    NamespaceZkClusterMappingServiceImpl.this.temporarySharedStatusService.update("MOVE_NAMESPACE_BATCH_STATUS", NamespaceZkClusterMappingServiceImpl.this.gson.toJson((Object)migrationStatus));
                }
            }
        });
    }

    @Override
    public NamespaceMigrationOverallStatus getNamespaceMigrationOverallStatus() {
        TemporarySharedStatus temporarySharedStatus = this.temporarySharedStatusService.get("MOVE_NAMESPACE_BATCH_STATUS");
        if (temporarySharedStatus != null) {
            return (NamespaceMigrationOverallStatus)this.gson.fromJson(temporarySharedStatus.getStatusValue(), NamespaceMigrationOverallStatus.class);
        }
        return null;
    }

    @Override
    public void clearNamespaceMigrationOverallStatus() {
        this.temporarySharedStatusService.delete("MOVE_NAMESPACE_BATCH_STATUS");
    }
}

